/*
 * Nautilus Actions
 * A Nautilus extension which offers configurable context menu actions.
 *
 * Copyright (C) 2005 The GNOME Foundation
 * Copyright (C) 2006, 2007, 2008 Frederic Ruaudel and others (see AUTHORS)
 * Copyright (C) 2009 Pierre Wieser and others (see AUTHORS)
 *
 * This Program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this Library; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Frederic Ruaudel <grumz@grumz.net>
 *   Rodrigo Moya <rodrigo@gnome-db.org>
 *   Pierre Wieser <pwieser@trychlos.org>
 *   ... and many others (see AUTHORS)
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "na-about.h"

/* TODO: make the website url and the mail addresses clickables
 */
/**
 * na_about_display:
 * @window: the toplevel window which will be the parent of the
 * displayed dialog, or NULL.
 *
 * Displays the About dialog.
 */
void
na_about_display( GObject *toplevel )
{
	static const gchar *thisfn = "na_about_display";
	gchar *icon_name, *license_i18n;

	static const gchar *artists[] = {
		"Ulisse Perusin <uli.peru@gmail.com>",
		NULL
	};

	static const gchar *authors[] = {
		"Frederic Ruaudel <grumz@grumz.net>",
		"Rodrigo Moya <rodrigo@gnome-db.org>",
		"Pierre Wieser <pwieser@trychlos.org>",
		NULL
	};

	static const gchar *documenters[] = {
		NULL
	};

	static gchar *license[] = {
		N_( "Nautilus Actions Configuration Tool is free software; you can "
			"redistribute it and/or modify it under the terms of the GNU General "
			"Public License as published by the Free Software Foundation; either "
			"version 2 of the License, or (at your option) any later version." ),
		N_( "Nautilus Actions Configuration Tool is distributed in the hope that it "
			"will be useful, but WITHOUT ANY WARRANTY; without even the implied "
			"warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See "
			"the GNU General Public License for more details." ),
		N_( "You should have received a copy of the GNU General Public License along "
			"with Nautilus Actions Configuration Tool ; if not, write to the Free "
			"Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, "
			"MA 02110-1301, USA." ),
		NULL
	};

	g_debug( "%s: toplevel=%p", thisfn, ( void * ) toplevel );

	icon_name = na_about_get_icon_name();

	license_i18n = g_strjoinv( "\n\n", license );

	/*GtkWindow *toplevel = base_window_get_toplevel_dialog( BASE_WINDOW( window ));*/
	if( toplevel ){
		if( !GTK_IS_WINDOW( toplevel )){
			toplevel = NULL;
		}
	}

	gtk_show_about_dialog( GTK_WINDOW( toplevel ),
			"artists", artists,
			"authors", authors,
			"comments", _( "A graphical interface to create and edit your Nautilus actions." ),
			"copyright", _( "Copyright \xc2\xa9 2005-2007 Frederic Ruaudel <grumz@grumz.net>\nCopyright \xc2\xa9 2009 Pierre Wieser <pwieser@trychlos.org>" ),
			"documenters", documenters,
			"translator-credits", _( "The GNOME Translation Project <gnome-i18n@gnome.org>" ),
			"license", license_i18n,
			"wrap-license", TRUE,
			"logo-icon-name", icon_name,
			"version", PACKAGE_VERSION,
			"website", "http://www.nautilus-actions.org",
			NULL );

	g_free( license_i18n );
	g_free( icon_name );
}

/**
 * na_about_get_icon_name:
 *
 * Returns the name of the default icon for the application.
 */
gchar *
na_about_get_icon_name( void )
{
	return( g_strdup( PACKAGE ));
}
