%define ver 0.10
%define name mrproject

Summary: 	A graphical project management tool.
Name:           %name
Version:        %ver
Release:	imendio1
License: 	GPL
Group: 		Applications/Productivity
Url:		http://www.mrproject.org/
Source: 	%{name}-%{ver}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{ver}-root
Requires:	gtk2 >= 2.0.3
Requires:       libgnomeui >= 2.0.1
Requires:	popt >= 1.5
Requires:	libglade2 >= 2.0.0
Requires:       libmrproject = %{ver}
Requires:       gnome-vfs2 >= 2.0.2
Requires:       libgnomeprintui22 >= 2.2.0
Requires:       libxslt >= 1.0
PreReq:         scrollkeeper >= 0.3.10

BuildRequires:	gtk2-devel >= 2.0.3
BuildRequires:	libgnomeui-devel >= 2.0.1
BuildRequires:	libglade2-devel >= 2.0.0
BuildRequires:	libmrproject-devel = %{ver}
BuildRequires:  gnome-vfs2-devel >= 2.0.2
BuildRequires:  libgnomeprintui22-devel >= 2.2.0
BuildRequires:  libxslt-devel >= 1.0
BuildRequires:	intltool

%description
MrProject is a visual project management application which allows users to
manage several aspects of a project, including schedule tracking using
Gantt charts.

You should install MrProject if you wish to manage schedules, allocate
resources, and track the progress of your projects.

%package sql
Summary:	MrProject SQL plugin
Group:          Applications/Productivity
Requires:       %name = %{PACKAGE_VERSION}
Requires:       postgresql-libs
BuildRequires:  postgresql-devel

%description sql
SQL plugin for MrProject, this plugin can be used to store projects in a PostgreSQL database.

%prep
%setup -q

%build

intltoolize
%configure --disable-timetable --enable-postgres

make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%makeinstall MRP_PLUGINDIR=$RPM_BUILD_ROOT/%{_libdir}/mrproject/plugins MRP_VIEWDIR=$RPM_BUILD_ROOT/%{_libdir}/mrproject/views

rm -rf $RPM_BUILD_ROOT/var/scrollkeeper
rm -f $RPM_BUILD_ROOT%{_libdir}/mrproject/*/*la
rm -f $RPM_BUILD_ROOT%{_libdir}/mrproject/*la

desktop-file-install --vendor imendio --delete-original       \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications             \
  --add-category X-Red-Hat-Base                             \
  $RPM_BUILD_ROOT%{_datadir}/applications/mrproject.desktop


%find_lang %name


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
scrollkeeper-update

%postun
/sbin/ldconfig
scrollkeeper-update

%files -f %{name}.lang
%defattr(-, root, root)
%doc ChangeLog NEWS README COPYING
%{_bindir}/mrproject
%{_libdir}/mrproject
%{_datadir}/mrproject
%{_datadir}/gnome-2.0/ui/*.ui
%{_datadir}/application-registry/*
%{_datadir}/mime-info/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*
%{_datadir}/gnome/help/mrproject/*
%{_datadir}/omf/mrproject/*

%exclude %{_libdir}/mrproject/plugins/libproject-sql*
%exclude %{_datadir}/mrproject/glade/mg-sql.glade
%exclude %{_datadir}/gnome-2.0/ui/GNOME_MrProject_SQLPlugin.ui

%files sql
%defattr(-,root,root)
%{_libdir}/mrproject/plugins/libproject-sql*
%{_datadir}/mrproject/glade/mg-sql.glade
%{_datadir}/gnome-2.0/ui/GNOME_MrProject_SQLPlugin.ui


%changelog
* Thu Nov 18 2002 Mikael Hallendal <micke@codefactory.se>
- Release 0.7

* Thu Nov  7 2002 Mikael Hallendal <micke@codefactory.se>
- Fixed deps and 0.6.90

* Tue Aug 27 2002 Jonathan Blandford <jrb@redhat.com>
- Ungrab cursor

* Wed Aug 21 2002 Jonathan Blandford <jrb@redhat.com>
- clean up summary and description fields

* Wed Aug 14 2002 Jonathan Blandford <jrb@redhat.com>
- New bug fix version

* Tue Aug  6 2002 Jonathan Blandford <jrb@redhat.com>
- new version

* Mon Aug  5 2002 Jonathan Blandford <jrb@redhat.com>
- Switch Generic Name and Name, as I got this wrong

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed May 29 2002 Jonathan Blandford <jrb@redhat.com>
- Updated to 0.5.92

* Thu Feb 28 2002 Trond Eivind Glomsrd <teg@redhat.com> 0.5.1-8
- Use %%{_tmppath}
- Move changelog to end of specfile
- langify
- s/Copyright/License/
- Lose Vendor tag
- Lose evil macros before tags 
- Don't specify a wrong docdir


* Thu Feb 28 2002 Jonathan Blandford <jrb@redhat.com>
- Change Group to be a real one.
- add changelog
