/* SerialStreamRecorder.c generated by valac 0.12.1, the Vala compiler
 * generated from SerialStreamRecorder.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define MOSERIAL_TYPE_SERIAL_STREAM_RECORDER (moserial_serial_stream_recorder_get_type ())
#define MOSERIAL_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorder))
#define MOSERIAL_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))

typedef struct _moserialSerialStreamRecorder moserialSerialStreamRecorder;
typedef struct _moserialSerialStreamRecorderClass moserialSerialStreamRecorderClass;
typedef struct _moserialSerialStreamRecorderPrivate moserialSerialStreamRecorderPrivate;

#define MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION (moserial_serial_stream_recorder_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _moserialParamSpecSerialStreamRecorder moserialParamSpecSerialStreamRecorder;

struct _moserialSerialStreamRecorder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	moserialSerialStreamRecorderPrivate * priv;
};

struct _moserialSerialStreamRecorderClass {
	GTypeClass parent_class;
	void (*finalize) (moserialSerialStreamRecorder *self);
};

typedef enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH
} moserialSerialStreamRecorderDirection;

struct _moserialSerialStreamRecorderPrivate {
	GFile* file;
	gchar* uri;
	gboolean isOpen;
	GFileOutputStream* fos;
	moserialSerialStreamRecorderDirection direction;
};

struct _moserialParamSpecSerialStreamRecorder {
	GParamSpec parent_instance;
};


static gpointer moserial_serial_stream_recorder_parent_class = NULL;

gpointer moserial_serial_stream_recorder_ref (gpointer instance);
void moserial_serial_stream_recorder_unref (gpointer instance);
GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object);
void moserial_value_take_serial_stream_recorder (GValue* value, gpointer v_object);
gpointer moserial_value_get_serial_stream_recorder (const GValue* value);
GType moserial_serial_stream_recorder_get_type (void) G_GNUC_CONST;
GType moserial_serial_stream_recorder_direction_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderPrivate))
enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DUMMY_PROPERTY
};
void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const gchar* filename, moserialSerialStreamRecorderDirection direction, GError** error);
static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data);
static void moserial_serial_stream_recorder_write_array (moserialSerialStreamRecorder* self, guchar* data, int data_length1);
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data);
void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar* data, int data_length1);
void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch);
gint64 mo_utils_fileSize (const gchar* path);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type);
static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj);

const gchar* MOSERIAL_SERIAL_STREAM_RECORDER_DirectionStrings[3] = {"Incoming", "Outgoing", "Incoming and Outgoing"};

GType moserial_serial_stream_recorder_direction_get_type (void) {
	static volatile gsize moserial_serial_stream_recorder_direction_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_stream_recorder_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING", "incoming"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING", "outgoing"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH", "both"}, {0, NULL, NULL}};
		GType moserial_serial_stream_recorder_direction_type_id;
		moserial_serial_stream_recorder_direction_type_id = g_enum_register_static ("moserialSerialStreamRecorderDirection", values);
		g_once_init_leave (&moserial_serial_stream_recorder_direction_type_id__volatile, moserial_serial_stream_recorder_direction_type_id);
	}
	return moserial_serial_stream_recorder_direction_type_id__volatile;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const gchar* filename, moserialSerialStreamRecorderDirection direction, GError** error) {
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* _tmp2_;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_file_new_for_path (filename);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = g_file_replace (self->priv->file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	_g_object_unref0 (self->priv->fos);
	self->priv->fos = _tmp2_;
	self->priv->isOpen = TRUE;
	_tmp3_ = g_file_get_uri (self->priv->file);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp3_;
	self->priv->direction = direction;
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		self->priv->isOpen = FALSE;
		_g_object_unref0 (self->priv->file);
		self->priv->file = NULL;
		_g_object_unref0 (self->priv->fos);
		self->priv->fos = NULL;
		_tmp4_ = _g_error_copy0 (e);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->isOpen) {
		guchar* _tmp0_ = NULL;
		guchar* o;
		gint o_length1;
		gint _o_size_;
		_tmp0_ = g_new0 (guchar, 1);
		o = _tmp0_;
		o_length1 = 1;
		_o_size_ = 1;
		o[0] = data;
		g_output_stream_write ((GOutputStream*) self->priv->fos, o, (gsize) o_length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError * e;
			const gchar* _tmp1_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = _ ("error: %s\n");
			fprintf (stdout, _tmp1_, e->message);
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			o = (g_free (o), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		o = (g_free (o), NULL);
	}
}


static void moserial_serial_stream_recorder_write_array (moserialSerialStreamRecorder* self, guchar* data, int data_length1) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->isOpen) {
		g_output_stream_write ((GOutputStream*) self->priv->fos, data, (gsize) data_length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError * e;
			const gchar* _tmp0_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp0_ = _ ("error: %s\n");
			fprintf (stdout, _tmp0_, e->message);
			_g_error_free0 (e);
		}
		__finally11:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->isOpen) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		moserial_serial_stream_recorder_write (self, data);
	}
}


void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar* data, int data_length1) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->isOpen) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		moserial_serial_stream_recorder_write_array (self, data, data_length1);
	}
}


void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->isOpen) {
		gboolean _tmp1_ = FALSE;
		g_output_stream_flush ((GOutputStream*) self->priv->fos, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		g_output_stream_close ((GOutputStream*) self->priv->fos, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError * e;
			const gchar* _tmp0_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp0_ = _ ("error: %s\n");
			fprintf (stdout, _tmp0_, e->message);
			_g_error_free0 (e);
		}
		__finally12:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (launch) {
			gint64 _tmp2_;
			_tmp2_ = mo_utils_fileSize (self->priv->uri);
			_tmp1_ = _tmp2_ > 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gtk_show_uri (NULL, self->priv->uri, (guint32) GDK_CURRENT_TIME, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			goto __finally13;
			__catch13_g_error:
			{
				GError * e;
				const gchar* _tmp3_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp3_ = _ ("Unable to launch %s: %s");
				g_warning (_tmp3_, self->priv->uri, e->message);
				_g_error_free0 (e);
			}
			__finally13:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (self->priv->fos);
		self->priv->fos = NULL;
		_g_object_unref0 (self->priv->file);
		self->priv->file = NULL;
		self->priv->isOpen = FALSE;
	}
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type) {
	moserialSerialStreamRecorder* self = NULL;
	self = (moserialSerialStreamRecorder*) g_type_create_instance (object_type);
	return self;
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void) {
	return moserial_serial_stream_recorder_construct (MOSERIAL_TYPE_SERIAL_STREAM_RECORDER);
}


static void moserial_value_serial_stream_recorder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void moserial_value_serial_stream_recorder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		moserial_serial_stream_recorder_unref (value->data[0].v_pointer);
	}
}


static void moserial_value_serial_stream_recorder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = moserial_serial_stream_recorder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer moserial_value_serial_stream_recorder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* moserial_value_serial_stream_recorder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		moserialSerialStreamRecorder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = moserial_serial_stream_recorder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* moserial_value_serial_stream_recorder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	moserialSerialStreamRecorder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	moserialParamSpecSerialStreamRecorder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer moserial_value_get_serial_stream_recorder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	return value->data[0].v_pointer;
}


void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object) {
	moserialSerialStreamRecorder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		moserial_serial_stream_recorder_unref (old);
	}
}


void moserial_value_take_serial_stream_recorder (GValue* value, gpointer v_object) {
	moserialSerialStreamRecorder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		moserial_serial_stream_recorder_unref (old);
	}
}


static void moserial_serial_stream_recorder_class_init (moserialSerialStreamRecorderClass * klass) {
	moserial_serial_stream_recorder_parent_class = g_type_class_peek_parent (klass);
	MOSERIAL_SERIAL_STREAM_RECORDER_CLASS (klass)->finalize = moserial_serial_stream_recorder_finalize;
	g_type_class_add_private (klass, sizeof (moserialSerialStreamRecorderPrivate));
}


static void moserial_serial_stream_recorder_instance_init (moserialSerialStreamRecorder * self) {
	self->priv = MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE (self);
	self->priv->isOpen = FALSE;
	self->ref_count = 1;
}


static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj) {
	moserialSerialStreamRecorder * self;
	self = MOSERIAL_SERIAL_STREAM_RECORDER (obj);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->uri);
	_g_object_unref0 (self->priv->fos);
}


GType moserial_serial_stream_recorder_get_type (void) {
	static volatile gsize moserial_serial_stream_recorder_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_stream_recorder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { moserial_value_serial_stream_recorder_init, moserial_value_serial_stream_recorder_free_value, moserial_value_serial_stream_recorder_copy_value, moserial_value_serial_stream_recorder_peek_pointer, "p", moserial_value_serial_stream_recorder_collect_value, "p", moserial_value_serial_stream_recorder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialStreamRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_stream_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialStreamRecorder), 0, (GInstanceInitFunc) moserial_serial_stream_recorder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType moserial_serial_stream_recorder_type_id;
		moserial_serial_stream_recorder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "moserialSerialStreamRecorder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&moserial_serial_stream_recorder_type_id__volatile, moserial_serial_stream_recorder_type_id);
	}
	return moserial_serial_stream_recorder_type_id__volatile;
}


gpointer moserial_serial_stream_recorder_ref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void moserial_serial_stream_recorder_unref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



