/* SettingsDialog.c generated by valac 0.12.1, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	GtkBuilder* _builder;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBox* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* deviceModel;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;

GType moserial_settings_dialog_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_BUILDER
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self);
static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void moserial_settings_dialog_finalize (GObject* obj);
static void _vala_moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* SETTINGS_BaudRateItems[16];
extern const gchar* SETTINGS_DataBitItems[4];
extern const gchar* SETTINGS_StopBitItems[2];
extern const gchar* SETTINGS_ParityModeStrings[5];
extern const gchar* SETTINGS_AccessModeStrings[3];

moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder) {
	moserialSettingsDialog * self = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	self = (moserialSettingsDialog*) g_object_new (object_type, "builder", builder, NULL);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, builder);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	_tmp0_ = g_strdup ("/dev/ttyS");
	deviceTypes = g_list_append (deviceTypes, _tmp0_);
	_tmp1_ = g_strdup ("/dev/ttyUSB");
	deviceTypes = g_list_append (deviceTypes, _tmp1_);
	_tmp2_ = g_strdup ("/dev/ttyACM");
	deviceTypes = g_list_append (deviceTypes, _tmp2_);
	_tmp3_ = g_strdup ("/dev/rfcomm");
	deviceTypes = g_list_append (deviceTypes, _tmp3_);
	_tmp4_ = g_strdup ("/dev/cuaU");
	deviceTypes = g_list_append (deviceTypes, _tmp4_);
	_tmp5_ = g_strdup ("/dev/cua");
	deviceTypes = g_list_append (deviceTypes, _tmp5_);
	gtk_list_store_clear (self->priv->deviceModel);
	{
		GList* devType_collection;
		GList* devType_it;
		devType_collection = deviceTypes;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			gchar* _tmp6_;
			gchar* devType;
			_tmp6_ = g_strdup ((const gchar*) devType_it->data);
			devType = _tmp6_;
			{
				{
					gint i;
					i = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gchar* _tmp8_ = NULL;
							gchar* dev;
							gboolean _tmp9_;
							if (!_tmp7_) {
								i++;
							}
							_tmp7_ = FALSE;
							if (!(i < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							_tmp8_ = g_strdup_printf ("%s%d", devType, i);
							dev = _tmp8_;
							_tmp9_ = g_file_test (dev, G_FILE_TEST_EXISTS);
							if (_tmp9_) {
								GtkTreeIter _tmp10_ = {0};
								gtk_list_store_append (self->priv->deviceModel, &_tmp10_);
								iter = _tmp10_;
								gtk_list_store_set (self->priv->deviceModel, &iter, 0, dev, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	__g_list_free__g_free0_0 (deviceTypes);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp0_;
	moserial_settings_dialog_loadSettings (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t = NULL;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	gboolean _tmp11_;
	GtkTreeModel* _tmp19_ = NULL;
	GtkTreeModel* _tmp20_;
	GtkTreeIter _tmp21_ = {0};
	gboolean _tmp22_;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_;
	GtkTreeIter _tmp32_ = {0};
	gboolean _tmp33_;
	SettingsParity _tmp41_;
	SettingsAccessMode _tmp42_;
	gboolean _tmp43_ = FALSE;
	SettingsHandshake _tmp44_;
	gboolean _tmp46_ = FALSE;
	SettingsHandshake _tmp47_;
	gboolean _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->deviceCombo);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (t);
	t = _tmp1_;
	_tmp3_ = gtk_tree_model_get_iter_first (t, &_tmp2_);
	ti = _tmp2_;
	success = _tmp3_;
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp4_ = {0};
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp4_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp4_;
		_tmp5_ = g_value_get_string (&str_data);
		_tmp6_ = settings_get_device (self->priv->currentSettings);
		if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
			gtk_combo_box_set_active_iter (self->priv->deviceCombo, &ti);
		}
		_tmp7_ = gtk_tree_model_iter_next (t, &ti);
		success = _tmp7_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp8_ = gtk_combo_box_get_model (self->priv->baudRateCombo);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (t);
	t = _tmp9_;
	_tmp11_ = gtk_tree_model_get_iter_first (t, &_tmp10_);
	ti = _tmp10_;
	success = _tmp11_;
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp12_ = {0};
		const gchar* _tmp13_ = NULL;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp12_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp12_;
		_tmp13_ = g_value_get_string (&str_data);
		_tmp14_ = settings_get_baudRate (self->priv->currentSettings);
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
		_g_free0 (_tmp16_);
		if (_tmp17_) {
			gtk_combo_box_set_active_iter (self->priv->baudRateCombo, &ti);
		}
		_tmp18_ = gtk_tree_model_iter_next (t, &ti);
		success = _tmp18_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp19_ = gtk_combo_box_get_model (self->priv->dataBitsCombo);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (t);
	t = _tmp20_;
	_tmp22_ = gtk_tree_model_get_iter_first (t, &_tmp21_);
	ti = _tmp21_;
	success = _tmp22_;
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp23_ = {0};
		const gchar* _tmp24_ = NULL;
		gint _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp23_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp23_;
		_tmp24_ = g_value_get_string (&str_data);
		_tmp25_ = settings_get_dataBits (self->priv->currentSettings);
		_tmp26_ = g_strdup_printf ("%i", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strcmp0 (_tmp24_, _tmp27_) == 0;
		_g_free0 (_tmp27_);
		if (_tmp28_) {
			gtk_combo_box_set_active_iter (self->priv->dataBitsCombo, &ti);
		}
		_tmp29_ = gtk_tree_model_iter_next (t, &ti);
		success = _tmp29_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp30_ = gtk_combo_box_get_model (self->priv->stopBitsCombo);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (t);
	t = _tmp31_;
	_tmp33_ = gtk_tree_model_get_iter_first (t, &_tmp32_);
	ti = _tmp32_;
	success = _tmp33_;
	while (TRUE) {
		GValue str_data = {0};
		GValue _tmp34_ = {0};
		const gchar* _tmp35_ = NULL;
		gint _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		if (!success) {
			break;
		}
		gtk_tree_model_get_value (t, &ti, 0, &_tmp34_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp34_;
		_tmp35_ = g_value_get_string (&str_data);
		_tmp36_ = settings_get_stopBits (self->priv->currentSettings);
		_tmp37_ = g_strdup_printf ("%i", _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strcmp0 (_tmp35_, _tmp38_) == 0;
		_g_free0 (_tmp38_);
		if (_tmp39_) {
			gtk_combo_box_set_active_iter (self->priv->stopBitsCombo, &ti);
		}
		_tmp40_ = gtk_tree_model_iter_next (t, &ti);
		success = _tmp40_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp41_ = settings_get_parity (self->priv->currentSettings);
	gtk_combo_box_set_active (self->priv->parityCombo, (gint) _tmp41_);
	_tmp42_ = settings_get_accessMode (self->priv->currentSettings);
	gtk_combo_box_set_active (self->priv->accessModeCombo, (gint) _tmp42_);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, FALSE);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, FALSE);
	_tmp44_ = settings_get_handshake (self->priv->currentSettings);
	if (_tmp44_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp43_ = TRUE;
	} else {
		SettingsHandshake _tmp45_;
		_tmp45_ = settings_get_handshake (self->priv->currentSettings);
		_tmp43_ = _tmp45_ == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp43_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, TRUE);
	}
	_tmp47_ = settings_get_handshake (self->priv->currentSettings);
	if (_tmp47_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp46_ = TRUE;
	} else {
		SettingsHandshake _tmp48_;
		_tmp48_ = settings_get_handshake (self->priv->currentSettings);
		_tmp46_ = _tmp48_ == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp46_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, TRUE);
	}
	_tmp49_ = settings_get_localEcho (self->priv->currentSettings);
	if (_tmp49_) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, FALSE);
	}
	_g_object_unref0 (t);
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = NULL;
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	gchar* device = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	GtkTreeModel* t = NULL;
	GtkTreeIter iter = {0};
	gboolean success = FALSE;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	gboolean _tmp21_;
	Settings* _tmp22_ = NULL;
	Settings* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->deviceCombo);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (t);
	t = _tmp1_;
	_tmp3_ = gtk_combo_box_get_active_iter (self->priv->deviceCombo, &_tmp2_);
	iter = _tmp2_;
	success = _tmp3_;
	if (success) {
		GValue str_data = {0};
		GValue _tmp4_ = {0};
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gtk_tree_model_get_value (t, &iter, 0, &_tmp4_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp4_;
		_tmp5_ = g_value_get_string (&str_data);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (device);
		device = _tmp6_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (settings_DEFAULT_DEVICEFILE);
		_g_free0 (device);
		device = _tmp7_;
	}
	_tmp8_ = gtk_combo_box_get_active (self->priv->baudRateCombo);
	_tmp9_ = atoi (SETTINGS_BaudRateItems[_tmp8_]);
	baudRate = _tmp9_;
	_tmp10_ = gtk_combo_box_get_active (self->priv->dataBitsCombo);
	_tmp11_ = atoi (SETTINGS_DataBitItems[_tmp10_]);
	dataBits = _tmp11_;
	_tmp12_ = gtk_combo_box_get_active (self->priv->stopBitsCombo);
	_tmp13_ = atoi (SETTINGS_StopBitItems[_tmp12_]);
	stopBits = _tmp13_;
	_tmp14_ = gtk_combo_box_get_active (self->priv->parityCombo);
	parity = (SettingsParity) _tmp14_;
	_tmp15_ = gtk_combo_box_get_active (self->priv->accessModeCombo);
	accessMode = (SettingsAccessMode) _tmp15_;
	_tmp17_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake);
	if (_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake);
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		gboolean _tmp19_;
		_tmp19_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake);
		if (_tmp19_) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			gboolean _tmp20_;
			_tmp20_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake);
			if (_tmp20_) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	_tmp21_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->localEcho);
	pLocalEcho = _tmp21_;
	_tmp22_ = settings_new (device, baudRate, dataBits, stopBits, parity, handshake, accessMode, pLocalEcho);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp22_;
	_tmp23_ = _g_object_ref0 (self->priv->settings);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp23_;
	g_signal_emit_by_name (self, "update-settings", self->priv->currentSettings);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	_g_object_unref0 (t);
	_g_free0 (device);
}


GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_builder);
	self->priv->_builder = _tmp0_;
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = moserial_settings_dialog_hide (self);
	return result;
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel (self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok (self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	GObject* _tmp0_ = NULL;
	GtkDialog* _tmp1_;
	GObject* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GObject* _tmp6_ = NULL;
	GtkComboBox* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkComboBox* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkComboBox* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkComboBox* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_;
	const gchar* _tmp16_ = NULL;
	GObject* _tmp17_ = NULL;
	GtkCheckButton* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkComboBox* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkCheckButton* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkComboBox* _tmp26_;
	GtkListStore* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkCellRenderer* deviceCell;
	parent_class = G_OBJECT_CLASS (moserial_settings_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	_tmp0_ = gtk_builder_get_object (self->priv->_builder, "settings_dialog");
	_tmp1_ = _g_object_ref0 (GTK_DIALOG (_tmp0_));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp1_;
	_tmp2_ = gtk_builder_get_object (self->priv->_builder, "settings_cancel_button");
	_tmp3_ = _g_object_ref0 (GTK_BUTTON (_tmp2_));
	_g_object_unref0 (self->priv->cancelButton);
	self->priv->cancelButton = _tmp3_;
	_tmp4_ = gtk_builder_get_object (self->priv->_builder, "settings_ok_button");
	_tmp5_ = _g_object_ref0 (GTK_BUTTON (_tmp4_));
	_g_object_unref0 (self->priv->okButton);
	self->priv->okButton = _tmp5_;
	_tmp6_ = gtk_builder_get_object (self->priv->_builder, "settings_baud_rate");
	_tmp7_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp6_));
	_g_object_unref0 (self->priv->baudRateCombo);
	self->priv->baudRateCombo = _tmp7_;
	mo_utils_populateComboBox (self->priv->baudRateCombo, SETTINGS_BaudRateItems, G_N_ELEMENTS (SETTINGS_BaudRateItems));
	_tmp8_ = gtk_builder_get_object (self->priv->_builder, "settings_data_bits");
	_tmp9_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp8_));
	_g_object_unref0 (self->priv->dataBitsCombo);
	self->priv->dataBitsCombo = _tmp9_;
	mo_utils_populateComboBox (self->priv->dataBitsCombo, SETTINGS_DataBitItems, G_N_ELEMENTS (SETTINGS_DataBitItems));
	_tmp10_ = gtk_builder_get_object (self->priv->_builder, "settings_stop_bits");
	_tmp11_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp10_));
	_g_object_unref0 (self->priv->stopBitsCombo);
	self->priv->stopBitsCombo = _tmp11_;
	mo_utils_populateComboBox (self->priv->stopBitsCombo, SETTINGS_StopBitItems, G_N_ELEMENTS (SETTINGS_StopBitItems));
	_tmp12_ = gtk_builder_get_object (self->priv->_builder, "settings_parity");
	_tmp13_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp12_));
	_g_object_unref0 (self->priv->parityCombo);
	self->priv->parityCombo = _tmp13_;
	mo_utils_populateComboBox (self->priv->parityCombo, SETTINGS_ParityModeStrings, G_N_ELEMENTS (SETTINGS_ParityModeStrings));
	_tmp14_ = gtk_builder_get_object (self->priv->_builder, "settings_hardware_handshake");
	_tmp15_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp14_));
	_g_object_unref0 (self->priv->hardwareHandshake);
	self->priv->hardwareHandshake = _tmp15_;
	_tmp16_ = _ ("Also known as RTS/CTS handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->hardwareHandshake, _tmp16_);
	_tmp17_ = gtk_builder_get_object (self->priv->_builder, "settings_software_handshake");
	_tmp18_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp17_));
	_g_object_unref0 (self->priv->softwareHandshake);
	self->priv->softwareHandshake = _tmp18_;
	_tmp19_ = _ ("Also known as XON/XOFF handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->softwareHandshake, _tmp19_);
	_tmp20_ = gtk_builder_get_object (self->priv->_builder, "settings_open_for");
	_tmp21_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp20_));
	_g_object_unref0 (self->priv->accessModeCombo);
	self->priv->accessModeCombo = _tmp21_;
	mo_utils_populateComboBox (self->priv->accessModeCombo, SETTINGS_AccessModeStrings, G_N_ELEMENTS (SETTINGS_AccessModeStrings));
	_tmp22_ = gtk_builder_get_object (self->priv->_builder, "settings_local_echo");
	_tmp23_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp22_));
	_g_object_unref0 (self->priv->localEcho);
	self->priv->localEcho = _tmp23_;
	_tmp24_ = _ ("Normally disabled");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->localEcho, _tmp24_);
	g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
	g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
	_tmp25_ = gtk_builder_get_object (self->priv->_builder, "settings_device");
	_tmp26_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp25_));
	_g_object_unref0 (self->priv->deviceCombo);
	self->priv->deviceCombo = _tmp26_;
	_tmp27_ = gtk_list_store_new (1, G_TYPE_STRING);
	_g_object_unref0 (self->priv->deviceModel);
	self->priv->deviceModel = _tmp27_;
	gtk_combo_box_set_model (self->priv->deviceCombo, (GtkTreeModel*) self->priv->deviceModel);
	_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	deviceCell = (GtkCellRenderer*) g_object_ref_sink (_tmp28_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->deviceCombo, deviceCell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->deviceCombo, deviceCell, "text", 0, NULL);
	_g_object_unref0 (deviceCell);
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SETTINGS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->deviceModel);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}


static void _vala_moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_settings_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		moserial_settings_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



