/* MoUtils.c generated by valac 0.12.1, the Vala compiler
 * generated from MoUtils.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gtk/gtk.h>


#define TYPE_MO_UTILS (mo_utils_get_type ())
#define MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MO_UTILS, MoUtils))
#define MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MO_UTILS, MoUtilsClass))
#define IS_MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MO_UTILS))
#define IS_MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MO_UTILS))
#define MO_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MO_UTILS, MoUtilsClass))

typedef struct _MoUtils MoUtils;
typedef struct _MoUtilsClass MoUtilsClass;
typedef struct _MoUtilsPrivate MoUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _MoUtils {
	GObject parent_instance;
	MoUtilsPrivate * priv;
};

struct _MoUtilsClass {
	GObjectClass parent_class;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer mo_utils_parent_class = NULL;

GType mo_utils_get_type (void) G_GNUC_CONST;
enum  {
	MO_UTILS_DUMMY_PROPERTY
};
GFile* mo_utils_newFile (const gchar* path);
gboolean mo_utils_fileExists (const gchar* path);
gint64 mo_utils_fileSize (const gchar* path);
gchar* mo_utils_getParentFolder (const gchar* path);
GType profile_get_type (void) G_GNUC_CONST;
gchar* mo_utils_getKeyString (Profile* profile, const gchar* group, const gchar* key);
gint mo_utils_getKeyInteger (Profile* profile, const gchar* group, const gchar* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const gchar* group, const gchar* key, gboolean default_val);
gchar* mo_utils_getLastMessage (const gchar* messages);
gchar* input_parser_statusReplace (const gchar* oldString);
void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1);
MoUtils* mo_utils_new (void);
MoUtils* mo_utils_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


GFile* mo_utils_newFile (const gchar* path) {
	GFile* result = NULL;
	gchar* uri = NULL;
	gboolean _tmp0_;
	GFile* _tmp3_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = string_contains (path, "://");
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (path);
		_g_free0 (uri);
		uri = _tmp1_;
	} else {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup_printf ("file://%s", path);
		_g_free0 (uri);
		uri = _tmp2_;
	}
	_tmp3_ = g_file_new_for_uri (uri);
	result = _tmp3_;
	_g_free0 (uri);
	return result;
}


gboolean mo_utils_fileExists (const gchar* path) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* file;
	gboolean _tmp1_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	_tmp1_ = g_file_query_exists (file, NULL);
	result = _tmp1_;
	_g_object_unref0 (file);
	return result;
}


gint64 mo_utils_fileSize (const gchar* path) {
	gint64 result = 0LL;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* info;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, 0LL);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &_inner_error_);
	info = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch30_g_error;
	}
	_tmp2_ = g_file_info_get_size (info);
	result = _tmp2_;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
	_g_object_unref0 (info);
	goto __finally30;
	__catch30_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("MoUtils.vala:45: %s", e->message);
		_g_error_free0 (e);
	}
	__finally30:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0LL;
	}
	result = (gint64) 0;
	_g_object_unref0 (file);
	return result;
}


gchar* mo_utils_getParentFolder (const gchar* path) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFile* _tmp1_ = NULL;
	GFile* parent;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	_tmp1_ = g_file_get_parent (file);
	parent = _tmp1_;
	_tmp2_ = g_file_get_parse_name (parent);
	result = _tmp2_;
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
	return result;
}


gchar* mo_utils_getKeyString (Profile* profile, const gchar* group, const gchar* key) {
	gchar* result = NULL;
	gchar* _result_;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (profile != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = g_key_file_get_string (profile->keyFile, group, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch31_g_key_file_error;
		}
		_g_free0 (_result_);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (_result_);
	_result_ = _tmp1_;
	goto __finally31;
	__catch31_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	return result;
}


gint mo_utils_getKeyInteger (Profile* profile, const gchar* group, const gchar* key, gint default_val) {
	gint result = 0;
	gint _result_;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (profile != NULL, 0);
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_result_ = default_val;
	_tmp0_ = g_key_file_get_integer (profile->keyFile, group, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch32_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_result_ = _tmp1_;
	goto __finally32;
	__catch32_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = _result_;
	return result;
}


gboolean mo_utils_getKeyBoolean (Profile* profile, const gchar* group, const gchar* key, gboolean default_val) {
	gboolean result = FALSE;
	gboolean _result_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (profile != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_result_ = default_val;
	_tmp0_ = g_key_file_get_boolean (profile->keyFile, group, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch33_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_result_ = _tmp1_;
	goto __finally33;
	__catch33_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _result_;
	return result;
}


gchar* mo_utils_getLastMessage (const gchar* messages) {
	gchar* result = NULL;
	gchar* message;
	gchar* _tmp0_ = NULL;
	gchar* escaped;
	gchar* _tmp1_ = NULL;
	gchar** splitMessages = NULL;
	gint splitMessages_length1 = 0;
	gint _splitMessages_size_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	message = NULL;
	_tmp0_ = g_strescape (messages, "");
	escaped = _tmp0_;
	_tmp1_ = input_parser_statusReplace (escaped);
	_g_free0 (escaped);
	escaped = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (escaped, "\\n", 20);
	splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL);
	splitMessages = _tmp3_;
	splitMessages_length1 = _vala_array_length (_tmp2_);
	_splitMessages_size_ = _vala_array_length (_tmp2_);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp5_;
				gint _tmp6_;
				if (!_tmp4_) {
					x++;
				}
				_tmp4_ = FALSE;
				_tmp5_ = g_strv_length (splitMessages);
				if (!(x < _tmp5_)) {
					break;
				}
				_tmp6_ = strlen (splitMessages[x]);
				if (_tmp6_ > 5) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup (splitMessages[x]);
					_g_free0 (message);
					message = _tmp7_;
				}
			}
		}
	}
	result = message;
	splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (escaped);
	return result;
}


void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* Model;
	GtkCellRendererText* _tmp3_ = NULL;
	GtkCellRenderer* Cell;
	g_return_if_fail (Combo != NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
	Model = _tmp0_;
	{
		gchar** val_item_collection;
		int val_item_collection_length1;
		int val_item_it;
		val_item_collection = val_array;
		val_item_collection_length1 = val_array_length1;
		for (val_item_it = 0; val_item_it < val_array_length1; val_item_it = val_item_it + 1) {
			gchar* _tmp1_;
			gchar* val_item;
			_tmp1_ = g_strdup (val_item_collection[val_item_it]);
			val_item = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp2_ = {0};
				gtk_list_store_append (Model, &_tmp2_);
				iter = _tmp2_;
				gtk_list_store_set (Model, &iter, 0, val_item, -1);
				_g_free0 (val_item);
			}
		}
	}
	gtk_combo_box_set_model (Combo, (GtkTreeModel*) Model);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	Cell = (GtkCellRenderer*) g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) Combo, Cell, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) Combo, Cell, "text", 0, NULL);
	_g_object_unref0 (Cell);
	_g_object_unref0 (Model);
}


MoUtils* mo_utils_construct (GType object_type) {
	MoUtils * self = NULL;
	self = (MoUtils*) g_object_new (object_type, NULL);
	return self;
}


MoUtils* mo_utils_new (void) {
	return mo_utils_construct (TYPE_MO_UTILS);
}


static void mo_utils_class_init (MoUtilsClass * klass) {
	mo_utils_parent_class = g_type_class_peek_parent (klass);
}


static void mo_utils_instance_init (MoUtils * self) {
}


GType mo_utils_get_type (void) {
	static volatile gsize mo_utils_type_id__volatile = 0;
	if (g_once_init_enter (&mo_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MoUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mo_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoUtils), 0, (GInstanceInitFunc) mo_utils_instance_init, NULL };
		GType mo_utils_type_id;
		mo_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "MoUtils", &g_define_type_info, 0);
		g_once_init_leave (&mo_utils_type_id__volatile, mo_utils_type_id);
	}
	return mo_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



