/* InputParser.c generated by valac 0.12.1, the Vala compiler
 * generated from InputParser.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};


static gpointer input_parser_parent_class = NULL;

GQuark hex_parse_error_quark (void);
GType input_parser_get_type (void) G_GNUC_CONST;
enum  {
	INPUT_PARSER_DUMMY_PROPERTY
};
gchar* input_parser_statusReplace (const gchar* oldString);
guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error);
static gchar input_parser_xtoi (gunichar c);
InputParser* input_parser_new (void);
InputParser* input_parser_construct (GType object_type);


GQuark hex_parse_error_quark (void) {
	return g_quark_from_static_string ("hex_parse_error-quark");
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* input_parser_statusReplace (const gchar* oldString) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (oldString != NULL, NULL);
	_tmp0_ = string_replace (oldString, "\\r", "\\n");
	result = _tmp0_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error) {
	guchar* result = NULL;
	gint _tmp0_;
	glong len;
	guchar* _tmp1_ = NULL;
	guchar* r;
	gint r_length1;
	gint _r_size_;
	guchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = strlen (s);
	len = (glong) _tmp0_;
	_tmp1_ = g_new0 (guchar, (len + 1) / 2);
	r = _tmp1_;
	r_length1 = (len + 1) / 2;
	_r_size_ = (len + 1) / 2;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gunichar c = 0U;
				gint i = 0;
				gint temp = 0;
				gunichar _tmp3_;
				const gchar* _tmp15_ = NULL;
				if (!_tmp2_) {
					x++;
				}
				_tmp2_ = FALSE;
				if (!(x < ((len + 1) / 2))) {
					break;
				}
				_tmp3_ = string_get_char (s, (glong) 0);
				c = _tmp3_;
				if (len > 1) {
					gchar _tmp4_;
					const gchar* _tmp7_ = NULL;
					gunichar _tmp8_;
					gchar _tmp9_;
					_tmp4_ = input_parser_xtoi (c);
					i = _tmp4_ * 16;
					if (i < 0) {
						const gchar* _tmp5_ = NULL;
						GError* _tmp6_ = NULL;
						_tmp5_ = _ ("Invalid Input");
						_tmp6_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp5_);
						_inner_error_ = _tmp6_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp7_ = g_utf8_next_char (s);
					s = _tmp7_;
					_tmp8_ = string_get_char (s, (glong) 0);
					c = _tmp8_;
					_tmp9_ = input_parser_xtoi (c);
					temp = (gint) _tmp9_;
					if (temp < 0) {
						const gchar* _tmp10_ = NULL;
						GError* _tmp11_ = NULL;
						_tmp10_ = _ ("Invalid Input");
						_tmp11_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp10_);
						_inner_error_ = _tmp11_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					i = i + temp;
				} else {
					gchar _tmp12_;
					_tmp12_ = input_parser_xtoi (c);
					i = (gint) _tmp12_;
					if (i < 0) {
						const gchar* _tmp13_ = NULL;
						GError* _tmp14_ = NULL;
						_tmp13_ = _ ("Invalid Input");
						_tmp14_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp13_);
						_inner_error_ = _tmp14_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				_tmp15_ = g_utf8_next_char (s);
				s = _tmp15_;
				r[x] = (guchar) i;
			}
		}
	}
	_tmp16_ = r;
	if (result_length1) {
		*result_length1 = r_length1;
	}
	result = _tmp16_;
	return result;
}


static gchar input_parser_xtoi (gunichar c) {
	gchar result = '\0';
	gchar i;
	i = (gchar) (-1);
	switch (c) {
		case '0':
		{
			i = (gchar) 0;
			break;
		}
		case '1':
		{
			i = (gchar) 1;
			break;
		}
		case '2':
		{
			i = (gchar) 2;
			break;
		}
		case '3':
		{
			i = (gchar) 3;
			break;
		}
		case '4':
		{
			i = (gchar) 4;
			break;
		}
		case '5':
		{
			i = (gchar) 5;
			break;
		}
		case '6':
		{
			i = (gchar) 6;
			break;
		}
		case '7':
		{
			i = (gchar) 7;
			break;
		}
		case '8':
		{
			i = (gchar) 8;
			break;
		}
		case '9':
		{
			i = (gchar) 9;
			break;
		}
		case 'a':
		{
			i = (gchar) 10;
			break;
		}
		case 'b':
		{
			i = (gchar) 11;
			break;
		}
		case 'c':
		{
			i = (gchar) 12;
			break;
		}
		case 'd':
		{
			i = (gchar) 13;
			break;
		}
		case 'e':
		{
			i = (gchar) 14;
			break;
		}
		case 'f':
		{
			i = (gchar) 15;
			break;
		}
		case 'A':
		{
			i = (gchar) 10;
			break;
		}
		case 'B':
		{
			i = (gchar) 11;
			break;
		}
		case 'C':
		{
			i = (gchar) 12;
			break;
		}
		case 'D':
		{
			i = (gchar) 13;
			break;
		}
		case 'E':
		{
			i = (gchar) 14;
			break;
		}
		case 'F':
		{
			i = (gchar) 15;
			break;
		}
		default:
		break;
	}
	result = i;
	return result;
}


InputParser* input_parser_construct (GType object_type) {
	InputParser * self = NULL;
	self = (InputParser*) g_object_new (object_type, NULL);
	return self;
}


InputParser* input_parser_new (void) {
	return input_parser_construct (TYPE_INPUT_PARSER);
}


static void input_parser_class_init (InputParserClass * klass) {
	input_parser_parent_class = g_type_class_peek_parent (klass);
}


static void input_parser_instance_init (InputParser * self) {
}


GType input_parser_get_type (void) {
	static volatile gsize input_parser_type_id__volatile = 0;
	if (g_once_init_enter (&input_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
		GType input_parser_type_id;
		input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
		g_once_init_leave (&input_parser_type_id__volatile, input_parser_type_id);
	}
	return input_parser_type_id__volatile;
}



