/* SerialConnection.c generated by valac 0.12.0, the Vala compiler
 * generated from SerialConnection.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stropts.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	gchar* echoReference;
	gchar* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	struct termios restoretio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	gboolean localEcho;
};

typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_serial_connection_parent_class = NULL;

GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionPrivate))
enum  {
	MOSERIAL_SERIAL_CONNECTION_DUMMY_PROPERTY
};
GType moserial_serial_connection_line_end_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
const gchar* settings_get_device (Settings* self);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition);
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static guint* _uint_dup (guint* self);
gboolean settings_get_localEcho (Settings* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gchar* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void moserial_serial_connection_finalize (GObject* obj);

const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndStrings[6] = {"CR+LF end", "CR end", "LF end", "TAB end", "ESC end", "No end"};
const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndValues[6] = {"\r\n", "\r", "\n", "\t", "\x1b", ""};

GType moserial_serial_connection_line_end_get_type (void) {
	static volatile gsize moserial_serial_connection_line_end_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_line_end_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC, "MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC", "esc"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
		GType moserial_serial_connection_line_end_type_id;
		moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
		g_once_init_leave (&moserial_serial_connection_line_end_type_id__volatile, moserial_serial_connection_line_end_type_id);
	}
	return moserial_serial_connection_line_end_type_id__volatile;
}


static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_serial_connection_readBytes (self, source, condition);
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings) {
	gboolean result = FALSE;
	SettingsAccessMode _tmp0_;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	GIOChannel* _tmp4_ = NULL;
	guint _tmp5_;
	guint* _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = settings_get_accessMode (settings);
	if (_tmp0_ == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		SettingsAccessMode _tmp1_;
		_tmp1_ = settings_get_accessMode (settings);
		if (_tmp1_ == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	_tmp2_ = settings_get_device (settings);
	_tmp3_ = open (_tmp2_, self->priv->flags | O_NONBLOCK, (mode_t) 0);
	self->priv->m_fd = _tmp3_;
	if (self->priv->m_fd < 0) {
		self->priv->m_fd = -1;
		result = FALSE;
		return result;
	}
	tcflush (self->priv->m_fd, TCIOFLUSH);
	tcgetattr (self->priv->m_fd, &self->priv->restoretio);
	moserial_serial_connection_applySettings (self, settings);
	tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
	self->priv->connected = TRUE;
	_tmp4_ = g_io_channel_unix_new (self->priv->m_fd);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	self->priv->IOChannelFd = _tmp4_;
	_tmp5_ = g_io_add_watch (self->priv->IOChannelFd, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self);
	_tmp6_ = __uint_dup0 (&_tmp5_);
	_g_free0 (self->priv->sourceId);
	self->priv->sourceId = _tmp6_;
	_tmp7_ = settings_get_localEcho (settings);
	self->priv->localEcho = _tmp7_;
	result = TRUE;
	return result;
}


void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guchar* _tmp0_ = NULL;
		guchar* b;
		gint b_length1;
		gint _b_size_;
		gssize _tmp1_;
		gsize x;
		_tmp0_ = g_new0 (guchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = 1;
		b[0] = byte;
		_tmp1_ = write (self->priv->m_fd, b, (gsize) 1);
		x = (gsize) _tmp1_;
		self->tx = self->tx + x;
		b = (g_free (b), NULL);
	}
}


void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gssize _tmp0_;
		gsize x;
		_tmp0_ = write (self->priv->m_fd, bytes, size);
		x = (gsize) _tmp0_;
		tcdrain (self->priv->m_fd);
		self->tx = self->tx + x;
	}
}


void moserial_serial_connection_doDisconnect (moserialSerialConnection* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		g_source_remove (*self->priv->sourceId);
		_g_free0 (self->priv->sourceId);
		self->priv->sourceId = NULL;
		g_io_channel_shutdown (self->priv->IOChannelFd, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch8_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally8;
		__catch8_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("SerialConnection.vala:115: %s", e->message);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_io_channel_unref0 (self->priv->IOChannelFd);
		self->priv->IOChannelFd = NULL;
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->nonprintable = (gulong) 0;
		self->rx = self->nonprintable;
		self->tx = self->rx;
		_tmp0_ = g_strdup ("");
		_g_free0 (self->echoReference);
		self->echoReference = _tmp0_;
		_tmp1_ = g_strdup ("");
		_g_free0 (self->echoCompare);
		self->echoCompare = _tmp1_;
		tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
		close (self->priv->m_fd);
	}
}


static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	guchar* _tmp0_ = NULL;
	guchar* m_buf;
	gint m_buf_length1;
	gint _m_buf_size_;
	gssize _tmp1_;
	gint bytesRead;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (guchar, 128);
	m_buf = _tmp0_;
	m_buf_length1 = 128;
	_m_buf_size_ = 128;
	_tmp1_ = read (self->priv->m_fd, m_buf, (gsize) 128);
	bytesRead = (gint) _tmp1_;
	self->rx = self->rx + ((gulong) bytesRead);
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = gtk_events_pending ();
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = gdk_events_pending ();
			_tmp2_ = _tmp4_;
		}
		if (!_tmp2_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (bytesRead < 0) {
		result = FALSE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	}
	g_signal_emit_by_name (self, "new-data", m_buf, m_buf_length1, bytesRead);
	if (self->priv->localEcho) {
		moserial_serial_connection_sendBytes (self, (gchar*) m_buf, m_buf_length1, (gsize) bytesRead);
	}
	result = self->priv->connected;
	m_buf = (g_free (m_buf), NULL);
	return result;
}


static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings) {
	guint baudRate;
	gint _tmp0_;
	gint dataBits = 0;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	SettingsParity _tmp7_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	SettingsHandshake _tmp11_;
	gint mcs;
	gboolean _tmp13_ = FALSE;
	SettingsHandshake _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	baudRate = (guint) 0;
	_tmp0_ = settings_get_baudRate (settings);
	switch (_tmp0_) {
		case 300:
		{
			baudRate = (guint) B300;
			break;
		}
		case 600:
		{
			baudRate = (guint) B600;
			break;
		}
		case 1200:
		{
			baudRate = (guint) B1200;
			break;
		}
		case 2400:
		{
			baudRate = (guint) B2400;
			break;
		}
		case 4800:
		{
			baudRate = (guint) B4800;
			break;
		}
		case 9600:
		{
			baudRate = (guint) B9600;
			break;
		}
		case 19200:
		{
			baudRate = (guint) B19200;
			break;
		}
		case 38400:
		{
			baudRate = (guint) B38400;
			break;
		}
		case 57600:
		{
			baudRate = (guint) B57600;
			break;
		}
		case 115200:
		{
			baudRate = (guint) B115200;
			break;
		}
		case 230400:
		{
			baudRate = (guint) B230400;
			break;
		}
		case 460800:
		{
			baudRate = (guint) B460800;
			break;
		}
		case 576000:
		{
			baudRate = (guint) B576000;
			break;
		}
		case 921600:
		{
			baudRate = (guint) B921600;
			break;
		}
		case 1000000:
		{
			baudRate = (guint) B1000000;
			break;
		}
		case 2000000:
		{
			baudRate = (guint) B2000000;
			break;
		}
		default:
		break;
	}
	cfsetospeed (&self->priv->newtio, (speed_t) baudRate);
	cfsetispeed (&self->priv->newtio, (speed_t) baudRate);
	_tmp1_ = settings_get_dataBits (settings);
	dataBits = _tmp1_;
	_tmp3_ = settings_get_dataBits (settings);
	if (_tmp3_ == 7) {
		gboolean _tmp4_ = FALSE;
		SettingsParity _tmp5_;
		_tmp5_ = settings_get_parity (settings);
		if (_tmp5_ == SETTINGS_PARITY_MARK) {
			_tmp4_ = TRUE;
		} else {
			SettingsParity _tmp6_;
			_tmp6_ = settings_get_parity (settings);
			_tmp4_ = _tmp6_ == SETTINGS_PARITY_SPACE;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		dataBits = 8;
	}
	switch (dataBits) {
		case 5:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS7;
			break;
		}
		default:
		case 8:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS8;
			break;
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (CLOCAL | CREAD);
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~(PARENB | PARODD));
	_tmp7_ = settings_get_parity (settings);
	if (_tmp7_ == SETTINGS_PARITY_EVEN) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | PARENB;
	} else {
		SettingsParity _tmp8_;
		_tmp8_ = settings_get_parity (settings);
		if (_tmp8_ == SETTINGS_PARITY_ODD) {
			self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (PARENB | PARODD);
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & ((tcflag_t) (~CRTSCTS));
	_tmp9_ = settings_get_stopBits (settings);
	if (_tmp9_ == 2) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CSTOPB;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CSTOPB);
	}
	self->priv->newtio.c_iflag = IGNBRK;
	_tmp11_ = settings_get_handshake (settings);
	if (_tmp11_ == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp10_ = TRUE;
	} else {
		SettingsHandshake _tmp12_;
		_tmp12_ = settings_get_handshake (settings);
		_tmp10_ = _tmp12_ == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp10_) {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag | (IXON | IXOFF);
	} else {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag & (~((IXON | IXOFF) | IXANY));
	}
	self->priv->newtio.c_lflag = (tcflag_t) 0;
	self->priv->newtio.c_oflag = (tcflag_t) 0;
	self->priv->newtio.c_cc[VTIME] = (cc_t) 1;
	self->priv->newtio.c_cc[VMIN] = (cc_t) 1;
	self->priv->newtio.c_lflag = self->priv->newtio.c_lflag & (~(ECHONL | NOFLSH));
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &mcs);
	mcs = mcs | TIOCM_RTS;
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
	_tmp14_ = settings_get_handshake (settings);
	if (_tmp14_ == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp13_ = TRUE;
	} else {
		SettingsHandshake _tmp15_;
		_tmp15_ = settings_get_handshake (settings);
		_tmp13_ = _tmp15_ == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp13_) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | ((tcflag_t) CRTSCTS);
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & ((tcflag_t) (~CRTSCTS));
	}
}


gchar* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self) {
	gchar* result = NULL;
	gchar* r = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->nonprintable > 0) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = _ ("TX: %lu, RX: %lu (%lu unprintable)");
		_tmp1_ = g_strdup_printf (_tmp0_, self->tx, self->rx, self->nonprintable);
		_g_free0 (r);
		r = _tmp1_;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = _ ("TX: %lu, RX: %lu");
		_tmp3_ = g_strdup_printf (_tmp2_, self->tx, self->rx);
		_g_free0 (r);
		r = _tmp3_;
	}
	result = r;
	return result;
}


moserialSerialConnection* moserial_serial_connection_construct (GType object_type) {
	moserialSerialConnection * self = NULL;
	self = (moserialSerialConnection*) g_object_new (object_type, NULL);
	return self;
}


moserialSerialConnection* moserial_serial_connection_new (void) {
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void moserial_serial_connection_class_init (moserialSerialConnectionClass * klass) {
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSerialConnectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	g_signal_new ("new_data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
}


static void moserial_serial_connection_instance_init (moserialSerialConnection * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	_tmp0_ = g_strdup ("");
	self->echoReference = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->echoCompare = _tmp1_;
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}


static void moserial_serial_connection_finalize (GObject* obj) {
	moserialSerialConnection * self;
	self = MOSERIAL_SERIAL_CONNECTION (obj);
	_g_free0 (self->echoReference);
	_g_free0 (self->echoCompare);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	_g_free0 (self->priv->sourceId);
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}


GType moserial_serial_connection_get_type (void) {
	static volatile gsize moserial_serial_connection_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
		GType moserial_serial_connection_type_id;
		moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
		g_once_init_leave (&moserial_serial_connection_type_id__volatile, moserial_serial_connection_type_id);
	}
	return moserial_serial_connection_type_id__volatile;
}



