/* Rzwrapper.c generated by valac 0.12.0, the Vala compiler
 * generated from Rzwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the rz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>


#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

struct _moserialRzwrapperPrivate {
	moserialRzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _path;
	gchar* _filename;
};


static gpointer moserial_rzwrapper_parent_class = NULL;

GType moserial_rzwrapper_get_type (void) G_GNUC_CONST;
GType moserial_rzwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_RZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperPrivate))
enum  {
	MOSERIAL_RZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_RZWRAPPER_PROTOCOL,
	MOSERIAL_RZWRAPPER_SC,
	MOSERIAL_RZWRAPPER_PATH,
	MOSERIAL_RZWRAPPER_FILENAME
};
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
static void moserial_rzwrapper_shutdown (moserialRzwrapper* self);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self);
moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self);
static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value);
static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self);
static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value);
const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self);
static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value);
static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_rzwrapper_finalize (GObject* obj);
static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_RZWRAPPER_ProtocolStrings[3] = {"Xmodem", "Ymodem", "Zmodem"};

GType moserial_rzwrapper_protocol_get_type (void) {
	static volatile gsize moserial_rzwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_NULL, "MOSERIAL_RZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_rzwrapper_protocol_type_id;
		moserial_rzwrapper_protocol_type_id = g_enum_register_static ("moserialRzwrapperProtocol", values);
		g_once_init_leave (&moserial_rzwrapper_protocol_type_id__volatile, moserial_rzwrapper_protocol_type_id);
	}
	return moserial_rzwrapper_protocol_type_id__volatile;
}


moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	moserialRzwrapper * self = NULL;
	moserialRzwrapperProtocol pro;
	pro = *protocol;
	self = (moserialRzwrapper*) g_object_new (object_type, "protocol", pro, "sc", sc, "path", p, "filename", filename, NULL);
	return self;
}


moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	return moserial_rzwrapper_construct (MOSERIAL_TYPE_RZWRAPPER, protocol, sc, p, filename);
}


void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		gsize bytesWritten = 0UL;
		gchar* _tmp0_ = NULL;
		gchar* b;
		gint b_length1;
		gint _b_size_;
		_tmp0_ = g_new0 (gchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = 1;
		b[0] = (gchar) byte;
		if (self->running) {
			gsize _tmp1_;
			g_io_channel_write_chars (self->priv->IOChannelInput, b, b_length1, &_tmp1_, &_inner_error_);
			bytesWritten = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch14_g_io_channel_error;
				}
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch14_g_convert_error;
				}
				b = (g_free (b), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally14;
		__catch14_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			fprintf (stdout, "writeChar() %s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally14;
		__catch14_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "%s\n", e->message);
			_g_error_free0 (e);
		}
		__finally14:
		if (_inner_error_ != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


void moserial_rzwrapper_flush (moserialRzwrapper* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->running) {
		if (self->running) {
			g_io_channel_flush (self->priv->IOChannelInput, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch15_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally15;
		__catch15_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			fprintf (stdout, "flush() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (self->running) {
		gchar* _tmp0_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* _tmp1_;
		gchar* message;
		gchar* _tmp2_;
		gchar* messages;
		gsize bytesRead;
		gsize _tmp3_;
		gchar* _tmp11_ = NULL;
		gint _tmp12_;
		gint _tmp13_;
		_tmp0_ = g_new0 (gchar, 1000);
		m_buf = _tmp0_;
		m_buf_length1 = 1000;
		_m_buf_size_ = 1000;
		_tmp1_ = g_strdup ("");
		message = _tmp1_;
		_tmp2_ = g_strdup ("");
		messages = _tmp2_;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		g_io_channel_read_chars (source, m_buf, m_buf_length1, &_tmp3_, &_inner_error_);
		bytesRead = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch16_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch16_g_io_channel_error;
			}
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally16;
		__catch16_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally16;
		__catch16_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gunichar c;
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					if (!_tmp4_) {
						x++;
					}
					_tmp4_ = FALSE;
					if (!(x < bytesRead)) {
						break;
					}
					c = (gunichar) m_buf[x];
					_tmp6_ = g_unichar_isprint (c);
					if (_tmp6_) {
						_tmp5_ = TRUE;
					} else {
						gboolean _tmp7_;
						_tmp7_ = g_unichar_isspace (c);
						_tmp5_ = _tmp7_;
					}
					if (_tmp5_) {
						gchar* _tmp8_ = NULL;
						gchar* _tmp9_;
						gchar* _tmp10_;
						_tmp8_ = g_strdup_printf ("%c", (gint) m_buf[x]);
						_tmp9_ = _tmp8_;
						_tmp10_ = g_strconcat (messages, _tmp9_, NULL);
						_g_free0 (messages);
						messages = _tmp10_;
						_g_free0 (_tmp9_);
					}
				}
			}
		}
		_tmp11_ = mo_utils_getLastMessage (messages);
		_g_free0 (message);
		message = _tmp11_;
		if (!(g_strcmp0 (message, "") == 0)) {
			g_signal_emit_by_name (self, "update-status", message);
		}
		_tmp12_ = string_index_of (messages, "Transfer complete", 0);
		if (_tmp12_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		_tmp13_ = string_index_of (messages, "Transfer incomplete", 0);
		if (_tmp13_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (messages);
		_g_free0 (message);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_shutdown_timeout (self);
	return result;
}


void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->running) {
		g_signal_emit_by_name (self, "update-status", "canceled");
		{
			gint x;
			x = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						x++;
					}
					_tmp0_ = FALSE;
					if (!(x < 20)) {
						break;
					}
					if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM) {
						moserial_serial_connection_sendByte (self->priv->_sc, (guchar) ('X' & 037));
						moserial_rzwrapper_writeChar (self, (guchar) ('X' & 037));
					} else {
						moserial_serial_connection_sendByte (self->priv->_sc, (guchar) 0x18);
					}
				}
			}
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_rzwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_rzwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_rzwrapper_shutdown (moserialRzwrapper* self) {
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (self->running) {
		gchar* _tmp0_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead;
		gsize _tmp1_;
		_tmp0_ = g_new0 (gchar, 1000);
		m_buf = _tmp0_;
		m_buf_length1 = 1000;
		_m_buf_size_ = 1000;
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		g_io_channel_read_chars (source, m_buf, m_buf_length1, &_tmp1_, &_inner_error_);
		bytesRead = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch17_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch17_g_io_channel_error;
			}
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally17;
		__catch17_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readBytes() %s\n", e->message);
			_g_error_free0 (e);
		}
		goto __finally17;
		__catch17_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally17:
		if (_inner_error_ != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						x++;
					}
					_tmp2_ = FALSE;
					if (!(x < bytesRead)) {
						break;
					}
					moserial_serial_connection_sendByte (self->priv->_sc, (guchar) m_buf[x]);
				}
			}
		}
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self) {
	moserialRzwrapperProtocol result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_protocol;
	return result;
}


static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value) {
	g_return_if_fail (self != NULL);
	self->priv->_protocol = value;
	g_object_notify ((GObject *) self, "protocol");
}


moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self) {
	moserialSerialConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sc;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value) {
	moserialSerialConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_sc);
	self->priv->_sc = _tmp0_;
	g_object_notify ((GObject *) self, "sc");
}


const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
	return result;
}


static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_path);
	self->priv->_path = _tmp0_;
	g_object_notify ((GObject *) self, "path");
}


const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readBytes (self, source, condition);
	return result;
}


static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readError (self, source, condition);
	return result;
}


static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialRzwrapper * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_rzwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RZWRAPPER (obj);
	if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_path == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		GPid _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GIOChannel* _tmp19_ = NULL;
		GIOChannel* _tmp20_ = NULL;
		GIOChannel* _tmp21_ = NULL;
		guint _tmp22_;
		guint _tmp23_;
		if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp1_ = NULL;
			_tmp1_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp1_;
			argv_length1 = 4;
			_argv_size_ = 4;
		} else {
			gchar** _tmp2_ = NULL;
			_tmp2_ = g_new0 (gchar*, 3 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp2_;
			argv_length1 = 3;
			_argv_size_ = 3;
		}
		_tmp3_ = g_strdup ("rz");
		_tmp4_ = _tmp3_;
		_g_free0 (argv[0]);
		argv[0] = _tmp4_;
		switch (self->priv->_protocol) {
			case MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("--xmodem");
				_tmp6_ = _tmp5_;
				_g_free0 (argv[1]);
				argv[1] = _tmp6_;
				break;
			}
			case MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("--ymodem");
				_tmp8_ = _tmp7_;
				_g_free0 (argv[1]);
				argv[1] = _tmp8_;
				break;
			}
			default:
			case MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("--zmodem");
				_tmp10_ = _tmp9_;
				_g_free0 (argv[1]);
				argv[1] = _tmp10_;
				break;
			}
		}
		_tmp11_ = g_strdup ("-vv");
		_tmp12_ = _tmp11_;
		_g_free0 (argv[2]);
		argv[2] = _tmp12_;
		if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = g_strdup (self->priv->_filename);
			_tmp14_ = _tmp13_;
			_g_free0 (argv[3]);
			argv[3] = _tmp14_;
		}
		g_spawn_async_with_pipes (self->priv->_path, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_, &_inner_error_);
		self->priv->pid = _tmp15_;
		input = _tmp16_;
		output = _tmp17_;
		_error_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp19_ = g_io_channel_unix_new (output);
		_g_io_channel_unref0 (self->priv->IOChannelOutput);
		self->priv->IOChannelOutput = _tmp19_;
		_tmp20_ = g_io_channel_unix_new (input);
		_g_io_channel_unref0 (self->priv->IOChannelInput);
		self->priv->IOChannelInput = _tmp20_;
		_tmp21_ = g_io_channel_unix_new (_error_);
		_g_io_channel_unref0 (self->priv->IOChannelError);
		self->priv->IOChannelError = _tmp21_;
		g_io_channel_set_encoding (self->priv->IOChannelOutput, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_flags (self->priv->IOChannelOutput, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_encoding (self->priv->IOChannelError, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_flags (self->priv->IOChannelError, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		g_io_channel_set_encoding (self->priv->IOChannelInput, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch18_g_spawn_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch18_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp22_ = g_io_add_watch (self->priv->IOChannelOutput, G_IO_IN, _moserial_rzwrapper_readBytes_gio_func, self);
		self->priv->outputChannelId = _tmp22_;
		_tmp23_ = g_io_add_watch (self->priv->IOChannelError, G_IO_IN, _moserial_rzwrapper_readError_gio_func, self);
		self->priv->errorChannelId = _tmp23_;
		self->running = TRUE;
		goto __finally18;
		__catch18_g_spawn_error:
		{
			GError * e;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			GtkMessageDialog* _tmp26_ = NULL;
			GtkMessageDialog* _tmp27_;
			GtkMessageDialog* errorDialog;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			fprintf (stdout, "spawn error: %s\n", e->message);
			_tmp24_ = g_strdup_printf ("%s", e->message);
			_tmp25_ = _tmp24_;
			_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp25_);
			_tmp27_ = g_object_ref_sink (_tmp26_);
			_g_free0 (_tmp25_);
			errorDialog = _tmp27_;
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_widget_destroy ((GtkWidget*) errorDialog);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally18;
		__catch18_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stdout, "readError() %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_rzwrapper_class_init (moserialRzwrapperClass * klass) {
	moserial_rzwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_rzwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_rzwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_rzwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_rzwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_RZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_SC, g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_rzwrapper_instance_init (moserialRzwrapper * self) {
	self->priv = MOSERIAL_RZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_rzwrapper_finalize (GObject* obj) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (obj);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_rzwrapper_parent_class)->finalize (obj);
}


GType moserial_rzwrapper_get_type (void) {
	static volatile gsize moserial_rzwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_rzwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRzwrapper), 0, (GInstanceInitFunc) moserial_rzwrapper_instance_init, NULL };
		GType moserial_rzwrapper_type_id;
		moserial_rzwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_rzwrapper_type_id__volatile, moserial_rzwrapper_type_id);
	}
	return moserial_rzwrapper_type_id__volatile;
}


static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_rzwrapper_get_protocol (self));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		g_value_set_object (value, moserial_rzwrapper_get_sc (self));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		g_value_set_string (value, moserial_rzwrapper_get_path (self));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_rzwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		moserial_rzwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		moserial_rzwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		moserial_rzwrapper_set_path (self, g_value_get_string (value));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		moserial_rzwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



