/* HexTextBuffer.c generated by valac 0.12.0, the Vala compiler
 * generated from HexTextBuffer.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;
typedef struct _moserialHexTextBufferPrivate moserialHexTextBufferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _moserialHexTextBuffer {
	GtkTextBuffer parent_instance;
	moserialHexTextBufferPrivate * priv;
};

struct _moserialHexTextBufferClass {
	GtkTextBufferClass parent_class;
};

struct _moserialHexTextBufferPrivate {
	GtkTextMark* nextHexMark;
	GtkTextMark* nextCharMark;
	GtkTextTag* addressTag;
	GtkTextTag* oddTag;
	gint hexBytes;
};


static gpointer moserial_hex_text_buffer_parent_class = NULL;

GType moserial_hex_text_buffer_get_type (void) G_GNUC_CONST;
#define MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferPrivate))
enum  {
	MOSERIAL_HEX_TEXT_BUFFER_DUMMY_PROPERTY
};
GType preferences_get_type (void) G_GNUC_CONST;
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences);
const gchar* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_hex_text_buffer_finalize (GObject* obj);


void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	_tmp0_ = preferences_get_highlightColor (preferences);
	g_object_set (self->priv->addressTag, "foreground", _tmp0_, NULL);
	_tmp1_ = preferences_get_highlightColor (preferences);
	g_object_set (self->priv->oddTag, "foreground", _tmp1_, NULL);
}


void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", 0);
	moserial_hex_text_buffer_setup (self);
}


static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp0_);
	nextHexIter = _tmp0_;
	_tmp1_ = gtk_text_mark_new ("nextHex", TRUE);
	_g_object_unref0 (self->priv->nextHexMark);
	self->priv->nextHexMark = _tmp1_;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	nextCharIter = nextHexIter;
	_tmp2_ = gtk_text_mark_new ("nextChar", TRUE);
	_g_object_unref0 (self->priv->nextCharMark);
	self->priv->nextCharMark = _tmp2_;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	self->priv->hexBytes = 0;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	gchar* _tmp0_;
	gchar* incomingHexBuffer;
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint _tmp14_;
	GtkTextIter tempIter = {0};
	gchar* _tmp15_;
	GtkTextMark* _tmp16_ = NULL;
	GtkTextIter _tmp17_ = {0};
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gunichar _tmp20_;
	gunichar _tmp21_;
	gunichar c;
	gchar* _tmp22_ = NULL;
	gchar* s;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_;
	GtkTextMark* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	incomingHexBuffer = _tmp0_;
	if ((self->priv->hexBytes % 16) == 0) {
		GtkTextIter startIter = {0};
		GtkTextIter _tmp1_ = {0};
		GtkTextMark* _tmp2_ = NULL;
		GtkTextMark* startMark;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextMark* _tmp6_ = NULL;
		GtkTextMark* _tmp7_ = NULL;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, self->priv->nextCharMark);
		nextCharIter = _tmp1_;
		_tmp2_ = gtk_text_mark_new ("startMark", TRUE);
		startMark = _tmp2_;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, startMark, &nextCharIter);
		_tmp3_ = g_strdup_printf ("\n%08x", (guint) self->priv->hexBytes);
		_tmp4_ = _tmp3_;
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp4_, 9);
		_g_free0 (_tmp4_);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, startMark);
		startIter = _tmp5_;
		gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*) self, "hex_address", &startIter, &nextCharIter);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, startMark);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, " ", 1);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
		nextHexIter = nextCharIter;
		_tmp6_ = gtk_text_mark_new ("nextHex", TRUE);
		_g_object_unref0 (self->priv->nextHexMark);
		self->priv->nextHexMark = _tmp6_;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, "                                                   ", 51);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
		_tmp7_ = gtk_text_mark_new ("nextChar", TRUE);
		_g_object_unref0 (self->priv->nextCharMark);
		self->priv->nextCharMark = _tmp7_;
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
		_g_object_unref0 (startMark);
	} else {
		if ((self->priv->hexBytes % 8) == 0) {
			GtkTextIter _tmp8_ = {0};
			GtkTextIter tempIter = {0};
			GtkTextMark* _tmp9_ = NULL;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp8_, self->priv->nextHexMark);
			nextHexIter = _tmp8_;
			gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, "  ", 2);
			tempIter = nextHexIter;
			gtk_text_iter_forward_chars (&tempIter, 2);
			gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
			gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
			_tmp9_ = gtk_text_mark_new ("nextHex", TRUE);
			_g_object_unref0 (self->priv->nextHexMark);
			self->priv->nextHexMark = _tmp9_;
			gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		}
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp10_, self->priv->nextHexMark);
	nextHexIter = _tmp10_;
	_tmp11_ = g_strdup_printf ("%02X ", (guint) data);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (incomingHexBuffer, _tmp12_, NULL);
	_g_free0 (incomingHexBuffer);
	incomingHexBuffer = _tmp13_;
	_g_free0 (_tmp12_);
	_tmp14_ = strlen (incomingHexBuffer);
	gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, incomingHexBuffer, (gint) _tmp14_);
	tempIter = nextHexIter;
	gtk_text_iter_forward_chars (&tempIter, 3);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
	_tmp15_ = g_strdup ("");
	_g_free0 (incomingHexBuffer);
	incomingHexBuffer = _tmp15_;
	self->priv->hexBytes++;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	_tmp16_ = gtk_text_mark_new ("nextHex", TRUE);
	_g_object_unref0 (self->priv->nextHexMark);
	self->priv->nextHexMark = _tmp16_;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp17_, self->priv->nextCharMark);
	nextCharIter = _tmp17_;
	_tmp18_ = g_strdup_printf ("%c", (gint) data);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_get_char (_tmp19_, (glong) 0);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	c = _tmp21_;
	_tmp22_ = g_strdup_printf ("%c", (gint) data);
	s = _tmp22_;
	_tmp24_ = g_utf8_validate (s, (gssize) (-1), NULL);
	if (_tmp24_) {
		gboolean _tmp25_;
		_tmp25_ = g_unichar_isprint (c);
		_tmp23_ = _tmp25_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gint _tmp26_;
		_tmp26_ = strlen (s);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, s, (gint) _tmp26_);
	} else {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, ".", 1);
	}
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	_tmp27_ = gtk_text_mark_new ("nextChar", TRUE);
	_g_object_unref0 (self->priv->nextCharMark);
	self->priv->nextCharMark = _tmp27_;
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	_g_free0 (s);
	_g_free0 (incomingHexBuffer);
}


moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type) {
	moserialHexTextBuffer * self = NULL;
	self = (moserialHexTextBuffer*) g_object_new (object_type, NULL);
	return self;
}


moserialHexTextBuffer* moserial_hex_text_buffer_new (void) {
	return moserial_hex_text_buffer_construct (MOSERIAL_TYPE_HEX_TEXT_BUFFER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialHexTextBuffer * self;
	GtkTextTag* _tmp0_ = NULL;
	GtkTextTag* _tmp1_;
	GtkTextTag* _tmp2_ = NULL;
	GtkTextTag* _tmp3_;
	parent_class = G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	moserial_hex_text_buffer_setup (self);
	_tmp0_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_address", "foreground", "#2020ff", NULL, NULL);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->addressTag);
	self->priv->addressTag = _tmp1_;
	_tmp2_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_odd", "foreground", "#2020ff", NULL, NULL);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->oddTag);
	self->priv->oddTag = _tmp3_;
	return obj;
}


static void moserial_hex_text_buffer_class_init (moserialHexTextBufferClass * klass) {
	moserial_hex_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialHexTextBufferPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_hex_text_buffer_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_hex_text_buffer_finalize;
}


static void moserial_hex_text_buffer_instance_init (moserialHexTextBuffer * self) {
	self->priv = MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE (self);
}


static void moserial_hex_text_buffer_finalize (GObject* obj) {
	moserialHexTextBuffer * self;
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	_g_object_unref0 (self->priv->nextHexMark);
	_g_object_unref0 (self->priv->nextCharMark);
	_g_object_unref0 (self->priv->addressTag);
	_g_object_unref0 (self->priv->oddTag);
	G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class)->finalize (obj);
}


GType moserial_hex_text_buffer_get_type (void) {
	static volatile gsize moserial_hex_text_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_hex_text_buffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialHexTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_hex_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialHexTextBuffer), 0, (GInstanceInitFunc) moserial_hex_text_buffer_instance_init, NULL };
		GType moserial_hex_text_buffer_type_id;
		moserial_hex_text_buffer_type_id = g_type_register_static (GTK_TYPE_TEXT_BUFFER, "moserialHexTextBuffer", &g_define_type_info, 0);
		g_once_init_leave (&moserial_hex_text_buffer_type_id__volatile, moserial_hex_text_buffer_type_id);
	}
	return moserial_hex_text_buffer_type_id__volatile;
}



