/* Szwrapper.c generated by valac 0.13.3.34-3eeb2-dirty, the Vala compiler
 * generated from Szwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the sz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

struct _moserialSzwrapperPrivate {
	moserialSzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _filename;
};


static gpointer moserial_szwrapper_parent_class = NULL;

GType moserial_szwrapper_get_type (void) G_GNUC_CONST;
GType moserial_szwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperPrivate))
enum  {
	MOSERIAL_SZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_SZWRAPPER_PROTOCOL,
	MOSERIAL_SZWRAPPER_SC,
	MOSERIAL_SZWRAPPER_FILENAME
};
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
static void moserial_szwrapper_shutdown (moserialSzwrapper* self);
static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self);
static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self);
moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value);
static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self);
static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value);
static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_szwrapper_finalize (GObject* obj);
static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_SZWRAPPER_ProtocolStrings[4] = {"Xmodem", "Ymodem", "Zmodem", "None (straight binary)"};

GType moserial_szwrapper_protocol_get_type (void) {
	static volatile gsize moserial_szwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_RAW, "MOSERIAL_SZWRAPPER_PROTOCOL_RAW", "raw"}, {MOSERIAL_SZWRAPPER_PROTOCOL_NULL, "MOSERIAL_SZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_szwrapper_protocol_type_id;
		moserial_szwrapper_protocol_type_id = g_enum_register_static ("moserialSzwrapperProtocol", values);
		g_once_init_leave (&moserial_szwrapper_protocol_type_id__volatile, moserial_szwrapper_protocol_type_id);
	}
	return moserial_szwrapper_protocol_type_id__volatile;
}


moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	moserialSzwrapper * self = NULL;
	moserialSzwrapperProtocol* _tmp0_;
	moserialSzwrapperProtocol pro;
	moserialSerialConnection* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = protocol;
	pro = *_tmp0_;
	_tmp1_ = sc;
	_tmp2_ = filename;
	self = (moserialSzwrapper*) g_object_new (object_type, "protocol", pro, "sc", _tmp1_, "filename", _tmp2_, NULL);
	return self;
}


moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	return moserial_szwrapper_construct (MOSERIAL_TYPE_SZWRAPPER, protocol, sc, filename);
}


void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gsize bytesWritten = 0UL;
		gchar* _tmp1_ = NULL;
		gchar* b;
		gint b_length1;
		gint _b_size_;
		gchar* _tmp2_;
		gint _tmp2__length1;
		guchar _tmp3_;
		gchar _tmp4_;
		_tmp1_ = g_new0 (gchar, 1);
		b = _tmp1_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		_tmp3_ = byte;
		_tmp2_[0] = (gchar) _tmp3_;
		_tmp4_ = _tmp2_[0];
		{
			gboolean _tmp5_;
			gboolean _tmp9_;
			_tmp5_ = self->running;
			if (_tmp5_) {
				GIOChannel* _tmp6_;
				gchar* _tmp7_;
				gint _tmp7__length1;
				gsize _tmp8_ = 0UL;
				_tmp6_ = self->priv->IOChannelInput;
				_tmp7_ = b;
				_tmp7__length1 = b_length1;
				g_io_channel_write_chars (_tmp6_, _tmp7_, _tmp7__length1, &_tmp8_, &_inner_error_);
				bytesWritten = _tmp8_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch19_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch19_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp9_ = self->running;
			if (_tmp9_) {
				GIOChannel* _tmp10_;
				_tmp10_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp10_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch19_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch19_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally19;
		__catch19_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_szwrapper_shutdown (self);
			_tmp11_ = stdout;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			fprintf (_tmp11_, "writeChar() %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		goto __finally19;
		__catch19_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = stdout;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			fprintf (_tmp14_, "%s\n", _tmp16_);
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_szwrapper_shutdown_timeout (self);
	return result;
}


static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
		gtk_main_iteration_do (TRUE);
	}
	_tmp4_ = self->running;
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* _tmp6_;
		gchar* messages;
		gchar* _tmp7_;
		gchar* message;
		gsize bytesRead;
		GIOCondition _tmp8_;
		const gchar* _tmp39_;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		const gchar* _tmp43_;
		gint _tmp44_ = 0;
		const gchar* _tmp45_;
		gint _tmp46_ = 0;
		_tmp5_ = g_new0 (gchar, 1000);
		m_buf = _tmp5_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp6_ = g_strdup ("");
		messages = _tmp6_;
		_tmp7_ = g_strdup ("");
		message = _tmp7_;
		bytesRead = (gsize) 0;
		_tmp8_ = condition;
		if (!(_tmp8_ == G_IO_IN)) {
			result = TRUE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp9_;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gsize _tmp11_ = 0UL;
			_tmp9_ = source;
			_tmp10_ = m_buf;
			_tmp10__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp9_, _tmp10_, _tmp10__length1, &_tmp11_, &_inner_error_);
			bytesRead = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch20_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch20_g_io_channel_error;
				}
				_g_free0 (message);
				_g_free0 (messages);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally20;
		__catch20_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = stdout;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp12_, "%s\n", _tmp14_);
			_g_error_free0 (e);
		}
		goto __finally20;
		__catch20_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = stdout;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			fprintf (_tmp15_, "readError() %s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp18_;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_;
					gint _tmp21_;
					gsize _tmp22_;
					gchar* _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					gchar _tmp25_;
					gunichar c;
					gboolean _tmp26_ = FALSE;
					gunichar _tmp27_;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp31_;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = x;
						x = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = x;
					_tmp22_ = bytesRead;
					if (!(((gsize) _tmp21_) < _tmp22_)) {
						break;
					}
					_tmp23_ = m_buf;
					_tmp23__length1 = m_buf_length1;
					_tmp24_ = x;
					_tmp25_ = _tmp23_[_tmp24_];
					c = (gunichar) _tmp25_;
					_tmp27_ = c;
					_tmp28_ = g_unichar_isprint (_tmp27_);
					if (_tmp28_) {
						_tmp26_ = TRUE;
					} else {
						gunichar _tmp29_;
						gboolean _tmp30_ = FALSE;
						_tmp29_ = c;
						_tmp30_ = g_unichar_isspace (_tmp29_);
						_tmp26_ = _tmp30_;
					}
					_tmp31_ = _tmp26_;
					if (_tmp31_) {
						const gchar* _tmp32_;
						gchar* _tmp33_;
						gint _tmp33__length1;
						gint _tmp34_;
						gchar _tmp35_;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp32_ = messages;
						_tmp33_ = m_buf;
						_tmp33__length1 = m_buf_length1;
						_tmp34_ = x;
						_tmp35_ = _tmp33_[_tmp34_];
						_tmp36_ = g_strdup_printf ("%c", (gint) _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat (_tmp32_, _tmp37_, NULL);
						_g_free0 (messages);
						messages = _tmp38_;
						_g_free0 (_tmp37_);
					}
				}
			}
		}
		_tmp39_ = messages;
		_tmp40_ = mo_utils_getLastMessage (_tmp39_);
		_g_free0 (message);
		message = _tmp40_;
		_tmp41_ = message;
		if (!(g_strcmp0 (_tmp41_, "") == 0)) {
			const gchar* _tmp42_;
			_tmp42_ = message;
			g_signal_emit_by_name (self, "update-status", _tmp42_);
		}
		_tmp43_ = messages;
		_tmp44_ = string_index_of (_tmp43_, "Transfer complete", 0);
		if (_tmp44_ >= 0) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_szwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp45_ = messages;
		_tmp46_ = string_index_of (_tmp45_, "Transfer incomplete", 0);
		if (_tmp46_ >= 0) {
			moserial_szwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (message);
		_g_free0 (messages);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		moserialSzwrapperProtocol _tmp4_;
		gboolean _tmp6_;
		gboolean _tmp8_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		moserialSzwrapperProtocol _tmp18_;
		gboolean _tmp20_;
		gboolean _tmp22_;
		_tmp1_ = _ ("canceled");
		g_signal_emit_by_name (self, "update-status", _tmp1_);
		_tmp4_ = self->priv->_protocol;
		if (_tmp4_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp3_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp5_;
			_tmp5_ = self->priv->_protocol;
			_tmp3_ = _tmp5_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		_tmp6_ = _tmp3_;
		if (_tmp6_) {
			_tmp2_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp7_;
			_tmp7_ = self->priv->_protocol;
			_tmp2_ = _tmp7_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
		}
		_tmp8_ = _tmp2_;
		if (_tmp8_) {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp9_;
					_tmp9_ = TRUE;
					while (TRUE) {
						gboolean _tmp10_;
						gint _tmp12_;
						moserialSzwrapperProtocol _tmp13_;
						_tmp10_ = _tmp9_;
						if (!_tmp10_) {
							gint _tmp11_;
							_tmp11_ = x;
							x = _tmp11_ + 1;
						}
						_tmp9_ = FALSE;
						_tmp12_ = x;
						if (!(_tmp12_ < 20)) {
							break;
						}
						_tmp13_ = self->priv->_protocol;
						if (_tmp13_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM) {
							moserialSerialConnection* _tmp14_;
							_tmp14_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp14_, (guchar) ('X' & 037));
							moserial_szwrapper_writeChar (self, (guchar) ('X' & 037));
						} else {
							moserialSerialConnection* _tmp15_;
							_tmp15_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp15_, (guchar) 0x18);
						}
					}
				}
			}
		}
		_tmp18_ = self->priv->_protocol;
		if (_tmp18_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp17_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp19_;
			_tmp19_ = self->priv->_protocol;
			_tmp17_ = _tmp19_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		_tmp20_ = _tmp17_;
		if (_tmp20_) {
			_tmp16_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp21_;
			_tmp21_ = self->priv->_protocol;
			_tmp16_ = _tmp21_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
		}
		_tmp22_ = _tmp16_;
		if (_tmp22_) {
			moserial_szwrapper_shutdown (self);
		}
	}
}


static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_szwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_szwrapper_shutdown (moserialSzwrapper* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		GPid _tmp3_;
		self->running = FALSE;
		_tmp1_ = self->priv->outputChannelId;
		g_source_remove (_tmp1_);
		_tmp2_ = self->priv->errorChannelId;
		g_source_remove (_tmp2_);
		_tmp3_ = self->priv->pid;
		g_spawn_close_pid (_tmp3_);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
		gtk_main_iteration_do (TRUE);
	}
	_tmp4_ = self->running;
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead;
		GIOCondition _tmp6_;
		moserialSerialConnection* _tmp16_;
		gchar* _tmp17_;
		gint _tmp17__length1;
		gsize _tmp18_;
		_tmp5_ = g_new0 (gchar, 1024);
		m_buf = _tmp5_;
		m_buf_length1 = 1024;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		_tmp6_ = condition;
		if (!(_tmp6_ == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp7_;
			gchar* _tmp8_;
			gint _tmp8__length1;
			gsize _tmp9_ = 0UL;
			_tmp7_ = source;
			_tmp8_ = m_buf;
			_tmp8__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp7_, _tmp8_, _tmp8__length1, &_tmp9_, &_inner_error_);
			bytesRead = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch21_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch21_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally21;
		__catch21_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = stdout;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			fprintf (_tmp10_, "%s\n", _tmp12_);
			_g_error_free0 (e);
		}
		goto __finally21;
		__catch21_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = stdout;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			fprintf (_tmp13_, "readError() %s\n", _tmp15_);
			_g_error_free0 (e);
		}
		__finally21:
		if (_inner_error_ != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp16_ = self->priv->_sc;
		_tmp17_ = m_buf;
		_tmp17__length1 = m_buf_length1;
		_tmp18_ = bytesRead;
		moserial_serial_connection_sendBytes (_tmp16_, _tmp17_, _tmp17__length1, _tmp18_);
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self) {
	moserialSzwrapperProtocol result;
	moserialSzwrapperProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value) {
	moserialSzwrapperProtocol _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_protocol = _tmp0_;
	g_object_notify ((GObject *) self, "protocol");
}


moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self) {
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value) {
	moserialSerialConnection* _tmp0_;
	moserialSerialConnection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_sc);
	self->priv->_sc = _tmp1_;
	g_object_notify ((GObject *) self, "sc");
}


const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readBytes (self, source, condition);
	return result;
}


static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readError (self, source, condition);
	return result;
}


static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialSzwrapperProtocol _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_szwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SZWRAPPER (obj);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_SZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_filename;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialSzwrapperProtocol _tmp4_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp4_ = self->priv->_protocol;
		if (_tmp4_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW) {
			gchar** _tmp5_ = NULL;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = g_new0 (gchar*, 2 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp5_;
			argv_length1 = 2;
			_argv_size_ = argv_length1;
			_tmp6_ = argv;
			_tmp6__length1 = argv_length1;
			_tmp7_ = g_strdup ("cat");
			_g_free0 (_tmp6_[0]);
			_tmp6_[0] = _tmp7_;
			_tmp8_ = _tmp6_[0];
			_tmp9_ = argv;
			_tmp9__length1 = argv_length1;
			_tmp10_ = self->priv->_filename;
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_tmp9_[1]);
			_tmp9_[1] = _tmp11_;
			_tmp12_ = _tmp9_[1];
		} else {
			gchar** _tmp13_ = NULL;
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar* _tmp15_;
			gchar* _tmp16_;
			moserialSzwrapperProtocol _tmp17_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp13_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp13_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
			_tmp14_ = argv;
			_tmp14__length1 = argv_length1;
			_tmp15_ = g_strdup ("sz");
			_g_free0 (_tmp14_[0]);
			_tmp14_[0] = _tmp15_;
			_tmp16_ = _tmp14_[0];
			_tmp17_ = self->priv->_protocol;
			switch (_tmp17_) {
				case MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM:
				{
					gchar** _tmp18_;
					gint _tmp18__length1;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = argv;
					_tmp18__length1 = argv_length1;
					_tmp19_ = g_strdup ("--xmodem");
					_g_free0 (_tmp18_[1]);
					_tmp18_[1] = _tmp19_;
					_tmp20_ = _tmp18_[1];
					break;
				}
				case MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM:
				{
					gchar** _tmp21_;
					gint _tmp21__length1;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = argv;
					_tmp21__length1 = argv_length1;
					_tmp22_ = g_strdup ("--ymodem");
					_g_free0 (_tmp21_[1]);
					_tmp21_[1] = _tmp22_;
					_tmp23_ = _tmp21_[1];
					break;
				}
				default:
				case MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM:
				{
					gchar** _tmp24_;
					gint _tmp24__length1;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp24_ = argv;
					_tmp24__length1 = argv_length1;
					_tmp25_ = g_strdup ("--zmodem");
					_g_free0 (_tmp24_[1]);
					_tmp24_[1] = _tmp25_;
					_tmp26_ = _tmp24_[1];
					break;
				}
			}
			_tmp27_ = argv;
			_tmp27__length1 = argv_length1;
			_tmp28_ = g_strdup ("-vv");
			_g_free0 (_tmp27_[2]);
			_tmp27_[2] = _tmp28_;
			_tmp29_ = _tmp27_[2];
			_tmp30_ = argv;
			_tmp30__length1 = argv_length1;
			_tmp31_ = self->priv->_filename;
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (_tmp30_[3]);
			_tmp30_[3] = _tmp32_;
			_tmp33_ = _tmp30_[3];
		}
		{
			gchar** _tmp34_;
			gint _tmp34__length1;
			GPid _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_;
			GIOChannel* _tmp40_;
			gint _tmp41_;
			GIOChannel* _tmp42_;
			gint _tmp43_;
			GIOChannel* _tmp44_;
			GIOChannel* _tmp45_;
			GIOChannel* _tmp46_;
			GIOChannel* _tmp47_;
			GIOChannel* _tmp48_;
			GIOChannel* _tmp49_;
			GIOChannel* _tmp50_;
			guint _tmp51_ = 0U;
			GIOChannel* _tmp52_;
			guint _tmp53_ = 0U;
			_tmp34_ = argv;
			_tmp34__length1 = argv_length1;
			g_spawn_async_with_pipes (NULL, _tmp34_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_, &_inner_error_);
			self->priv->pid = _tmp35_;
			input = _tmp36_;
			output = _tmp37_;
			_error_ = _tmp38_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp39_ = output;
			_tmp40_ = g_io_channel_unix_new (_tmp39_);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp40_;
			_tmp41_ = input;
			_tmp42_ = g_io_channel_unix_new (_tmp41_);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp42_;
			_tmp43_ = _error_;
			_tmp44_ = g_io_channel_unix_new (_tmp43_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp44_;
			_tmp45_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp45_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp46_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp46_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp47_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp47_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp48_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp48_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp49_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp49_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp50_ = self->priv->IOChannelOutput;
			_tmp51_ = g_io_add_watch (_tmp50_, G_IO_IN, _moserial_szwrapper_readBytes_gio_func, self);
			self->priv->outputChannelId = _tmp51_;
			_tmp52_ = self->priv->IOChannelError;
			_tmp53_ = g_io_add_watch (_tmp52_, G_IO_IN, _moserial_szwrapper_readError_gio_func, self);
			self->priv->errorChannelId = _tmp53_;
			self->running = TRUE;
		}
		goto __finally22;
		__catch22_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp54_;
			GError* _tmp55_;
			const gchar* _tmp56_;
			GError* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_;
			GtkMessageDialog* _tmp61_;
			GtkMessageDialog* _tmp62_;
			GtkMessageDialog* _tmp63_;
			GtkMessageDialog* errorDialog;
			GtkMessageDialog* _tmp64_;
			GtkMessageDialog* _tmp65_;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			_tmp54_ = stdout;
			_tmp55_ = e;
			_tmp56_ = _tmp55_->message;
			fprintf (_tmp54_, "spawn error: %s\n", _tmp56_);
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			_tmp59_ = g_strdup_printf ("%s", _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp60_);
			_tmp62_ = g_object_ref_sink (_tmp61_);
			_tmp63_ = _tmp62_;
			_g_free0 (_tmp60_);
			errorDialog = _tmp63_;
			_tmp64_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp64_);
			_tmp65_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp65_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally22;
		__catch22_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp66_;
			GError* _tmp67_;
			const gchar* _tmp68_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp66_ = stdout;
			_tmp67_ = e;
			_tmp68_ = _tmp67_->message;
			fprintf (_tmp66_, "readError() %s\n", _tmp68_);
			_g_error_free0 (e);
		}
		__finally22:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_szwrapper_class_init (moserialSzwrapperClass * klass) {
	moserial_szwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_szwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_szwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_szwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_szwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_SZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_SC, g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_szwrapper_instance_init (moserialSzwrapper * self) {
	self->priv = MOSERIAL_SZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_szwrapper_finalize (GObject* obj) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (obj);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_szwrapper_parent_class)->finalize (obj);
}


GType moserial_szwrapper_get_type (void) {
	static volatile gsize moserial_szwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_szwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSzwrapper), 0, (GInstanceInitFunc) moserial_szwrapper_instance_init, NULL };
		GType moserial_szwrapper_type_id;
		moserial_szwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_szwrapper_type_id__volatile, moserial_szwrapper_type_id);
	}
	return moserial_szwrapper_type_id__volatile;
}


static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_szwrapper_get_protocol (self));
		break;
		case MOSERIAL_SZWRAPPER_SC:
		g_value_set_object (value, moserial_szwrapper_get_sc (self));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_szwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = MOSERIAL_SZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL:
		moserial_szwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_SZWRAPPER_SC:
		moserial_szwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME:
		moserial_szwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



