/* InputParser.c generated by valac 0.13.3.34-3eeb2-dirty, the Vala compiler
 * generated from InputParser.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};


static gpointer input_parser_parent_class = NULL;

GQuark hex_parse_error_quark (void);
GType input_parser_get_type (void) G_GNUC_CONST;
enum  {
	INPUT_PARSER_DUMMY_PROPERTY
};
gchar* input_parser_statusReplace (const gchar* oldString);
guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error);
static gchar input_parser_xtoi (gunichar c);
InputParser* input_parser_new (void);
InputParser* input_parser_construct (GType object_type);


GQuark hex_parse_error_quark (void) {
	return g_quark_from_static_string ("hex_parse_error-quark");
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* input_parser_statusReplace (const gchar* oldString) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (oldString != NULL, NULL);
	_tmp0_ = oldString;
	_tmp1_ = string_replace (_tmp0_, "\\r", "\\n");
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error) {
	guchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong len;
	glong _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* r;
	gint r_length1;
	gint _r_size_;
	guchar* _tmp40_;
	gint _tmp40__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	len = (glong) _tmp2_;
	_tmp3_ = len;
	_tmp4_ = g_new0 (guchar, (_tmp3_ + 1) / 2);
	r = _tmp4_;
	r_length1 = (_tmp3_ + 1) / 2;
	_r_size_ = r_length1;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				glong _tmp9_;
				gunichar c = 0U;
				gint i = 0;
				gint temp = 0;
				const gchar* _tmp10_;
				gunichar _tmp11_ = 0U;
				glong _tmp12_;
				const gchar* _tmp34_;
				const gchar* _tmp35_ = NULL;
				guchar* _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				gint _tmp38_;
				guchar _tmp39_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = x;
				_tmp9_ = len;
				if (!(((glong) _tmp8_) < ((_tmp9_ + 1) / 2))) {
					break;
				}
				_tmp10_ = s;
				_tmp11_ = string_get_char (_tmp10_, (glong) 0);
				c = _tmp11_;
				_tmp12_ = len;
				if (_tmp12_ > ((glong) 1)) {
					gunichar _tmp13_;
					gchar _tmp14_ = '\0';
					gint _tmp15_;
					const gchar* _tmp18_;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_;
					gunichar _tmp21_ = 0U;
					gunichar _tmp22_;
					gchar _tmp23_ = '\0';
					gint _tmp24_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp13_ = c;
					_tmp14_ = input_parser_xtoi (_tmp13_);
					i = _tmp14_ * 16;
					_tmp15_ = i;
					if (_tmp15_ < 0) {
						const gchar* _tmp16_ = NULL;
						GError* _tmp17_;
						_tmp16_ = _ ("Invalid Input");
						_tmp17_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp16_);
						_inner_error_ = _tmp17_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp18_ = s;
					_tmp19_ = g_utf8_next_char (_tmp18_);
					s = _tmp19_;
					_tmp20_ = s;
					_tmp21_ = string_get_char (_tmp20_, (glong) 0);
					c = _tmp21_;
					_tmp22_ = c;
					_tmp23_ = input_parser_xtoi (_tmp22_);
					temp = (gint) _tmp23_;
					_tmp24_ = temp;
					if (_tmp24_ < 0) {
						const gchar* _tmp25_ = NULL;
						GError* _tmp26_;
						_tmp25_ = _ ("Invalid Input");
						_tmp26_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp25_);
						_inner_error_ = _tmp26_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp27_ = i;
					_tmp28_ = temp;
					i = _tmp27_ + _tmp28_;
				} else {
					gunichar _tmp29_;
					gchar _tmp30_ = '\0';
					gint _tmp31_;
					_tmp29_ = c;
					_tmp30_ = input_parser_xtoi (_tmp29_);
					i = (gint) _tmp30_;
					_tmp31_ = i;
					if (_tmp31_ < 0) {
						const gchar* _tmp32_ = NULL;
						GError* _tmp33_;
						_tmp32_ = _ ("Invalid Input");
						_tmp33_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp32_);
						_inner_error_ = _tmp33_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				_tmp34_ = s;
				_tmp35_ = g_utf8_next_char (_tmp34_);
				s = _tmp35_;
				_tmp36_ = r;
				_tmp36__length1 = r_length1;
				_tmp37_ = x;
				_tmp38_ = i;
				_tmp36_[_tmp37_] = (guchar) _tmp38_;
				_tmp39_ = _tmp36_[_tmp37_];
			}
		}
	}
	_tmp40_ = r;
	_tmp40__length1 = r_length1;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	return result;
}


static gchar input_parser_xtoi (gunichar c) {
	gchar result = '\0';
	gchar i;
	gunichar _tmp0_;
	i = (gchar) (-1);
	_tmp0_ = c;
	switch (_tmp0_) {
		case '0':
		{
			i = (gchar) 0;
			break;
		}
		case '1':
		{
			i = (gchar) 1;
			break;
		}
		case '2':
		{
			i = (gchar) 2;
			break;
		}
		case '3':
		{
			i = (gchar) 3;
			break;
		}
		case '4':
		{
			i = (gchar) 4;
			break;
		}
		case '5':
		{
			i = (gchar) 5;
			break;
		}
		case '6':
		{
			i = (gchar) 6;
			break;
		}
		case '7':
		{
			i = (gchar) 7;
			break;
		}
		case '8':
		{
			i = (gchar) 8;
			break;
		}
		case '9':
		{
			i = (gchar) 9;
			break;
		}
		case 'a':
		{
			i = (gchar) 10;
			break;
		}
		case 'b':
		{
			i = (gchar) 11;
			break;
		}
		case 'c':
		{
			i = (gchar) 12;
			break;
		}
		case 'd':
		{
			i = (gchar) 13;
			break;
		}
		case 'e':
		{
			i = (gchar) 14;
			break;
		}
		case 'f':
		{
			i = (gchar) 15;
			break;
		}
		case 'A':
		{
			i = (gchar) 10;
			break;
		}
		case 'B':
		{
			i = (gchar) 11;
			break;
		}
		case 'C':
		{
			i = (gchar) 12;
			break;
		}
		case 'D':
		{
			i = (gchar) 13;
			break;
		}
		case 'E':
		{
			i = (gchar) 14;
			break;
		}
		case 'F':
		{
			i = (gchar) 15;
			break;
		}
		default:
		break;
	}
	result = i;
	return result;
}


InputParser* input_parser_construct (GType object_type) {
	InputParser * self = NULL;
	self = (InputParser*) g_object_new (object_type, NULL);
	return self;
}


InputParser* input_parser_new (void) {
	return input_parser_construct (TYPE_INPUT_PARSER);
}


static void input_parser_class_init (InputParserClass * klass) {
	input_parser_parent_class = g_type_class_peek_parent (klass);
}


static void input_parser_instance_init (InputParser * self) {
}


GType input_parser_get_type (void) {
	static volatile gsize input_parser_type_id__volatile = 0;
	if (g_once_init_enter (&input_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
		GType input_parser_type_id;
		input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
		g_once_init_leave (&input_parser_type_id__volatile, input_parser_type_id);
	}
	return input_parser_type_id__volatile;
}



