
#ifndef __SRC_PREFERENCES_H__
#define __SRC_PREFERENCES_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "src/Profile.h"

G_BEGIN_DECLS


#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;

struct _Preferences {
	GObject parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GObjectClass parent_class;
};


extern gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT;
extern char* preferences_DEFAULT_FONT;
extern char* preferences_DEFAULT_FONT_COLOR;
extern char* preferences_DEFAULT_BACKGROUND_COLOR;
extern char* preferences_DEFAULT_HIGHLIGHT_COLOR;
extern gboolean preferences_DEFAULT_RECORD_LAUNCH;
Preferences* preferences_construct (GType object_type, gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
Preferences* preferences_new (gboolean useSystemMonospaceFont, const char* font, const char* fontColor, const char* backgroundColor, const char* highlightColor, gboolean recordLaunch, gboolean enableTimeout, gint timeout);
char* preferences_getSystemDefaultMonospaceFont (void);
GdkColor preferences_getGdkColor (const char* color);
void preferences_toString (Preferences* self);
void preferences_saveToProfile (Preferences* self, Profile* profile);
Preferences* preferences_loadFromProfile (Profile* profile);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
const char* preferences_get_font (Preferences* self);
const char* preferences_get_fontColor (Preferences* self);
const char* preferences_get_backgroundColor (Preferences* self);
const char* preferences_get_highlightColor (Preferences* self);
gboolean preferences_get_recordLaunch (Preferences* self);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
GType preferences_get_type (void);


G_END_DECLS

#endif
