
#include <src/Profile.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>




enum  {
	PROFILE_DUMMY_PROPERTY
};
static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer profile_parent_class = NULL;
static void profile_finalize (GObject* obj);



void profile_saveWindowSize (Profile* self, gint w, gint h) {
	g_return_if_fail (self != NULL);
	if (w > 0) {
		g_key_file_set_integer (self->keyFile, "window", "width", w);
	}
	if (h > 0) {
		g_key_file_set_integer (self->keyFile, "window", "height", h);
	}
}


void profile_saveWindowPanedPosition (Profile* self, gint pos) {
	g_return_if_fail (self != NULL);
	g_key_file_set_integer (self->keyFile, "window", "paned_pos", pos);
}


gint profile_getWindowPanedPosition (Profile* self) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, 0);
	inner_error = NULL;
	{
		gint _tmp0;
		_tmp0 = g_key_file_get_integer (self->keyFile, "window", "paned_pos", &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch22_g_key_file_error;
			}
			goto __finally22;
		}
		return _tmp0;
	}
	goto __finally22;
	__catch22_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp2;
			return (_tmp2 = -1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp2);
		}
	}
	__finally22:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
}


gint profile_getWindowWidth (Profile* self) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, 0);
	inner_error = NULL;
	{
		gint _tmp0;
		_tmp0 = g_key_file_get_integer (self->keyFile, "window", "width", &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch23_g_key_file_error;
			}
			goto __finally23;
		}
		return _tmp0;
	}
	goto __finally23;
	__catch23_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp2;
			return (_tmp2 = -1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp2);
		}
	}
	__finally23:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
}


gint profile_getWindowHeight (Profile* self) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, 0);
	inner_error = NULL;
	{
		gint _tmp0;
		_tmp0 = g_key_file_get_integer (self->keyFile, "window", "height", &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch24_g_key_file_error;
			}
			goto __finally24;
		}
		return _tmp0;
	}
	goto __finally24;
	__catch24_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp2;
			return (_tmp2 = -1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp2);
		}
	}
	__finally24:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
}


gboolean profile_load (Profile* self, const char* filename, GtkWindow* window) {
	GError * inner_error;
	char* f;
	gboolean default_profile;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	inner_error = NULL;
	f = NULL;
	default_profile = FALSE;
	if (filename == NULL) {
		char* _tmp0;
		default_profile = TRUE;
		_tmp0 = NULL;
		f = (_tmp0 = g_strdup_printf ("%s/moserial.conf", g_get_user_config_dir ()), f = (g_free (f), NULL), _tmp0);
	} else {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		f = (_tmp2 = (_tmp1 = filename, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), f = (g_free (f), NULL), _tmp2);
	}
	{
		gboolean _tmp3;
		g_key_file_load_from_file (self->keyFile, f, G_KEY_FILE_NONE, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch25_g_key_file_error;
			}
			if (inner_error->domain == G_FILE_ERROR) {
				goto __catch25_g_file_error;
			}
			goto __finally25;
		}
		return (_tmp3 = TRUE, f = (g_free (f), NULL), _tmp3);
	}
	goto __finally25;
	__catch25_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp4;
			fprintf (stdout, "%s\n", e->message);
			/* try loading the non-broken parts of the profile - return true */
			return (_tmp4 = TRUE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), f = (g_free (f), NULL), _tmp4);
		}
	}
	goto __finally25;
	__catch25_g_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp7;
			if (!default_profile) {
				char* _tmp5;
				GtkMessageDialog* _tmp6;
				GtkMessageDialog* errorDialog;
				_tmp5 = NULL;
				_tmp6 = NULL;
				errorDialog = (_tmp6 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp5 = g_strdup_printf ("%s: %s\n%s", _ ("Error: Could not open file"), filename, e->message), NULL)), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
				gtk_dialog_run ((GtkDialog*) errorDialog);
				gtk_object_destroy ((GtkObject*) errorDialog);
				(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
			}
			return (_tmp7 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), f = (g_free (f), NULL), _tmp7);
		}
	}
	__finally25:
	if (inner_error != NULL) {
		f = (g_free (f), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	f = (g_free (f), NULL);
}


void profile_toString (Profile* self) {
	GError * inner_error;
	gsize s;
	char* _tmp0;
	char* _tmp1;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	s = 0UL;
	_tmp0 = g_key_file_to_data (self->keyFile, &s, &inner_error);
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp1 = NULL;
	fprintf (stdout, "%s\n", _tmp1 = _tmp0);
	_tmp1 = (g_free (_tmp1), NULL);
}


void profile_save (Profile* self, const char* filename, GtkWindow* window) {
	GError * inner_error;
	GFile* file;
	GFileOutputStream* fos;
	char* f;
	gboolean default_profile;
	GFile* _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	inner_error = NULL;
	file = NULL;
	fos = NULL;
	f = NULL;
	default_profile = FALSE;
	if (filename == NULL) {
		char* _tmp0;
		default_profile = TRUE;
		_tmp0 = NULL;
		f = (_tmp0 = g_strdup_printf ("%s/moserial.conf", g_get_user_config_dir ()), f = (g_free (f), NULL), _tmp0);
	} else {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		f = (_tmp2 = (_tmp1 = filename, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), f = (g_free (f), NULL), _tmp2);
	}
	_tmp3 = NULL;
	file = (_tmp3 = g_file_new_for_path (f), (file == NULL) ? NULL : (file = (g_object_unref (file), NULL)), _tmp3);
	{
		gsize s;
		char* data;
		GFileOutputStream* _tmp4;
		GFileOutputStream* _tmp5;
		char* _tmp6;
		char* _tmp7;
		s = 0UL;
		data = NULL;
		_tmp4 = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &inner_error);
		if (inner_error != NULL) {
			data = (g_free (data), NULL);
			goto __catch26_g_error;
			goto __finally26;
		}
		_tmp5 = NULL;
		fos = (_tmp5 = _tmp4, (fos == NULL) ? NULL : (fos = (g_object_unref (fos), NULL)), _tmp5);
		_tmp6 = g_key_file_to_data (self->keyFile, &s, &inner_error);
		if (inner_error != NULL) {
			data = (g_free (data), NULL);
			goto __catch26_g_error;
			goto __finally26;
		}
		_tmp7 = NULL;
		data = (_tmp7 = _tmp6, data = (g_free (data), NULL), _tmp7);
		g_output_stream_write ((GOutputStream*) fos, data, s, NULL, &inner_error);
		if (inner_error != NULL) {
			data = (g_free (data), NULL);
			goto __catch26_g_error;
			goto __finally26;
		}
		data = (g_free (data), NULL);
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stdout, "profile.save error: %s\n", e->message);
			if (!default_profile) {
				char* _tmp8;
				GtkMessageDialog* _tmp9;
				GtkMessageDialog* errorDialog;
				_tmp8 = NULL;
				_tmp9 = NULL;
				errorDialog = (_tmp9 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp8 = g_strdup_printf ("%s: %s\n%s", _ ("Error: Could not open file"), filename, e->message), NULL)), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
				gtk_dialog_run ((GtkDialog*) errorDialog);
				gtk_object_destroy ((GtkObject*) errorDialog);
				(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
			}
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally26:
	if (inner_error != NULL) {
		(file == NULL) ? NULL : (file = (g_object_unref (file), NULL));
		(fos == NULL) ? NULL : (fos = (g_object_unref (fos), NULL));
		f = (g_free (f), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(file == NULL) ? NULL : (file = (g_object_unref (file), NULL));
	(fos == NULL) ? NULL : (fos = (g_object_unref (fos), NULL));
	f = (g_free (f), NULL);
}


Profile* profile_construct (GType object_type) {
	Profile * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


Profile* profile_new (void) {
	return profile_construct (TYPE_PROFILE);
}


static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ProfileClass * klass;
	GObjectClass * parent_class;
	Profile * self;
	klass = PROFILE_CLASS (g_type_class_peek (TYPE_PROFILE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PROFILE (obj);
	{
		GKeyFile* _tmp0;
		_tmp0 = NULL;
		self->keyFile = (_tmp0 = g_key_file_new (), (self->keyFile == NULL) ? NULL : (self->keyFile = (g_key_file_free (self->keyFile), NULL)), _tmp0);
	}
	return obj;
}


static void profile_class_init (ProfileClass * klass) {
	profile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = profile_constructor;
	G_OBJECT_CLASS (klass)->finalize = profile_finalize;
}


static void profile_instance_init (Profile * self) {
}


static void profile_finalize (GObject* obj) {
	Profile * self;
	self = PROFILE (obj);
	(self->keyFile == NULL) ? NULL : (self->keyFile = (g_key_file_free (self->keyFile), NULL));
	G_OBJECT_CLASS (profile_parent_class)->finalize (obj);
}


GType profile_get_type (void) {
	static GType profile_type_id = 0;
	if (profile_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Profile), 0, (GInstanceInitFunc) profile_instance_init, NULL };
		profile_type_id = g_type_register_static (G_TYPE_OBJECT, "Profile", &g_define_type_info, 0);
	}
	return profile_type_id;
}




