
#include <src/HexTextBuffer.h>
#include <stdlib.h>
#include <string.h>




static glong string_get_length (const char* self);
struct _moserialHexTextBufferPrivate {
	GtkTextMark* nextHexMark;
	GtkTextMark* nextCharMark;
	GtkTextTag* addressTag;
	GtkTextTag* oddTag;
	gint hexBytes;
};

#define MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferPrivate))
enum  {
	MOSERIAL_HEX_TEXT_BUFFER_DUMMY_PROPERTY
};
static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self);
static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_hex_text_buffer_parent_class = NULL;
static void moserial_hex_text_buffer_finalize (GObject* obj);



static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	g_object_set (self->priv->addressTag, "foreground", preferences_get_highlightColor (preferences), NULL);
	g_object_set (self->priv->oddTag, "foreground", preferences_get_highlightColor (preferences), NULL);
}


void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", 0);
	moserial_hex_text_buffer_setup (self);
}


static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	GtkTextMark* _tmp0;
	GtkTextMark* _tmp1;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &nextHexIter);
	_tmp0 = NULL;
	self->priv->nextHexMark = (_tmp0 = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp0);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	nextCharIter = nextHexIter;
	_tmp1 = NULL;
	self->priv->nextCharMark = (_tmp1 = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp1);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	self->priv->hexBytes = 0;
}


void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	char* incomingHexBuffer;
	char* _tmp5;
	char* _tmp4;
	GtkTextIter tempIter = {0};
	char* _tmp6;
	GtkTextMark* _tmp7;
	char* _tmp8;
	gunichar _tmp9;
	gunichar c;
	char* s;
	gboolean _tmp10;
	GtkTextMark* _tmp11;
	g_return_if_fail (self != NULL);
	incomingHexBuffer = g_strdup ("");
	if ((self->priv->hexBytes % 16) == 0) {
		GtkTextIter startIter = {0};
		GtkTextMark* startMark;
		char* _tmp0;
		GtkTextMark* _tmp1;
		GtkTextMark* _tmp2;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
		startMark = gtk_text_mark_new ("startMark", TRUE);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, startMark, &nextCharIter);
		_tmp0 = NULL;
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp0 = g_strdup_printf ("\n%08x", (guint) self->priv->hexBytes), 9);
		_tmp0 = (g_free (_tmp0), NULL);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &startIter, startMark);
		gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*) self, "hex_address", &startIter, &nextCharIter);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, startMark);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, " ", 1);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
		nextHexIter = nextCharIter;
		_tmp1 = NULL;
		self->priv->nextHexMark = (_tmp1 = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp1);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, "                                                   ", 51);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
		_tmp2 = NULL;
		self->priv->nextCharMark = (_tmp2 = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp2);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
		(startMark == NULL) ? NULL : (startMark = (g_object_unref (startMark), NULL));
	} else {
		if ((self->priv->hexBytes % 8) == 0) {
			GtkTextIter tempIter = {0};
			GtkTextMark* _tmp3;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
			gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, "  ", 2);
			/*remove space to align chars*/
			tempIter = nextHexIter;
			gtk_text_iter_forward_chars (&tempIter, 2);
			gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
			gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
			_tmp3 = NULL;
			self->priv->nextHexMark = (_tmp3 = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp3);
			gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		}
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
	_tmp5 = NULL;
	_tmp4 = NULL;
	incomingHexBuffer = (_tmp5 = g_strconcat (incomingHexBuffer, _tmp4 = g_strdup_printf ("%02X ", (guint) data), NULL), incomingHexBuffer = (g_free (incomingHexBuffer), NULL), _tmp5);
	_tmp4 = (g_free (_tmp4), NULL);
	gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, incomingHexBuffer, (gint) string_get_length (incomingHexBuffer));
	/*remove space to align chars*/
	tempIter = nextHexIter;
	gtk_text_iter_forward_chars (&tempIter, 3);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
	/*add odd coloring
	if(((hexBytes+1)%2)==0) {
	                      tempIter.backward_chars(3);
	                      this.apply_tag_by_name("hex_odd", tempIter, nextHexIter);
	                      }*/
	_tmp6 = NULL;
	incomingHexBuffer = (_tmp6 = g_strdup (""), incomingHexBuffer = (g_free (incomingHexBuffer), NULL), _tmp6);
	self->priv->hexBytes++;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	_tmp7 = NULL;
	self->priv->nextHexMark = (_tmp7 = gtk_text_mark_new ("nextHex", TRUE), (self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL)), _tmp7);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
	_tmp8 = NULL;
	c = (_tmp9 = g_utf8_get_char (_tmp8 = g_strdup_printf ("%c", (gint) data)), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
	s = g_strdup_printf ("%c", (gint) data);
	_tmp10 = FALSE;
	if (g_utf8_validate (s, -1, NULL)) {
		_tmp10 = g_unichar_isprint (c);
	} else {
		_tmp10 = FALSE;
	}
	if (_tmp10) {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, s, (gint) string_get_length (s));
	} else {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, ".", 1);
	}
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	_tmp11 = NULL;
	self->priv->nextCharMark = (_tmp11 = gtk_text_mark_new ("nextChar", TRUE), (self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL)), _tmp11);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	incomingHexBuffer = (g_free (incomingHexBuffer), NULL);
	s = (g_free (s), NULL);
}


moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type) {
	moserialHexTextBuffer * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialHexTextBuffer* moserial_hex_text_buffer_new (void) {
	return moserial_hex_text_buffer_construct (MOSERIAL_TYPE_HEX_TEXT_BUFFER);
}


static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialHexTextBufferClass * klass;
	GObjectClass * parent_class;
	moserialHexTextBuffer * self;
	klass = MOSERIAL_HEX_TEXT_BUFFER_CLASS (g_type_class_peek (MOSERIAL_TYPE_HEX_TEXT_BUFFER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	{
		GtkTextTag* _tmp1;
		GtkTextTag* _tmp0;
		GtkTextTag* _tmp3;
		GtkTextTag* _tmp2;
		moserial_hex_text_buffer_setup (self);
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->addressTag = (_tmp1 = (_tmp0 = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_address", "foreground", "#2020ff", NULL, NULL), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->addressTag == NULL) ? NULL : (self->priv->addressTag = (g_object_unref (self->priv->addressTag), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->oddTag = (_tmp3 = (_tmp2 = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_odd", "foreground", "#2020ff", NULL, NULL), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->oddTag == NULL) ? NULL : (self->priv->oddTag = (g_object_unref (self->priv->oddTag), NULL)), _tmp3);
	}
	return obj;
}


static void moserial_hex_text_buffer_class_init (moserialHexTextBufferClass * klass) {
	moserial_hex_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialHexTextBufferPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_hex_text_buffer_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_hex_text_buffer_finalize;
}


static void moserial_hex_text_buffer_instance_init (moserialHexTextBuffer * self) {
	self->priv = MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE (self);
}


static void moserial_hex_text_buffer_finalize (GObject* obj) {
	moserialHexTextBuffer * self;
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	(self->priv->nextHexMark == NULL) ? NULL : (self->priv->nextHexMark = (g_object_unref (self->priv->nextHexMark), NULL));
	(self->priv->nextCharMark == NULL) ? NULL : (self->priv->nextCharMark = (g_object_unref (self->priv->nextCharMark), NULL));
	(self->priv->addressTag == NULL) ? NULL : (self->priv->addressTag = (g_object_unref (self->priv->addressTag), NULL));
	(self->priv->oddTag == NULL) ? NULL : (self->priv->oddTag = (g_object_unref (self->priv->oddTag), NULL));
	G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class)->finalize (obj);
}


GType moserial_hex_text_buffer_get_type (void) {
	static GType moserial_hex_text_buffer_type_id = 0;
	if (moserial_hex_text_buffer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialHexTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_hex_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialHexTextBuffer), 0, (GInstanceInitFunc) moserial_hex_text_buffer_instance_init, NULL };
		moserial_hex_text_buffer_type_id = g_type_register_static (GTK_TYPE_TEXT_BUFFER, "moserialHexTextBuffer", &g_define_type_info, 0);
	}
	return moserial_hex_text_buffer_type_id;
}




