
#include <src/MoUtils.h>
#include <stdio.h>
#include "src/InputParser.h"




static gboolean string_contains (const char* self, const char* needle);
static glong string_get_length (const char* self);
enum  {
	MO_UTILS_DUMMY_PROPERTY
};
static gpointer mo_utils_parent_class = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gboolean string_contains (const char* self, const char* needle) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	return strstr (self, needle) != NULL;
}


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


GFile* mo_utils_newFile (const char* path) {
	char* uri;
	GFile* _tmp3;
	g_return_val_if_fail (path != NULL, NULL);
	uri = NULL;
	if (string_contains (path, "://")) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		uri = (_tmp1 = (_tmp0 = path, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), uri = (g_free (uri), NULL), _tmp1);
	} else {
		char* _tmp2;
		_tmp2 = NULL;
		uri = (_tmp2 = g_strdup_printf ("file://%s", path), uri = (g_free (uri), NULL), _tmp2);
	}
	_tmp3 = NULL;
	return (_tmp3 = g_file_new_for_uri (uri), uri = (g_free (uri), NULL), _tmp3);
}


gboolean mo_utils_fileExists (const char* path) {
	GFile* file;
	gboolean _tmp0;
	g_return_val_if_fail (path != NULL, FALSE);
	file = mo_utils_newFile (path);
	return (_tmp0 = g_file_query_exists (file, NULL), (file == NULL) ? NULL : (file = (g_object_unref (file), NULL)), _tmp0);
}


gint64 mo_utils_fileSize (const char* path) {
	GError * inner_error;
	GFile* file;
	gint64 _tmp1;
	g_return_val_if_fail (path != NULL, 0LL);
	inner_error = NULL;
	file = mo_utils_newFile (path);
	{
		GFileInfo* info;
		gint64 _tmp0;
		info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch28_g_error;
			goto __finally28;
		}
		return (_tmp0 = g_file_info_get_size (info), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), (file == NULL) ? NULL : (file = (g_object_unref (file), NULL)), _tmp0);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("MoUtils.vala:24: %s", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally28:
	if (inner_error != NULL) {
		(file == NULL) ? NULL : (file = (g_object_unref (file), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0LL;
	}
	return (_tmp1 = (gint64) 0, (file == NULL) ? NULL : (file = (g_object_unref (file), NULL)), _tmp1);
}


char* mo_utils_getParentFolder (const char* path) {
	GFile* file;
	GFile* parent;
	char* _tmp0;
	g_return_val_if_fail (path != NULL, NULL);
	file = mo_utils_newFile (path);
	parent = g_file_get_parent (file);
	_tmp0 = NULL;
	return (_tmp0 = g_file_get_parse_name (parent), (file == NULL) ? NULL : (file = (g_object_unref (file), NULL)), (parent == NULL) ? NULL : (parent = (g_object_unref (parent), NULL)), _tmp0);
}


char* mo_utils_getKeyString (Profile* profile, const char* group, const char* key) {
	GError * inner_error;
	char* result;
	g_return_val_if_fail (profile != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	result = NULL;
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = g_key_file_get_string (profile->keyFile, group, key, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch29_g_key_file_error;
			}
			goto __finally29;
		}
		_tmp1 = NULL;
		result = (_tmp1 = _tmp0, result = (g_free (result), NULL), _tmp1);
	}
	goto __finally29;
	__catch29_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally29:
	if (inner_error != NULL) {
		result = (g_free (result), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	return result;
}


gint mo_utils_getKeyInteger (Profile* profile, const char* group, const char* key, gint default_val) {
	GError * inner_error;
	gint result;
	g_return_val_if_fail (profile != NULL, 0);
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	inner_error = NULL;
	result = default_val;
	{
		gint _tmp0;
		_tmp0 = g_key_file_get_integer (profile->keyFile, group, key, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch30_g_key_file_error;
			}
			goto __finally30;
		}
		result = _tmp0;
	}
	goto __finally30;
	__catch30_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally30:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	return result;
}


gboolean mo_utils_getKeyBoolean (Profile* profile, const char* group, const char* key, gboolean default_val) {
	GError * inner_error;
	gboolean result;
	g_return_val_if_fail (profile != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	inner_error = NULL;
	result = default_val;
	{
		gboolean _tmp0;
		_tmp0 = g_key_file_get_boolean (profile->keyFile, group, key, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch31_g_key_file_error;
			}
			goto __finally31;
		}
		result = _tmp0;
	}
	goto __finally31;
	__catch31_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally31:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return result;
}


char* mo_utils_getLastMessage (const char* messages) {
	char* message;
	char* escaped;
	char* _tmp0;
	gint splitMessages_size;
	gint splitMessages_length1;
	char** splitMessages;
	char** _tmp2;
	char** _tmp1;
	char* _tmp5;
	message = NULL;
	escaped = g_strescape (messages, "");
	_tmp0 = NULL;
	escaped = (_tmp0 = input_parser_statusReplace (escaped), escaped = (g_free (escaped), NULL), _tmp0);
	splitMessages = (splitMessages_length1 = 0, NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	splitMessages = (_tmp2 = _tmp1 = g_strsplit (escaped, "\\n", 20), splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL), splitMessages_length1 = _vala_array_length (_tmp1), splitMessages_size = splitMessages_length1, _tmp2);
	{
		gint x;
		x = 0;
		for (; x < g_strv_length (splitMessages); x++) {
			if (string_get_length (splitMessages[x]) > 5) {
				char* _tmp4;
				const char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				message = (_tmp4 = (_tmp3 = splitMessages[x], (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), message = (g_free (message), NULL), _tmp4);
			}
		}
	}
	_tmp5 = NULL;
	return (_tmp5 = message, escaped = (g_free (escaped), NULL), splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL), _tmp5);
}


MoUtils* mo_utils_construct (GType object_type) {
	MoUtils * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


MoUtils* mo_utils_new (void) {
	return mo_utils_construct (TYPE_MO_UTILS);
}


static void mo_utils_class_init (MoUtilsClass * klass) {
	mo_utils_parent_class = g_type_class_peek_parent (klass);
}


static void mo_utils_instance_init (MoUtils * self) {
}


GType mo_utils_get_type (void) {
	static GType mo_utils_type_id = 0;
	if (mo_utils_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MoUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mo_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoUtils), 0, (GInstanceInitFunc) mo_utils_instance_init, NULL };
		mo_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "MoUtils", &g_define_type_info, 0);
	}
	return mo_utils_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




