/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_VIEW_ADAPTER_H__
#define __MLVIEW_VIEW_ADAPTER_H__

#include "mlview-app-context.h"
#include "mlview-iview.h"
#include "mlview-xml-document.h"

/**
 *@file
 *The declaration of the #MlViewViewAdapter class.
 */

G_BEGIN_DECLS
/************************************************
 *This class is only the base class of all the 
 *views of an MlViewXMLDocument.
 ************************************************/
#  define MLVIEW_TYPE_VIEW_ADAPTER (mlview_view_adapter_get_type ())
#  define MLVIEW_VIEW_ADAPTER(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), MLVIEW_TYPE_VIEW_ADAPTER, MlViewViewAdapter))
#  define MLVIEW_VIEW_ADAPTER_CLASS(object) (G_TYPE_CHECK_CLASS_CAST ((klass), MVLIEW_TYPE_VIEW_ADAPTER, MlViewViewAdapterClass))
#  define MLVIEW_IS_VIEW_ADAPTER(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), MLVIEW_TYPE_VIEW_ADAPTER))
#  define MLVIEW_IS_VIEW_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_VIEW_ADAPTER))
typedef struct _MlViewViewAdapter MlViewViewAdapter;

typedef struct _MlViewViewAdapterClass
 MlViewViewAdapterClass;

typedef struct _MlViewViewAdapterPrivate
 MlViewViewAdapterPrivate;


enum MLVIEW_VIEW_ADAPTER_STATUS {
        MLVIEW_VIEW_ADAPTER_OK,
        MLVIEW_VIEW_ADAPTER_NOK,
        MLVIEW_VIEW_ADAPTER_DOC_SIGNAL_HANDLERS_NOT_SET,
        MLVIEW_VIEW_ADAPTER_BAD_PARAMETER
};

/**
 *The #MlViewViewAdapter class provides
 *a default implementation of the #MlViewIView interface.
 *Other classes that want to implement #MlViewIView without
 *provided implementation for all the the interfaces' method
 *just have to inherit this class.
 */
struct _MlViewViewAdapter {
        GtkVBox box;
        MlViewViewAdapterPrivate *priv;
};

struct _MlViewViewAdapterClass {
        GtkVBoxClass parent_class;

        /*Document view signals */
        void (*name_changed) (MlViewViewAdapter * a_view,
                              gpointer a_user_data);
};

gint mlview_view_adapter_get_type (void);

enum MlViewStatus mlview_view_adapter_construct (MlViewViewAdapter * a_doc_view,
                                                      MlViewXMLDocument * a_mlview_xml_doc);

MlViewViewAdapter * mlview_view_adapter_new (MlViewXMLDocument * a_mlview_doc);

void mlview_view_adapter_ref (MlViewViewAdapter * a_this);

void mlview_view_adapter_unref (MlViewViewAdapter * a_this);

MlViewFileDescriptor * mlview_view_adapter_get_file_descriptor (MlViewViewAdapter * a_doc_view) ;


G_END_DECLS
#endif /*__MLVIEW_VIEW_ADAPTER_H__*/
