/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published 
 *by the Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *MlView is distributed in the hope that it 
 *will be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the GNU 
 *General Public License along with MlView; 
 *see the file COPYING. If not, write to 
 *the Free Software Foundation, Inc., 
 *59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2003 Dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#include "mlview-xml-doc-tree-view.h"
#ifdef TREE_EDITOR2
#include "mlview-tree-editor2.h"
#else
#include "mlview-tree-editor.h"
#endif


struct _MlViewXMLDocTreeViewPrivate {
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor;
#else
        MlViewTreeEditor *tree_editor;
#endif
        MlViewNodeEditor *node_editor;
        MlViewAppContext *app_context;
        GtkDialog *expand_tree_dialog;
        /*The main paned that divides the view in two main parts */
        GtkPaned *main_paned;
        GtkPaned *upper_paned1;
        GtkCList *feasible_children;
        GtkCList *feasible_prev_siblings;
        GtkCList *feasible_next_siblings;
        GtkCList *feasible_attributes;

        guint main_paned_percentage;
};

enum {
        DOCUMENT_CHANGED,
        SIGNAL_NUM
};

#define PRIVATE(tree_view) (tree_view->priv)

#ifdef TREE_EDITOR2
static void
visual_node_selected_cb (MlViewTreeEditor2 * a_editor,
                         GtkTreeRowReference *a_ref,
                         gpointer a_user_data);
#else
static void
visual_node_selected_cb (MlViewTreeEditor * a_editor,
                         GtkCTreeNode * a_visual_node,
                         gpointer a_user_data);
#endif

static void
xml_node_changed_cb (MlViewNodeEditor * a_editor,
                     gpointer a_data);

static void
toggle_expand_to_leaves_cb (GtkToggleButton * a_toggle_button,
                            gpointer * a_depth_entry);

#ifdef TREE_EDITOR2
static void
update_feasible_attributes_list_cb (MlViewTreeEditor2 * a_editor,
                                    GtkTreeRowReference *a_ref,
                                    gpointer a_user_data) ;
#else
static void
update_feasible_attributes_list_cb (MlViewTreeEditor * a_editor,
                                    GtkCTreeNode * a_visual_node,
                                    gpointer a_user_data);
#endif

#ifdef TREE_EDITOR2
static void
update_feasible_next_siblings_list_cb (MlViewTreeEditor2 * a_editor,
                                        GtkTreeRowReference * a_ref,
                                        gpointer a_user_data);
#else
static void
update_feasible_next_siblings_list_cb (MlViewTreeEditor * a_editor,
                                        GtkCTreeNode *a_visual_node,
                                        gpointer a_user_data);
#endif

#ifdef TREE_EDITOR2
static void
update_feasible_prev_siblings_list_cb (MlViewTreeEditor2 * a_editor,
                                       GtkTreeRowReference * a_ref,
                                       gpointer a_user_data);
#else
static void
update_feasible_prev_siblings_list_cb (MlViewTreeEditor * a_editor,
                                       GtkCTreeNode * a_visual_node,
                                       gpointer a_user_data);
#endif

#ifdef TREE_EDITOR2
static void
update_feasible_children_list_cb (MlViewTreeEditor2 * a_editor,
                                  GtkTreeRowReference *a_ref,
                                  gpointer a_user_data);
#else
static void
update_feasible_children_list_cb (MlViewTreeEditor * a_editor,
                                   GtkCTreeNode * a_visual_node,
                                   gpointer a_user_data);
#endif

static void selected_a_possible_child_cb (GtkCList * a_possible_children,
                                          gint a_row, gint a_column,
                                          GdkEventButton * event,
                                          gpointer a_user_data);

static void selected_a_possible_next_sibling_cb (GtkCList * a_possible_next_siblings,
                                                 gint a_row, gint a_column,
                                                 GdkEventButton * event,
                                                 gpointer a_user_data);

static void selected_a_possible_prev_sibling_cb (GtkCList * a_possible_prev_siblings,
                                                 gint a_row, gint a_column,
                                                 GdkEventButton * event,
                                                 gpointer a_user_data);

static void document_changed_cb (MlViewXMLDocument * a_xml_doc,
                                 gpointer
                                 a_xml_doc_tree_view);

static void node_cut_cb (MlViewXMLDocument * a_xml_doc,
                         xmlNode * a_parent_node,
                         xmlNode * a_node,
                         gpointer
                         a_xml_doc_tree_view);

static void child_node_added_cb (MlViewXMLDocument * a_xml_doc,
                                 xmlNode * a_parent_node,
                                 xmlNode * a_node,
                                 gpointer a_xml_doc_tree_view);

static void prev_sibling_node_inserted_cb (MlViewXMLDocument * a_xml_doc,
                                           xmlNode * a_sibling_node,
                                           xmlNode * a_inserted_node, 
                                           gpointer a_user_data);

static void next_sibling_node_inserted_cb (MlViewXMLDocument * a_xml_doc,
                                           xmlNode * a_sibling_node,
                                           xmlNode * a_added_node, 
                                           gpointer a_user_data);

static void node_changed_cb (MlViewXMLDocument * a_xml_doc,
                             xmlNode * a_node,
                             gpointer
                             a_xml_doc_tree_view);

static void doc_path_changed_cb (MlViewXMLDocument * a_xml_doc,
                                 gpointer a_xml_doc_tree_view);

static void searched_node_found_cb (MlViewXMLDocument *a_xml_doc, 
                                    xmlNode *a_found, 
                                    gpointer a_doc_tree_view) ;

static GtkDialog *get_expand_tree_dialog (MlViewXMLDocTreeView * a_view);

static void mlview_xml_doc_tree_view_init (MlViewXMLDocTreeView * a_tree_view);

static void mlview_xml_doc_tree_view_class_init (MlViewXMLDocTreeViewClass * a_class);

static void mlview_xml_doc_tree_view_destroy (GtkObject * a_object);

static MlViewXMLDocumentViewClass *parent_class = NULL;
static guint p_signals[SIGNAL_NUM] = { 0 };

/*This table lists the callbacks of the xml document signals*/
static SignalCallbackDescriptor gv_signals_fired_by_document[] = {

        {
         "document-changed",         
         G_CALLBACK (document_changed_cb)},

        {
         "child-node-added",         
         G_CALLBACK (child_node_added_cb)},
        {
         "node-cut",
         G_CALLBACK (node_cut_cb)},
        {
         "prev-sibling-node-inserted",
         G_CALLBACK (prev_sibling_node_inserted_cb)
        },
        {
         "next-sibling-node-inserted",
         G_CALLBACK (next_sibling_node_inserted_cb)
        },
        {
         "node-changed",
         G_CALLBACK (node_changed_cb)
        }
        ,
        {
                "searched-node-found",
                G_CALLBACK (searched_node_found_cb)
        },
        {NULL}/*MUST BE THE LAST element of the table */
};


/*========================================
 *private (static) gtk framework functions
 *========================================*/

static void
mlview_xml_doc_tree_view_init (MlViewXMLDocTreeView *
                               a_tree_view)
{

        g_return_if_fail (a_tree_view != NULL);

        if (PRIVATE (a_tree_view) == NULL) {
                PRIVATE (a_tree_view) =
                        g_malloc0 (sizeof
                                   (MlViewXMLDocTreeViewPrivate));
        }
}


/**
 *Class initialyzer.
 *Defines the signal "document-changed" and sets it default handler to NULL. 
 *
 */
static void
mlview_xml_doc_tree_view_class_init (MlViewXMLDocTreeViewClass *
                                     a_class)
{
        GtkObjectClass *object_class =
                (GtkObjectClass *) a_class;

        g_return_if_fail (a_class != NULL);

        parent_class = g_type_class_peek_parent (a_class);

        /*define the virtual destroy method of GtkObject */
        object_class->destroy = mlview_xml_doc_tree_view_destroy;

        p_signals[DOCUMENT_CHANGED] =
                g_signal_new ("document-changed",
                              G_TYPE_FROM_CLASS (object_class),
                              GTK_RUN_FIRST,
                              GTK_SIGNAL_OFFSET
                              (MlViewXMLDocTreeViewClass,
                               document_changed), NULL, NULL,
                              gtk_marshal_NONE__NONE,
                              GTK_TYPE_NONE, 0, NULL);

        /* gtk_object_class_add_signals (object_class, p_signals,
           SIGNAL_NUM) ; */

        a_class->document_changed = NULL;
}


/**********************************************************
 *private helper function and other private methods.
 *********************************************************/

static void
child_node_added_cb (MlViewXMLDocument * a_xml_doc,
                     xmlNode * a_parent_node,
                     xmlNode * a_node,
                     gpointer a_xml_doc_tree_view)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (a_node != NULL);
        g_return_if_fail (a_xml_doc_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_xml_doc_tree_view));

        doc_tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        mlview_tree_editor2_update_child_node_added
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_parent_node, a_node, TRUE);
#else
        mlview_tree_editor_update_child_node_added
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_parent_node, a_node);
#endif
}


static void
prev_sibling_node_inserted_cb (MlViewXMLDocument * a_xml_doc,
                               xmlNode * a_sibling_node, 
                               xmlNode * a_inserted_node,
                               gpointer a_xml_doc_tree_view) 
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (PRIVATE (a_xml_doc) != NULL);
        g_return_if_fail (a_xml_doc_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_xml_doc_tree_view));
        g_return_if_fail (a_sibling_node != NULL);
        g_return_if_fail (a_inserted_node != NULL);

        doc_tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        mlview_tree_editor2_update_sibling_node_inserted
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_sibling_node, a_inserted_node,
                 TRUE /*previous=TRUE */, 
                 TRUE /*emits signals*/);
#else
        mlview_tree_editor_update_sibling_node_inserted
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_sibling_node, a_inserted_node,
                 TRUE /*previous=TRUE */ );
#endif
}

static void
next_sibling_node_inserted_cb (MlViewXMLDocument * a_xml_doc,
                               xmlNode * a_sibling_node, 
                               xmlNode * a_inserted_node,
                               gpointer a_xml_doc_tree_view) 
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (PRIVATE (a_xml_doc) != NULL);
        g_return_if_fail (a_xml_doc_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_xml_doc_tree_view));
        g_return_if_fail (a_sibling_node != NULL);
        g_return_if_fail (a_inserted_node != NULL);

        doc_tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        mlview_tree_editor2_update_sibling_node_inserted
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_sibling_node, a_inserted_node,
                 FALSE /*previous=FALSE */, TRUE);
#else
        mlview_tree_editor_update_sibling_node_inserted
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_sibling_node, a_inserted_node,
                 FALSE /*previous=FALSE */);
#endif
}

static void
node_cut_cb (MlViewXMLDocument * a_xml_doc,
             xmlNode * a_parent_node,
             xmlNode * a_node,
             gpointer a_xml_doc_tree_view)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (PRIVATE (a_xml_doc) != NULL);
        g_return_if_fail (a_node != NULL);
        g_return_if_fail (a_xml_doc_tree_view != NULL);

        doc_tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);

#ifdef TREE_EDITOR2
        mlview_tree_editor2_update_node_cut
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_parent_node, a_node);
#else
        mlview_tree_editor_update_node_cut
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_parent_node, a_node);
#endif
}


static void
node_changed_cb (MlViewXMLDocument * a_xml_doc,
                 xmlNode * a_node,
                 gpointer a_xml_doc_tree_view)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (a_node != NULL);
        g_return_if_fail (a_xml_doc_tree_view != NULL);

        doc_tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);

#ifdef TREE_EDITOR2
        mlview_tree_editor2_update_visual_node2
                (PRIVATE (doc_tree_view)->tree_editor, a_node);
#else
        mlview_tree_editor_update_visual_xml_node
                (PRIVATE (doc_tree_view)->tree_editor, a_node);
#endif
}


static void
doc_path_changed_cb (MlViewXMLDocument * a_xml_doc,
                     gpointer a_xml_doc_tree_view)
{
        MlViewFileDescriptor *file_desc = NULL;
        MlViewXMLDocTreeView *tree_view = NULL;
        gchar *path = NULL;

        g_return_if_fail (a_xml_doc != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOCUMENT (a_xml_doc));
        g_return_if_fail (a_xml_doc_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_xml_doc_tree_view));

        tree_view =
                MLVIEW_XML_DOC_TREE_VIEW (a_xml_doc_tree_view);

        file_desc =
                mlview_xml_document_get_file_descriptor
                (a_xml_doc);

        g_return_if_fail (file_desc != NULL);

        path = mlview_file_descriptor_get_file_path (file_desc);

        g_return_if_fail (path != NULL);

        mlview_xml_doc_tree_view_set_xml_document_path
                (tree_view, path);

}

static void
searched_node_found_cb (MlViewXMLDocument *a_xml_doc, 
                        xmlNode *a_found, 
                        gpointer a_doc_tree_view)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;

        g_return_if_fail (a_xml_doc
                          && MLVIEW_IS_XML_DOCUMENT (a_xml_doc)
                          && a_found
                          && a_doc_tree_view
                          && MLVIEW_IS_XML_DOC_TREE_VIEW 
                          (a_doc_tree_view)) ;
        doc_tree_view = a_doc_tree_view ;

#ifdef TREE_EDITOR2
        mlview_tree_editor2_select_node
                (PRIVATE (doc_tree_view)->tree_editor,
                 a_found) ;
#endif
        
}

static void
mlview_xml_doc_tree_view_destroy (GtkObject * a_object)
{
        MlViewXMLDocTreeView *tree_view = NULL;

        g_return_if_fail (a_object != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_object));

        tree_view = MLVIEW_XML_DOC_TREE_VIEW (a_object);
        if (PRIVATE (tree_view) == NULL)
                return;

        if (PRIVATE (tree_view)->expand_tree_dialog) {
                gtk_widget_destroy
                        (GTK_WIDGET
                         (PRIVATE (tree_view)->
                          expand_tree_dialog));

                PRIVATE (tree_view)->expand_tree_dialog = NULL;
        }

        if (PRIVATE (tree_view)) {
                g_free (PRIVATE (tree_view));
                PRIVATE (tree_view) = NULL;
        }

        /*call the destroy method of the parent */
        if (GTK_OBJECT_CLASS (parent_class)->destroy)
                (*GTK_OBJECT_CLASS (parent_class)->
                 destroy) (a_object);
}

/*========================================
 *private (static) helper functions
 *========================================*/

/**
 *This callback is called when an xml 
 *node is selected by the user. It calls the
 *mlview_node_editor_edit_xml_node() method of the MlViewNodeEditor object. 
 *
 */
#ifdef TREE_EDITOR2
static void
visual_node_selected_cb (MlViewTreeEditor2 * a_editor,
                         GtkTreeRowReference * a_ref,
                         gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        MlViewXMLDocument *mlview_xml_doc = NULL;
        GtkTreeView *tree_view = NULL ;

        g_return_if_fail (a_editor
                          && MLVIEW_IS_TREE_EDITOR2 (a_editor)
                          && PRIVATE (a_editor)
                          && a_ref
                              && a_user_data) ;        
        tree_view = mlview_tree_editor2_get_tree_view (a_editor) ;
        g_return_if_fail (tree_view && GTK_IS_TREE_VIEW (tree_view)) ;
        view = a_user_data ;
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW (view)
                          && PRIVATE (view) 
                          && PRIVATE (view)->node_editor
                          && MLVIEW_IS_NODE_EDITOR 
                          (PRIVATE (view)->node_editor)) ;

        xml_node =
                mlview_tree_editor2_get_xml_node2 (a_editor, a_ref) ;
        g_return_if_fail (xml_node) ;
        mlview_xml_doc =
                mlview_xml_document_view_get_document
                (MLVIEW_XML_DOCUMENT_VIEW (view));
        g_return_if_fail (mlview_xml_doc);
        /*
         *TODO: figure out if this is really needed.
        gtk_object_set_data (GTK_OBJECT
                             (PRIVATE (view)->node_editor),
                             _("Visual node"), a_visual_node);
        */

        mlview_node_editor_edit_xml_node (PRIVATE (view)->
                                          node_editor,
                                          mlview_xml_doc,
                                          xml_node);
        gtk_widget_show_all (GTK_WIDGET
                             (PRIVATE (view)->node_editor));
}
#else
static void
visual_node_selected_cb (MlViewTreeEditor * a_editor,
                         GtkCTreeNode * a_visual_node,
                         gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        MlViewXMLDocument *mlview_xml_doc = NULL;

        g_return_if_fail (a_editor != NULL);
        g_return_if_fail (MLVIEW_IS_TREE_EDITOR (a_editor));
        g_return_if_fail (PRIVATE (a_editor) != NULL);
        g_return_if_fail (mlview_tree_editor_get_visual_tree
                          (a_editor)
                          != NULL);
        g_return_if_fail (GTK_IS_CTREE
                          (mlview_tree_editor_get_visual_tree
                           (a_editor)));
        g_return_if_fail (a_visual_node != NULL);
        g_return_if_fail (a_user_data != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));

        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        xml_node =
                (xmlNodePtr) gtk_ctree_node_get_row_data
                (mlview_tree_editor_get_visual_tree (a_editor),
                 a_visual_node);

        mlview_xml_doc =
                mlview_xml_document_view_get_document
                (MLVIEW_XML_DOCUMENT_VIEW (view));

        g_return_if_fail (mlview_xml_doc != NULL);
        g_return_if_fail (xml_node != NULL);
        g_return_if_fail (PRIVATE (view) != NULL);
        g_return_if_fail (PRIVATE (view)->node_editor != NULL);
        g_return_if_fail (MLVIEW_IS_NODE_EDITOR
                          (PRIVATE (view)->node_editor));

        gtk_object_set_data (GTK_OBJECT
                             (PRIVATE (view)->node_editor),
                             _("Visual node"), a_visual_node);

        mlview_node_editor_edit_xml_node (PRIVATE (view)->
                                          node_editor,
                                          mlview_xml_doc,
                                          xml_node);
        gtk_widget_show_all (GTK_WIDGET
                             (PRIVATE (view)->node_editor));
}
#endif

/**
 *The callback of the "element-changed signal" 
 *emited by the element editor of MlViewEditor 
 */
#ifdef TREE_EDITOR2
static void
xml_node_changed_cb (MlViewNodeEditor * a_node_editor,
                     gpointer a_data)
{
        GtkTreeView *visual_tree=NULL;
        xmlNodePtr xml_node=NULL;
        MlViewXMLDocTreeView *view=NULL;

        g_return_if_fail (a_node_editor
                          && MLVIEW_IS_NODE_EDITOR (a_node_editor)
                          && a_data
                          && MLVIEW_IS_XML_DOC_TREE_VIEW (a_data)) ;
        xml_node =
                mlview_node_editor_get_current_xml_node 
                (a_node_editor);
        g_return_if_fail (xml_node != NULL);

        /*get the visual tree */
        view = MLVIEW_XML_DOC_TREE_VIEW (a_data);
        g_return_if_fail (view && PRIVATE (view)
                          && PRIVATE (view)->tree_editor
                          && MLVIEW_IS_TREE_EDITOR2
                          (PRIVATE (view)->tree_editor)) ;
        visual_tree =
                mlview_tree_editor2_get_tree_view
                (PRIVATE (view)->tree_editor);

        g_return_if_fail (visual_tree
                          && GTK_IS_TREE_VIEW (visual_tree));
        mlview_tree_editor2_update_visual_node2
                (PRIVATE (view)->tree_editor, xml_node);
}
#else
static void
xml_node_changed_cb (MlViewNodeEditor * a_node_editor,
                     gpointer a_data)
{
        GtkCTreeNode *visual_node=NULL;
        GtkCTree *visual_tree=NULL;
        xmlNodePtr xml_node=NULL;
        MlViewXMLDocTreeView *view=NULL;

        g_return_if_fail (a_node_editor
                          && MLVIEW_IS_NODE_EDITOR (a_node_editor)
                          && a_data
                          && MLVIEW_IS_XML_DOC_TREE_VIEW (a_data)) ;
        xml_node =
                mlview_node_editor_get_current_xml_node 
                (a_node_editor);
        g_return_if_fail (xml_node != NULL);

        /*get the visual tree */
        view = MLVIEW_XML_DOC_TREE_VIEW (a_data);
        g_return_if_fail (view && PRIVATE (view)
                          && PRIVATE (view)->tree_editor
                          && MLVIEW_IS_TREE_EDITOR 
                          (PRIVATE (view)->tree_editor)) ;
        visual_tree =
                mlview_tree_editor_get_visual_tree
                (PRIVATE (view)->tree_editor);

        g_return_if_fail (visual_tree
                          && GTK_IS_CTREE (visual_tree));
        /*get the visual node to modify */
        visual_node = GTK_CTREE_NODE (gtk_object_get_data
                                      (GTK_OBJECT
                                       (a_node_editor),
                                       _("Visual node")));
        g_return_if_fail (visual_node);
        mlview_tree_editor_update_visual_node (PRIVATE (view)->
                                               tree_editor,
                                               visual_node);
}
#endif

/**
 *
 */
static void
toggle_expand_to_leaves_cb (GtkToggleButton * a_toggle_button,
                            gpointer * a_depth_entry)
{
        g_return_if_fail (a_toggle_button != NULL);
        g_return_if_fail (GTK_IS_TOGGLE_BUTTON
                          (a_toggle_button));
        g_return_if_fail (a_depth_entry != NULL);
        g_return_if_fail (GTK_IS_WIDGET (a_depth_entry));

        if (gtk_toggle_button_get_active (a_toggle_button) ==
            TRUE)
                gtk_widget_set_sensitive (GTK_WIDGET
                                          (a_depth_entry),
                                          FALSE);
        else
                gtk_widget_set_sensitive (GTK_WIDGET
                                          (a_depth_entry), TRUE);
}

/**
 *This callback is invoked when the user selects a visual xml node. 
 *It's a callback function for the "node-selected" signal of
 *#MlViewTreeEditor2.
 *
 */
#ifdef TREE_EDITOR2
void
update_feasible_children_list_cb (MlViewTreeEditor2 * a_editor,
                                  GtkTreeRowReference * a_ref,
                                  gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkTreeView *tree_view=NULL ;

        g_return_if_fail (a_editor 
                          && MLVIEW_IS_TREE_EDITOR2 (a_editor)
                          && a_ref && a_user_data
                          && MLVIEW_IS_XML_DOC_TREE_VIEW 
                          (a_user_data));
        tree_view = mlview_tree_editor2_get_tree_view (a_editor) ;
        g_return_if_fail (tree_view 
                          && GTK_IS_TREE_VIEW (tree_view)) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);
        gtk_clist_clear (PRIVATE (view)->feasible_children);
        xml_node = mlview_tree_editor2_get_xml_node2 (a_editor,
                                                      a_ref) ;
        g_return_if_fail (xml_node) ;
        if (xml_node->type == XML_ELEMENT_NODE) {

                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         ADD_CHILD,
                         xml_node, &children_name_list);

        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append (PRIVATE (view)->
                                          feasible_children,
                                          clist_text);

                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#else
static void
update_feasible_children_list_cb (MlViewTreeEditor * a_editor,
                                  GtkCTreeNode * a_visual_node,
                                  gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;

        g_return_if_fail (a_editor != NULL);
        g_return_if_fail (MLVIEW_IS_TREE_EDITOR (a_editor));
        g_return_if_fail (PRIVATE (a_editor) != NULL);
        g_return_if_fail (mlview_tree_editor_get_visual_tree
                          (a_editor) != NULL);
        g_return_if_fail (GTK_IS_CTREE
                          (mlview_tree_editor_get_visual_tree
                           (a_editor)));
        g_return_if_fail (a_visual_node != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));


        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);

        gtk_clist_clear (PRIVATE (view)->feasible_children);

        xml_node =
                (xmlNodePtr) gtk_ctree_node_get_row_data
                (mlview_tree_editor_get_visual_tree (a_editor),
                 a_visual_node);

        g_return_if_fail (xml_node != NULL);

        if (xml_node->type == XML_ELEMENT_NODE) {

                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         ADD_CHILD,
                         xml_node, &children_name_list);

        }

        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append (PRIVATE (view)->
                                          feasible_children,
                                          clist_text);

                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#endif

/**
 *This callback is invoked when the user selects a visual xml node. 
 *It is a callback of the "node-selected" signal.
 */
#ifdef TREE_EDITOR2
static void
update_feasible_prev_siblings_list_cb (MlViewTreeEditor2 *a_editor,
                                       GtkTreeRowReference *a_ref,
                                       gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkTreeView *tree_view=NULL ;

        g_return_if_fail (a_editor
                          && MLVIEW_IS_TREE_EDITOR2 (a_editor)
                          && PRIVATE (a_editor)
                          && a_ref
                          && a_user_data) ;
        tree_view = mlview_tree_editor2_get_tree_view (a_editor) ;
        g_return_if_fail (tree_view) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);

        gtk_clist_clear (PRIVATE (view)->feasible_prev_siblings);
        xml_node =
                mlview_tree_editor2_get_xml_node2 (a_editor,
                                                   a_ref) ;
        g_return_if_fail (xml_node);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         INSERT_BEFORE,
                         xml_node, &children_name_list);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append
                                (PRIVATE (view)->
                                 feasible_prev_siblings,
                                 clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#else
static void
update_feasible_prev_siblings_list_cb (MlViewTreeEditor *a_editor,
                                       GtkCTreeNode *
                                       a_visual_node,
                                       gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkCTree *ctree=NULL ;

        g_return_if_fail (a_editor
                          && MLVIEW_IS_TREE_EDITOR (a_editor)
                          && PRIVATE (a_editor)
                          && a_visual_node
                          && a_user_data) ;
        ctree = mlview_tree_editor_get_visual_tree (a_editor) ;
        g_return_if_fail (ctree) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);

        gtk_clist_clear (PRIVATE (view)->feasible_prev_siblings);
        xml_node =
                (xmlNodePtr) gtk_ctree_node_get_row_data
                (mlview_tree_editor_get_visual_tree (a_editor),
                 a_visual_node);
        g_return_if_fail (xml_node != NULL);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         INSERT_BEFORE,
                         xml_node, &children_name_list);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append
                                (PRIVATE (view)->
                                 feasible_prev_siblings,
                                 clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#endif

/**
 *This callback is invoked when the user selects a visual xml node. 
 *This is a callback for the "node-selected" signal.
 */
#ifdef TREE_EDITOR2
static void
update_feasible_next_siblings_list_cb (MlViewTreeEditor2 *a_editor,
                                       GtkTreeRowReference *a_ref,
                                       gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkTreeView *tree_view=NULL ;

        g_return_if_fail (a_editor
                          && MLVIEW_IS_TREE_EDITOR2 (a_editor)
                          && PRIVATE (a_editor)
                          && a_ref
                          && a_user_data) ;
        tree_view = mlview_tree_editor2_get_tree_view (a_editor) ;
        g_return_if_fail (tree_view) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);
        gtk_clist_clear (PRIVATE (view)->feasible_next_siblings);
        xml_node = 
                mlview_tree_editor2_get_xml_node2 (a_editor, a_ref) ;
        g_return_if_fail (xml_node != NULL);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         INSERT_AFTER, xml_node,
                         &children_name_list);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append
                                (PRIVATE (view)->
                                 feasible_next_siblings,
                                 clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#else
static void
update_feasible_next_siblings_list_cb (MlViewTreeEditor *a_editor,
                                       GtkCTreeNode * a_visual_node,
                                       gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkCTree *ctree=NULL ;

        g_return_if_fail (a_editor
                          && MLVIEW_IS_TREE_EDITOR (a_editor)
                          && PRIVATE (a_editor)
                          && a_visual_node
                          && a_user_data) ;
        ctree = mlview_tree_editor_get_visual_tree (a_editor) ;
        g_return_if_fail (ctree) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);
        gtk_clist_clear (PRIVATE (view)->feasible_next_siblings);
        xml_node =
                (xmlNodePtr) gtk_ctree_node_get_row_data
                (mlview_tree_editor_get_visual_tree (a_editor),
                 a_visual_node);
        g_return_if_fail (xml_node != NULL);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_element_name_completion_list
                        (PRIVATE (view)->app_context,
                         INSERT_AFTER, xml_node,
                         &children_name_list);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append
                                (PRIVATE (view)->
                                 feasible_next_siblings,
                                 clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#endif

/**
 *This callback is invoked when the user selects a visual xml node. 
 *
 */
#ifdef TREE_EDITOR2
static void
update_feasible_attributes_list_cb (MlViewTreeEditor2 * a_editor,
                                    GtkTreeRowReference *a_ref,
                                    gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkTreeView *tree_view=NULL ;

        g_return_if_fail (a_editor 
                          && MLVIEW_IS_TREE_EDITOR2 (a_editor)
                          && PRIVATE (a_editor)
                          && a_ref
                          && a_user_data) ;
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));

        tree_view = mlview_tree_editor2_get_tree_view (a_editor) ;
        g_return_if_fail (tree_view) ;
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);
        gtk_clist_clear (PRIVATE (view)->feasible_attributes);
        xml_node = mlview_tree_editor2_get_xml_node2 (a_editor,
                                                      a_ref) ;
        g_return_if_fail (xml_node != NULL);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_attribute_name_completion_list
                        (PRIVATE (view)->app_context, xml_node,
                         &children_name_list, FALSE);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append (PRIVATE (view)->
                                          feasible_attributes,
                                          clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#else
static void
update_feasible_attributes_list_cb (MlViewTreeEditor * a_editor,
                                    GtkCTreeNode * a_visual_node,
                                    gpointer a_user_data)
{
        MlViewXMLDocTreeView *view = NULL;
        xmlNode *xml_node = NULL;
        GList *children_name_list = NULL;
        gint nb_of_names = 0;
        GtkCTree *ctree=NULL ;

        g_return_if_fail (a_editor 
                          && MLVIEW_IS_TREE_EDITOR (a_editor)
                          && PRIVATE (a_editor)
                          && a_visual_node
                          && a_user_data) ;

        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));
        ctree = mlview_tree_editor_get_visual_tree (a_editor) ;
        g_return_if_fail (ctree) ;        
        view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (view) != NULL);
        gtk_clist_clear (PRIVATE (view)->feasible_attributes);
        xml_node =
                (xmlNodePtr) gtk_ctree_node_get_row_data
                (mlview_tree_editor_get_visual_tree (a_editor),
                 a_visual_node);
        g_return_if_fail (xml_node != NULL);
        if (xml_node->type == XML_ELEMENT_NODE) {
                nb_of_names =
                        mlview_parsing_utils_build_attribute_name_completion_list
                        (PRIVATE (view)->app_context, xml_node,
                         &children_name_list, FALSE);
        }
        if (nb_of_names > 0) {
                gchar *clist_text[1] = { NULL };
                gchar *cur_name =
                        (gchar *) children_name_list->data;
                GList *cur = children_name_list;

                while (cur_name) {
                        clist_text[0] = cur_name;
                        gtk_clist_append (PRIVATE (view)->
                                          feasible_attributes,
                                          clist_text);
                        cur = (cur->next) ? cur->next : NULL;
                        cur_name =
                                (cur) ? (gchar *) cur->
                                data : NULL;
                }
        }
}
#endif

static void
selected_a_possible_child_cb (GtkCList * a_possible_children,
                              gint a_row, gint a_column,
                              GdkEventButton * event,
                              gpointer a_user_data)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;
#ifdef TREE_EDITOR2
        GtkTreeIter cur_sel_start={0} ;
        gboolean is_ok=FALSE ;
#else
        GtkCTreeNode *cur_sel_start=NULL;
#endif
        gchar *element_name = NULL;
        gint status = 0;

        g_return_if_fail (a_possible_children != NULL);
        g_return_if_fail (GTK_IS_CLIST (a_possible_children));
        g_return_if_fail (a_user_data != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));

        doc_tree_view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        is_ok = 
                mlview_tree_editor2_get_cur_sel_start_iter
                (PRIVATE (doc_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (is_ok == TRUE) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (PRIVATE (doc_tree_view)->tree_editor);
        g_return_if_fail (cur_sel_start != NULL);
#endif        
        /*do not free element_name!! */
        status = gtk_clist_get_text (a_possible_children,
                                     a_row, a_column,
                                     &element_name);
        if (status == 1) {
                /*text retrieved ! */
                xmlNode *new_node = NULL;

                if (strcmp (element_name, "#PCDATA") == 0) {
                        new_node = xmlNewNode (NULL, "text");
                        new_node->type = XML_TEXT_NODE;
                } else {
                        new_node =
                                xmlNewNode (NULL, element_name);
                }
#ifdef TREE_EDITOR2
                mlview_tree_editor2_add_child_node 
                        (PRIVATE (doc_tree_view)->tree_editor,
                         &cur_sel_start, new_node) ;
#else
                mlview_tree_editor_add_child_node 
                        (PRIVATE(doc_tree_view)->tree_editor,
                         cur_sel_start, new_node);
#endif
        }
}

static void
selected_a_possible_prev_sibling_cb (GtkCList * a_possible_prev_siblings,
                                     gint a_row, gint a_column,
                                     GdkEventButton * event,
                                     gpointer a_user_data)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;
#ifdef TREE_EDITOR2
        gboolean is_ok = FALSE ;
        enum MlViewStatus stat = MLVIEW_OK ;
        GtkTreeIter cur_sel_start = {0} ;
#else
        GtkCTreeNode *cur_sel_start = NULL;
#endif
        gchar *element_name = NULL;
        gint status = 0;

        g_return_if_fail (a_possible_prev_siblings != NULL);
        g_return_if_fail (GTK_IS_CLIST
                          (a_possible_prev_siblings));
        g_return_if_fail (a_user_data != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));
        doc_tree_view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        is_ok = mlview_tree_editor2_get_cur_sel_start_iter 
                (PRIVATE (doc_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (is_ok == TRUE) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (PRIVATE (doc_tree_view)->tree_editor);
        g_return_if_fail (cur_sel_start != NULL);
#endif
        /*do not free element_name!! */
        status = gtk_clist_get_text (a_possible_prev_siblings,
                                     a_row, a_column,
                                     &element_name);
        if (status == 1) {
                /*text retrieved ! */
                xmlNode *new_node = NULL;
                if (strcmp (element_name, "#PCDATA") == 0) {
                        new_node = xmlNewNode (NULL, "text");
                        new_node->type = XML_TEXT_NODE;
                } else {
                        new_node =
                                xmlNewNode (NULL, element_name);
                }
#ifdef TREE_EDITOR2
                stat = mlview_tree_editor2_insert_sibling_node
                        (PRIVATE (doc_tree_view)->tree_editor,
                         &cur_sel_start, new_node, TRUE) ;
                g_return_if_fail (stat == MLVIEW_OK);
#else
                mlview_tree_editor_insert_sibling_node
                        (PRIVATE (doc_tree_view)->tree_editor,
                         cur_sel_start, new_node, TRUE);
#endif
        }
}


static void
selected_a_possible_next_sibling_cb (GtkCList * a_possible_next_siblings,
                                     gint a_row, gint a_column,
                                     GdkEventButton * event,
                                     gpointer a_user_data)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;
#ifdef TREE_EDITOR2
        GtkTreeIter cur_sel_start = {0} ;
        gboolean is_ok = FALSE ;
        enum MlViewStatus stat = MLVIEW_OK ;
#else
        GtkCTreeNode *cur_sel_start = NULL;
#endif
        gchar *element_name = NULL;
        gint status = 0;

        g_return_if_fail (a_possible_next_siblings != NULL);
        g_return_if_fail (GTK_IS_CLIST
                          (a_possible_next_siblings));
        g_return_if_fail (a_user_data != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));
        doc_tree_view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);
        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
#ifdef TREE_EDITOR2
        is_ok = mlview_tree_editor2_get_cur_sel_start_iter
                (PRIVATE (doc_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (is_ok == TRUE) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (PRIVATE (doc_tree_view)->tree_editor);
        g_return_if_fail (cur_sel_start != NULL);
#endif
        /*do not free element_name!! */
        status = gtk_clist_get_text (a_possible_next_siblings,
                                     a_row, a_column,
                                     &element_name);
        if (status == 1) {
                /*text retrieved ! */
                xmlNode *new_node = NULL;
                if (strcmp (element_name, "#PCDATA") == 0) {
                        new_node = xmlNewNode (NULL, "text");
                        new_node->type = XML_TEXT_NODE;
                } else {
                        new_node =
                                xmlNewNode (NULL, element_name);
                }
#ifdef TREE_EDITOR2
                stat = mlview_tree_editor2_insert_sibling_node
                        (PRIVATE (doc_tree_view)->tree_editor,
                         &cur_sel_start, new_node, FALSE) ;
#else
                mlview_tree_editor_insert_sibling_node
                        (PRIVATE (doc_tree_view)->tree_editor,
                         cur_sel_start, new_node, FALSE);
#endif
        }
}


/**
 *
 */
static void
selected_a_possible_attribute_cb (GtkCList * a_possible_attributes,
                                  gint a_row, gint a_column,
                                  GdkEventButton * a_event,
                                  gpointer a_user_data)
{
        MlViewXMLDocTreeView *doc_tree_view = NULL;
        MlViewXMLDocument *mlview_xml_doc = NULL;        
#ifdef TREE_EDITOR2
        enum MlViewStatus stat = MLVIEW_OK ;
        gboolean is_ok = FALSE ;
        GtkTreeIter cur_sel_start = {0} ;
        GtkTreeView *visual_tree = NULL;
#else
        GtkCTreeNode *cur_sel_start = NULL;
        GtkCTree *visual_tree = NULL;
#endif        
        gchar *attribute_name = NULL;
        gint status = 0;

        g_return_if_fail (a_possible_attributes != NULL);
        g_return_if_fail (GTK_IS_CLIST (a_possible_attributes));
        g_return_if_fail (a_user_data != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_user_data));

        doc_tree_view = MLVIEW_XML_DOC_TREE_VIEW (a_user_data);

        g_return_if_fail (PRIVATE (doc_tree_view) != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (doc_tree_view));
        g_return_if_fail (PRIVATE (doc_tree_view)->tree_editor !=
                          NULL);
        g_return_if_fail (PRIVATE (doc_tree_view)->node_editor !=
                          NULL);

        mlview_xml_doc =
                mlview_xml_document_view_get_document
                (MLVIEW_XML_DOCUMENT_VIEW (doc_tree_view));
        g_return_if_fail (mlview_xml_doc != NULL);
#ifdef TREE_EDITOR2
        is_ok = mlview_tree_editor2_get_cur_sel_start_iter 
                (PRIVATE (doc_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (is_ok == TRUE) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (PRIVATE (doc_tree_view)->tree_editor);
        g_return_if_fail (cur_sel_start != NULL);
#endif

#ifdef TREE_EDITOR2
        visual_tree = mlview_tree_editor2_get_tree_view 
                (PRIVATE (doc_tree_view)->tree_editor) ;
#else
        visual_tree =
                mlview_tree_editor_get_visual_tree 
                (PRIVATE (doc_tree_view)->tree_editor);        
#endif
        g_return_if_fail (visual_tree != NULL);
        status = gtk_clist_get_text 
                (a_possible_attributes, a_row, 
                 a_column, &attribute_name); /*do not free attribute_name!! */
        if (status == 1) {
                /*text retrieved ! */
                xmlNode *xml_node = NULL;
                xmlAttr *attr = NULL;
#ifdef TREE_EDITOR2
                xml_node = mlview_tree_editor2_get_xml_node
                        (PRIVATE (doc_tree_view)->tree_editor,
                         &cur_sel_start) ;
#else
                xml_node = (xmlNode *)
                        gtk_ctree_node_get_row_data 
                        (visual_tree, cur_sel_start);
#endif
                g_return_if_fail (xml_node != NULL);
                attr = xmlNewProp (xml_node,
                                   attribute_name,
                                   "value");
#ifdef TREE_EDITOR2
                stat = mlview_tree_editor2_update_visual_node 
                        (PRIVATE (doc_tree_view)->tree_editor,
                         &cur_sel_start) ;
                g_return_if_fail (stat == MLVIEW_OK) ;
#else
                mlview_tree_editor_update_visual_node 
                        (PRIVATE (doc_tree_view)->tree_editor,
                         cur_sel_start);
#endif
                mlview_node_editor_edit_xml_node
                        (PRIVATE (doc_tree_view)->node_editor,
                         mlview_xml_doc, xml_node) ;                
        }
}

static void
document_changed_cb (MlViewXMLDocument *a_xml_doc,
                     gpointer a_xml_doc_tree_view)
{


}

/**
 *This function builds a GtkDialog that will ask the user
 *to entrer the depth to which she wants the tree to be expanded.
 *The expansion depth is entered in a GtkEntry widget 
 *associated with the returned
 *dialog (using the function gtk_object_set_data ()) via the key "depth-entry".
 *The expand-to-leaves info is intered in a 
 *GtkCheckButton widget associated with the
 *returned dialg (using the function gtk_object_set_data ()) 
 *via the key "expand-to-leave".
 *The info intered by the user can then be recovered by using the function
 *gtk_object_get_data () using the key "depth-entry" 
 *the get the GtkEntry widget that
 *captured the depth entry if any or the 
 *key "expand-to-leaves" to get the GtkCheckButton widget
 *that captured the "expand-to-leaves" info. 
 *
 */
static GtkDialog *
get_expand_tree_dialog (MlViewXMLDocTreeView * a_view) 
{
        GtkWidget *table = NULL,
                *label = NULL,
                *depth_entry = NULL;
        GtkWidget *expand_to_leaves = NULL;

        g_return_val_if_fail (a_view != NULL, NULL);
        g_return_val_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                              (a_view), NULL);
        g_return_val_if_fail (PRIVATE (a_view) != NULL, NULL);

        if (PRIVATE (a_view)->expand_tree_dialog == NULL) {
                PRIVATE (a_view)->expand_tree_dialog =
                        GTK_DIALOG
                        (gtk_dialog_new_with_buttons
                         (_
                          ("Choose the depth of the tree expansion"),
                          NULL, GTK_DIALOG_MODAL, _("OK"),
                          GTK_RESPONSE_ACCEPT, _("Cancel"),
                          GTK_RESPONSE_REJECT, NULL));

                /*En attendant que l on trouve une solution commune
                   mlview_app_context_set_window_icon 
                   (PRIVATE (a_view)->app_context, 
                   GTK_WIDGET (PRIVATE (a_view)->expand_tree_dialog)) ; */

                gtk_window_set_wmclass (GTK_WINDOW
                                        (PRIVATE (a_view)->
                                         expand_tree_dialog),
                                        "choose-depth-dialog",
                                        "MlView");

                expand_to_leaves =
                        gtk_check_button_new_with_label (_
                                                         ("expand to leaves"));

                gtk_box_pack_start_defaults
                        (GTK_BOX
                         (PRIVATE (a_view)->expand_tree_dialog->
                          vbox), expand_to_leaves);

                label = gtk_label_new (_
                                       ("absolute expansion depth:"));
                depth_entry = gtk_entry_new ();
                gtk_entry_set_text (GTK_ENTRY (depth_entry),
                                    "2");

                table = gtk_table_new (1, 2, FALSE);
                gtk_table_attach_defaults (GTK_TABLE (table),
                                           label, 0, 1, 0, 1);
                gtk_table_attach_defaults (GTK_TABLE (table),
                                           depth_entry, 1, 2, 0,
                                           1);

                gtk_box_pack_start_defaults
                        (GTK_BOX
                         (PRIVATE (a_view)->expand_tree_dialog->
                          vbox), table);

                g_signal_connect (G_OBJECT (expand_to_leaves),
                                  "toggled",
                                  G_CALLBACK
                                  (toggle_expand_to_leaves_cb),
                                  depth_entry);

                gtk_widget_show_all
                        (PRIVATE (a_view)->expand_tree_dialog->
                         vbox);

                gtk_object_set_data
                        (GTK_OBJECT
                         (PRIVATE (a_view)->expand_tree_dialog),
                         "expand-to-leaves", expand_to_leaves);

                gtk_object_set_data
                        (GTK_OBJECT
                         (PRIVATE (a_view)->expand_tree_dialog),
                         "depth-entry", depth_entry);
        }

        return PRIVATE (a_view)->expand_tree_dialog;
}


/*========================================
 *public gtk framework functions
 *========================================*/
guint
mlview_xml_doc_tree_view_get_type (void)
{
        static guint type = 0;

        if (!type) {
                static const GTypeInfo type_info = {
                        sizeof (MlViewXMLDocTreeViewClass),
                        NULL, NULL,
                        (GClassInitFunc)
                                mlview_xml_doc_tree_view_class_init,
                        NULL, NULL,
                        sizeof (MlViewXMLDocTreeView),
                        0,
                        (GInstanceInitFunc)
                        mlview_xml_doc_tree_view_init
                };
                type = g_type_register_static
                        (MLVIEW_TYPE_XML_DOCUMENT_VIEW,
                         "MlViewXMLDocTreeView", &type_info, 0);
        }

        return type;
}


/**
 *
 */
#ifdef TREE_EDITOR2
MlViewTreeEditor2 *
#else
MlViewTreeEditor *
#endif
mlview_xml_doc_tree_view_get_tree_editor (MlViewXMLDocTreeView *a_tree_view)
{
        g_return_val_if_fail (a_tree_view != NULL, NULL);
        g_return_val_if_fail (PRIVATE (a_tree_view) != NULL,
                              NULL);

        return PRIVATE (a_tree_view)->tree_editor;
}

/**
 *
 */
MlViewNodeEditor *
mlview_xml_doc_tree_view_get_node_editor (MlViewXMLDocTreeView *a_tree_view)
{
        g_return_val_if_fail (a_tree_view != NULL, NULL);
        g_return_val_if_fail (PRIVATE (a_tree_view) != NULL,
                              NULL);

        return PRIVATE (a_tree_view)->node_editor;
}


/**
 *
 */
GtkWidget *
mlview_xml_doc_tree_view_new (MlViewXMLDocument * a_mlview_xml_doc, 
                              gchar * a_name,
                              MlViewAppContext * a_app_context)
{
        MlViewXMLDocTreeView *tree_view = NULL;

        g_return_val_if_fail (a_mlview_xml_doc != NULL, NULL);
        g_return_val_if_fail (PRIVATE (a_mlview_xml_doc) != NULL,
                              NULL);

        tree_view =
                g_object_new (MLVIEW_TYPE_XML_DOC_TREE_VIEW,
                              NULL);

        mlview_xml_doc_tree_view_construct (tree_view,
                                            a_mlview_xml_doc,
                                            a_name,
                                            a_app_context);

        return GTK_WIDGET (tree_view);
}


void
mlview_xml_doc_tree_view_set_app_context (MlViewXMLDocTreeView *a_tree_view,
                                          MlViewAppContext *a_app_context)
{
        g_return_if_fail (a_tree_view != NULL);
        g_return_if_fail (PRIVATE (a_tree_view) != NULL);

        PRIVATE (a_tree_view)->app_context = a_app_context;

        if (PRIVATE (a_tree_view)->tree_editor) {
#ifdef TREE_EDITOR2
                mlview_tree_editor2_set_application_context 
                        (PRIVATE (a_tree_view)->tree_editor,
                         a_app_context) ;
#else
                mlview_tree_editor_set_application_context
                        (PRIVATE (a_tree_view)->tree_editor,
                         a_app_context);
#endif
        }

        if (PRIVATE (a_tree_view)->node_editor) {
                mlview_node_editor_set_application_context
                        (PRIVATE (a_tree_view)->node_editor,
                         a_app_context);
        }
}

void
mlview_xml_doc_tree_view_construct (MlViewXMLDocTreeView *a_tree_view,
                                    MlViewXMLDocument *a_mlview_xml_doc,
                                    gchar * a_name,
                                    MlViewAppContext *a_app_context)
{
        GtkWidget *table = NULL,
                *scrolled = NULL;
        enum MLVIEW_XML_DOCUMENT_VIEW_STATUS status = NOK;

        const gchar *feasible_children_titles[1] =
                { _("Possible Children") };

        const gchar *feasible_prev_siblings_titles[1] =
                { _("Possible previous siblings") };

        const gchar *feasible_next_siblings_titles[1] =
                { _("Possible next siblings") };

        const gchar *feasible_attributes_titles[1] =
                { _("Possible attributes") };

        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_tree_view));
        g_return_if_fail (a_mlview_xml_doc != NULL);

        mlview_xml_document_view_set_document_signal_handlers
                (gv_signals_fired_by_document);

        status = mlview_xml_document_view_construct
                (MLVIEW_XML_DOCUMENT_VIEW (a_tree_view),
                 a_mlview_xml_doc);

        g_return_if_fail (status == MLVIEW_XML_DOCUMENT_VIEW_OK);

        /*The main vpaned of the view */
        PRIVATE (a_tree_view)->main_paned =
                GTK_PANED (gtk_vpaned_new ());

        gtk_box_pack_start (GTK_BOX (a_tree_view),
                            GTK_WIDGET (PRIVATE (a_tree_view)->
                                        main_paned), TRUE, TRUE,
                            0);

        gtk_widget_show (GTK_WIDGET
                         (PRIVATE (a_tree_view)->main_paned));

        /*The tree editor */
#ifdef TREE_EDITOR2
        PRIVATE (a_tree_view)->tree_editor =
                MLVIEW_TREE_EDITOR2 (mlview_tree_editor2_new
                                     (a_app_context));
#else
        PRIVATE (a_tree_view)->tree_editor =
                MLVIEW_TREE_EDITOR (mlview_tree_editor_new
                                    (a_app_context));
#endif
        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->tree_editor),
                          "node-selected",
                          G_CALLBACK (visual_node_selected_cb),
                          a_tree_view);

        PRIVATE (a_tree_view)->upper_paned1 =
                GTK_PANED (gtk_hpaned_new ());

        gtk_paned_add1 (GTK_PANED
                        (PRIVATE (a_tree_view)->main_paned),
                        GTK_WIDGET (PRIVATE (a_tree_view)->
                                    upper_paned1));

        gtk_paned_add1 (GTK_PANED
                        (PRIVATE (a_tree_view)->upper_paned1),
                        GTK_WIDGET (PRIVATE (a_tree_view)->
                                    tree_editor));

        /*the table with the feasible children, siblings and attributes */
        PRIVATE (a_tree_view)->feasible_children =
                GTK_CLIST (gtk_clist_new_with_titles
                           (1, (gchar**)feasible_children_titles));

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->
                           feasible_children), "select-row",
                          G_CALLBACK
                          (selected_a_possible_child_cb),
                          a_tree_view);

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->tree_editor),
                          "node-selected",
                          G_CALLBACK
                          (update_feasible_children_list_cb),
                          a_tree_view);

        PRIVATE (a_tree_view)->feasible_prev_siblings =
                GTK_CLIST (gtk_clist_new_with_titles
                           (1, (gchar**)feasible_prev_siblings_titles));

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->
                           feasible_prev_siblings), "select-row",
                          G_CALLBACK
                          (selected_a_possible_prev_sibling_cb),
                          a_tree_view);

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->tree_editor),
                          "node-selected",
                          G_CALLBACK
                          (update_feasible_prev_siblings_list_cb),
                          a_tree_view);

        PRIVATE (a_tree_view)->feasible_next_siblings =
                GTK_CLIST (gtk_clist_new_with_titles
                           (1, (gchar**) feasible_next_siblings_titles));

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->
                           feasible_next_siblings), "select-row",
                          G_CALLBACK
                          (selected_a_possible_next_sibling_cb),
                          a_tree_view);

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->tree_editor),
                          "node-selected",
                          G_CALLBACK
                          (update_feasible_next_siblings_list_cb),
                          a_tree_view);

        PRIVATE (a_tree_view)->feasible_attributes =
                GTK_CLIST
                (gtk_clist_new_with_titles
                 (1, (gchar**)feasible_attributes_titles));

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->
                           feasible_attributes), "select-row",
                          GTK_SIGNAL_FUNC
                          (selected_a_possible_attribute_cb),
                          a_tree_view);

        g_signal_connect (GTK_OBJECT
                          (PRIVATE (a_tree_view)->tree_editor),
                          "node-selected",
                          G_CALLBACK
                          (update_feasible_attributes_list_cb),
                          a_tree_view);

        table = gtk_table_new (2, 2, TRUE);

        scrolled = gtk_scrolled_window_new (NULL, NULL);

        gtk_container_add
                (GTK_CONTAINER (scrolled),
                 GTK_WIDGET (PRIVATE (a_tree_view)->
                             feasible_children));

        gtk_table_attach_defaults (GTK_TABLE (table), scrolled,
                                   0, 1, 0, 1);

        scrolled = gtk_scrolled_window_new (NULL, NULL);

        gtk_container_add (GTK_CONTAINER (scrolled),
                           GTK_WIDGET
                           (PRIVATE (a_tree_view)->
                            feasible_prev_siblings));

        gtk_table_attach_defaults (GTK_TABLE (table), scrolled,
                                   1, 2, 0, 1);

        scrolled = gtk_scrolled_window_new (NULL, NULL);

        gtk_container_add (GTK_CONTAINER (scrolled),
                           GTK_WIDGET
                           (PRIVATE (a_tree_view)->
                            feasible_next_siblings));

        gtk_table_attach_defaults (GTK_TABLE (table), scrolled,
                                   1, 2, 1, 2);

        scrolled = gtk_scrolled_window_new (NULL, NULL);

        gtk_container_add (GTK_CONTAINER (scrolled),
                           GTK_WIDGET
                           (PRIVATE (a_tree_view)->
                            feasible_attributes));

        gtk_table_attach_defaults (GTK_TABLE (table), scrolled,
                                   0, 1, 1, 2);

        gtk_paned_add2 (GTK_PANED
                        (PRIVATE (a_tree_view)->upper_paned1),
                        table);

        /*The node editor */
        PRIVATE (a_tree_view)->node_editor =
                MLVIEW_NODE_EDITOR (mlview_node_editor_new
                                    (a_app_context));

        g_signal_connect (G_OBJECT
                          (PRIVATE (a_tree_view)->node_editor),
                          "element-changed",
                          G_CALLBACK (xml_node_changed_cb),
                          a_tree_view);

        gtk_paned_add2 (GTK_PANED
                        (PRIVATE (a_tree_view)->main_paned),
                        GTK_WIDGET (PRIVATE (a_tree_view)->
                                    node_editor));

        gtk_widget_show_all (GTK_WIDGET
                             (PRIVATE (a_tree_view)->
                              node_editor));

        gtk_widget_show_all (GTK_WIDGET
                             (PRIVATE (a_tree_view)->
                              main_paned));

        PRIVATE (a_tree_view)->app_context = a_app_context;
#ifdef TREE_EDITOR2
        mlview_tree_editor2_edit_xml_doc 
                (PRIVATE (a_tree_view)->tree_editor,
                 a_mlview_xml_doc, NULL);
#else
        mlview_tree_editor_edit_xml_doc 
                (PRIVATE (a_tree_view)->tree_editor,
                 a_mlview_xml_doc, NULL);
#endif
        g_signal_connect (G_OBJECT (a_mlview_xml_doc),
                          "file-path-changed",
                          G_CALLBACK
                          (doc_path_changed_cb),
                          a_tree_view);
}


/**
 *
 */
void
mlview_xml_doc_tree_view_add_child_node_interactive (MlViewXMLDocTreeView * a_tree_view)
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor = NULL;
#else
        MlViewTreeEditor *tree_editor = NULL;
#endif
        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);
#ifdef TREE_EDITOR2
        if (tree_editor)
                mlview_tree_editor2_add_child_node_interactive
                        (tree_editor);
#else
        if (tree_editor)
                mlview_tree_editor_add_child_node_interactive
                        (tree_editor);
#endif
}


/**
 *
 */
void
mlview_xml_doc_tree_view_insert_prev_sibling_node_interactive (MlViewXMLDocTreeView * a_tree_view)
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor = NULL;
#else
        MlViewTreeEditor *tree_editor = NULL;
#endif
        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);

        if (tree_editor) {
#ifdef TREE_EDITOR2
                mlview_tree_editor2_insert_prev_sibling_node_interactive
                        (tree_editor);
#else
                mlview_tree_editor_insert_prev_sibling_node_interactive
                        (tree_editor);
#endif
        }
}


/**
 *
 */
void
mlview_xml_doc_tree_view_insert_next_sibling_node_interactive (MlViewXMLDocTreeView * a_tree_view) 
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor = NULL;
#else
        MlViewTreeEditor *tree_editor = NULL;
#endif
        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);

        if (tree_editor) {
#ifdef TREE_EDITOR2
                mlview_tree_editor2_insert_next_sibling_node_interactive
                        (tree_editor);
#else
                mlview_tree_editor_insert_next_sibling_node_interactive
                        (tree_editor);
#endif
        }
}


/**
 *
 */
void
mlview_xml_doc_tree_view_cut_node (MlViewXMLDocTreeView *a_tree_view)
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor = NULL;
        GtkTreeIter cur_sel_start = {0};
        enum MlViewStatus status = MLVIEW_OK ;
#else
        MlViewTreeEditor *tree_editor = NULL;
        GtkCTreeNode *cur_sel_start = NULL;
#endif
        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);

        if (tree_editor == NULL)
                return;
#ifdef TREE_EDITOR2
        status = mlview_tree_editor2_get_cur_sel_start_iter 
                (tree_editor, &cur_sel_start);
        g_return_if_fail (status == MLVIEW_OK) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (tree_editor);        
        if (cur_sel_start == NULL)
                return;
#endif        
#ifdef TREE_EDITOR2
        mlview_tree_editor2_cut_node (tree_editor,
                                      &cur_sel_start);
#else
        mlview_tree_editor_cut_node (tree_editor,
                                     cur_sel_start);
#endif
}


/**
 *
 */
void
mlview_xml_doc_tree_view_copy_node (MlViewXMLDocTreeView *a_tree_view)
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor = NULL;
        GtkTreeIter cur_sel_start = {0} ;
        enum MlViewStatus status = MLVIEW_OK ;
#else
        MlViewTreeEditor *tree_editor = NULL;
        GtkCTreeNode *cur_sel_start = NULL;
#endif
        g_return_if_fail (a_tree_view != NULL);

        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);
        if (tree_editor == NULL)
                return;
#ifdef TREE_EDITOR2
        status = mlview_tree_editor2_get_cur_sel_start_iter
                (tree_editor, &cur_sel_start) ;
        g_return_if_fail (status == MLVIEW_OK) ;
#else
        cur_sel_start =
                mlview_tree_editor_get_current_selected_node
                (tree_editor);
        if (cur_sel_start == NULL)
                return;
#endif
#ifdef TREE_EDITOR2
        mlview_tree_editor2_copy_node (tree_editor,
                                       &cur_sel_start) ;
#else
        mlview_tree_editor_copy_node (tree_editor,
                                      cur_sel_start,
                                      TRUE);
#endif
}


/**
 *
 */
void
mlview_xml_doc_tree_view_paste_node_as_child (MlViewXMLDocTreeView * a_tree_view) 
{
#ifdef TREE_EDITOR2
        GtkTreeIter cur_sel_start={0} ;
        enum MlViewStatus status = MLVIEW_OK;
#else
        GtkCTreeNode *cur_sel_start=NULL ;
#endif
        g_return_if_fail (a_tree_view
                          && MLVIEW_IS_XML_DOC_TREE_VIEW (a_tree_view)
                          && PRIVATE (a_tree_view)
                          && PRIVATE (a_tree_view)->tree_editor);
#ifdef TREE_EDITOR2
        status = mlview_tree_editor2_get_cur_sel_start_iter 
                (PRIVATE (a_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (status == MLVIEW_OK) ;
        mlview_tree_editor2_paste_node_as_child
                (PRIVATE (a_tree_view)->tree_editor,
                 &cur_sel_start);
#else
        cur_sel_start = mlview_tree_editor_get_current_selected_node
                (PRIVATE (a_tree_view)->tree_editor) ;
        g_return_if_fail (cur_sel_start) ;
        mlview_tree_editor_paste_node_as_child
                (PRIVATE (a_tree_view)->tree_editor,
                 cur_sel_start);
#endif
}

/**
 *
 */
void
mlview_xml_doc_tree_view_paste_node_as_prev_sibling (MlViewXMLDocTreeView * a_tree_view) 
{
#ifdef TREE_EDITOR2
        GtkTreeIter cur_sel_start={0} ;
        enum MlViewStatus status=MLVIEW_OK ;
#else
        GtkCTreeNode *cur_sel_start=NULL ;
#endif

        g_return_if_fail (a_tree_view != NULL
                          && MLVIEW_IS_XML_DOC_TREE_VIEW (a_tree_view)
                          && PRIVATE (a_tree_view));
#ifdef TREE_EDITOR2
        status = mlview_tree_editor2_get_cur_sel_start_iter
                (PRIVATE (a_tree_view)->tree_editor, 
                 &cur_sel_start) ;
        g_return_if_fail (status == MLVIEW_OK) ;
        status = mlview_tree_editor2_paste_node_as_sibling
                (PRIVATE (a_tree_view)->tree_editor, 
                 &cur_sel_start, TRUE) ;
#else
        cur_sel_start = mlview_tree_editor_get_current_selected_node
                (PRIVATE (a_tree_view)->tree_editor) ;
        g_return_if_fail (cur_sel_start) ;
        mlview_tree_editor_paste_node_as_sibling
                (PRIVATE (a_tree_view)->tree_editor,
                 cur_sel_start, TRUE);
#endif
}


/**
 *Pastes the last node found in the clipboard at
 *the place of the the currently selected xml node.
 *@param a_tree_view a pointer to the current instance
 *of MlViewXMLDocTreeView.
 *
 */
void 
mlview_xml_doc_tree_view_paste_node_as_next_sibling (MlViewXMLDocTreeView * a_tree_view) 
{
#ifdef TREE_EDITOR2
        GtkTreeIter cur_sel_start={0} ;
        enum MlViewStatus status = MLVIEW_OK ;
#else
        GtkCTreeNode *cur_sel_start=NULL ;
#endif
        g_return_if_fail (a_tree_view != NULL);
        g_return_if_fail (PRIVATE (a_tree_view) != NULL);

#ifdef TREE_EDITOR2
        status = mlview_tree_editor2_get_cur_sel_start_iter
                (PRIVATE (a_tree_view)->tree_editor,
                 &cur_sel_start) ;
        g_return_if_fail (status == MLVIEW_OK) ;
        mlview_tree_editor2_paste_node_as_sibling
                (PRIVATE (a_tree_view)->tree_editor,
                 &cur_sel_start, FALSE) ;
#else
        cur_sel_start = mlview_tree_editor_get_current_selected_node
                (PRIVATE (a_tree_view)->tree_editor) ;
        g_return_if_fail (cur_sel_start) ;
        mlview_tree_editor_paste_node_as_sibling
                (PRIVATE (a_tree_view)->tree_editor,
                 cur_sel_start, FALSE);
#endif
}


/**
 *Finds the graphical node that contains the given string.
 *@param a_tree_view a pointer to the current instance of
 *#MlViewXMLDocTreeView.
 *@return the graphical xml node that contains the given string.
 */
GtkCTreeNode *
mlview_xml_doc_tree_view_find_xml_node_that_contains_str_interactive (MlViewXMLDocTreeView * a_tree_view) 
{
#ifdef TREE_EDITOR2
        MlViewTreeEditor2 *tree_editor;
#else
        MlViewTreeEditor *tree_editor;
#endif
        g_return_val_if_fail (a_tree_view != NULL, NULL);

        tree_editor =
                mlview_xml_doc_tree_view_get_tree_editor
                (a_tree_view);
        g_return_val_if_fail (tree_editor != NULL, NULL);
#ifdef TREE_EDITOR2
        mlview_tree_editor2_search_interactive (tree_editor) ;
        return NULL ;
#else
        return mlview_tree_editor_find_xml_node_that_contains_str_interactive (tree_editor);
#endif
        
}


/**
 *
 */
void
mlview_xml_doc_tree_view_set_upper_paned1_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                       const guint a_percentage) 
{
        gint separator_position = 0;
        GtkWidget *top_level_widget = NULL;
        
        g_return_if_fail (a_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_tree_view));
        g_return_if_fail (PRIVATE (a_tree_view) != NULL);

        top_level_widget =
                gtk_widget_get_toplevel (GTK_WIDGET
                                         (a_tree_view));
        g_return_if_fail (top_level_widget != NULL);

        separator_position =
                top_level_widget->allocation.width *
                a_percentage / 100;

        gtk_paned_set_position (PRIVATE (a_tree_view)->
                                upper_paned1,
                                separator_position);

        gtk_widget_show_all (GTK_WIDGET (a_tree_view));
}


/**
 *Sets the GtkPaned top/bottom proportions of the main 
 *paned to a_percentage. This method gets the bounds of the top level widget
 *in order to determine the total size of the GtkVPaned 
 *(which actually has the same boundaries as the top level widget) and do
 *the calculation of the proportions of the top part vs bottom 
 *part of the GtkVPaned.
 *Therefore, this method must be called 
 *only *AFTER* the document has been opened and 
 *the top level of the document is shown. 
 *
 */
void
mlview_xml_doc_tree_view_set_main_paned_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                     const guint a_percentage) 
{
        guint separator_position = 0;
        GtkWidget *top_level_widget = NULL;

        g_return_if_fail (a_tree_view != NULL);
        g_return_if_fail (PRIVATE (a_tree_view) != NULL);
        top_level_widget =
                gtk_widget_get_toplevel (GTK_WIDGET
                                         (a_tree_view));
        g_return_if_fail (top_level_widget != NULL);

        PRIVATE (a_tree_view)->main_paned_percentage =
                a_percentage;

        separator_position =
                top_level_widget->allocation.height *
                a_percentage / 100;

        gtk_paned_set_position (PRIVATE (a_tree_view)->
                                main_paned, separator_position);

        gtk_widget_show_all (GTK_WIDGET (a_tree_view));
}


/**
 *
 */
void
mlview_xml_doc_tree_view_set_all_paned_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                    const guint a_main_paned_percentage,
                                                    const guint a_node_editor_paned_percentage) 
{
        g_return_if_fail (a_tree_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW
                          (a_tree_view));
        g_return_if_fail (PRIVATE (a_tree_view) != NULL);
        g_return_if_fail (PRIVATE (a_tree_view)->node_editor !=
                          NULL);


        mlview_node_editor_set_left_right_percentage
                (PRIVATE (a_tree_view)->node_editor,
                 a_node_editor_paned_percentage);

        mlview_xml_doc_tree_view_set_upper_paned1_proportions
                (a_tree_view, 70);

        mlview_xml_doc_tree_view_set_main_paned_proportions
                (a_tree_view, a_main_paned_percentage);
}


/**
 *Sets the title of the xml DOM to @a_file_path.
 *Updates this information in the tree editor and in the
 *XML DOM. 
 *@param a_view the current instance of #MlViewXMLDocTreeView.
 *@param a_file_path the new file path.
 */
void
mlview_xml_doc_tree_view_set_xml_document_path (MlViewXMLDocTreeView * a_view, 
                                                gchar * a_file_path) 
{
        guchar *base_name = NULL;

        g_return_if_fail (a_file_path != NULL);
        g_return_if_fail (a_view != NULL);
        g_return_if_fail (PRIVATE (a_view) != NULL);

        if (PRIVATE (a_view)->tree_editor) {
#ifdef TREE_EDITOR2
                mlview_tree_editor2_set_xml_document_path
                        (PRIVATE (a_view)->tree_editor,
                         a_file_path) ;
#else
                mlview_tree_editor_set_xml_document_path
                        (PRIVATE (a_view)->tree_editor,
                         a_file_path);
#endif
        }
        base_name = (guchar *) g_basename (a_file_path);

        mlview_xml_document_view_set_name
                (MLVIEW_XML_DOCUMENT_VIEW (a_view), base_name);
}


/**
 *Opens a dialog box to ask the user the depth to which the tree
 *should be expanded and expands the tree to that depths. 
 *
 */
void 
mlview_xml_doc_tree_view_expand_tree_to_depth_interactive (MlViewXMLDocTreeView * a_view) 
{
        GtkDialog *dialog = NULL;
        GtkWidget *expand_to_leaves = NULL,
                *depth_entry = NULL;
        gint button = 0,
                depth = 0;
        gchar *depth_str = NULL;

        g_return_if_fail (a_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW (a_view));
        g_return_if_fail (PRIVATE (a_view) != NULL);

        dialog = get_expand_tree_dialog (a_view);
        g_return_if_fail (dialog != NULL);

        button = gtk_dialog_run (dialog);

        expand_to_leaves =
                gtk_object_get_data (GTK_OBJECT (dialog),
                                     "expand-to-leaves");
        g_return_if_fail (expand_to_leaves != NULL);

        depth_entry = gtk_object_get_data (GTK_OBJECT (dialog),
                                           "depth-entry");
        g_return_if_fail (depth_entry != NULL);

        switch (button) {
        case GTK_RESPONSE_ACCEPT: /*user clicked OK */
                if (gtk_toggle_button_get_active
                    (GTK_TOGGLE_BUTTON (expand_to_leaves)) ==
                    TRUE) {
#ifdef TREE_EDITOR2
                        mlview_tree_editor2_expand_tree_to_depth
                                (PRIVATE (a_view)->tree_editor,
                                 -1);
#else
                        mlview_tree_editor_expand_tree_to_depth
                                (PRIVATE (a_view)->tree_editor,
                                 -1);
#endif
                } else {
                        depth_str = (guchar *)
                                gtk_entry_get_text (GTK_ENTRY
                                                    (depth_entry));

                        if (depth_str) {
                                depth = atoi (depth_str);
#ifdef TREE_EDITOR2
                                mlview_tree_editor2_expand_tree_to_depth
                                        (PRIVATE
                                         (a_view)->tree_editor, 
                                         depth);
#else
                                mlview_tree_editor_expand_tree_to_depth
                                        (PRIVATE 
                                         (a_view)->tree_editor,
                                         depth);
#endif
                        }
                }
                break;
        case GTK_RESPONSE_REJECT: /*user clicked CANCEL */
        case GTK_RESPONSE_CLOSE: /*closed the dialog box */
        default:               /*the sky falls on our heads */
                break;
        }

        gtk_widget_hide (GTK_WIDGET (dialog));
}

void
mlview_xml_doc_tree_view_update_contextual_menu (MlViewXMLDocTreeView * a_view, 
                                                 GtkMenu ** a_menu_ptr) 
{
        g_return_if_fail (a_view != NULL);
        g_return_if_fail (MLVIEW_IS_XML_DOC_TREE_VIEW (a_view));
        g_return_if_fail (PRIVATE (a_view) != NULL);
        g_return_if_fail (a_menu_ptr != NULL);
        g_return_if_fail (*a_menu_ptr != NULL);
        g_return_if_fail (GTK_IS_MENU (*a_menu_ptr));

        if (PRIVATE (a_view)->tree_editor) {
#ifdef TREE_EDITOR2
#else
                mlview_tree_editor_update_contextual_menu
                        (PRIVATE (a_view)->tree_editor,
                         a_menu_ptr);
#endif
        }

}

