/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

/**
 *This class is the abstraction of a visual tree editor.
 *Given an xmlNode (gnome-xml) based tree, 
 *it can visualize it, support cut/copy/paste operations
 *that modifies directly the underlying xmlNode based tree etc ...
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
#ifndef __MLVIEW_TREE_EDITOR2_H__
#define __MLVIEW_TREE_EDITOR2_H__

#include <gtk/gtk.h>
#include <libxml/tree.h>
#include "mlview-node-type-picker.h"
#include "mlview-settings-builder.h"
#include "mlview-app-context.h"
#include "mlview-xml-document.h"


G_BEGIN_DECLS
/*common macros to comply with the GtkObject typing system.*/
#define MLVIEW_TYPE_TREE_EDITOR2 (mlview_tree_editor2_get_type())
#define MLVIEW_TREE_EDITOR2(object) (G_TYPE_CHECK_INSTANCE_CAST((object),MLVIEW_TYPE_TREE_EDITOR2,MlViewTreeEditor2))
#define MLVIEW_TREE_EDITOR2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass),MLVIEW_TYPE_TREE_EDITOR2,MlViewTreeEditor2Class))
#define MLVIEW_IS_TREE_EDITOR2(object) (G_TYPE_CHECK_INSTANCE_TYPE((object),MLVIEW_TYPE_TREE_EDITOR2))
#define MLVIEW_IS_TREE_EDITOR2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),MLVIEW_TYPE_TREE_EDITOR2))
/*common class and instance definitions*/
typedef struct _MlViewTreeEditor2 MlViewTreeEditor2;
typedef struct _MlViewTreeEditor2Class MlViewTreeEditor2Class;
typedef struct _MlViewTreeEditor2Private
 MlViewTreeEditor2Private;


/*====================================================================
 *The structure representing
 *the MlViewTreeEditor2 object.
 *===================================================================*/
struct _MlViewTreeEditor2 {
        GtkVBox vbox;
        MlViewTreeEditor2Private *priv;
};

/*==================================================
 *some other structures
 *=================================================*/



/*==========================================================
 *Exported methods:
 *==========================================================*/

guint mlview_tree_editor2_get_type (void);

GtkWidget *mlview_tree_editor2_new (MlViewAppContext *
                                    a_app_context);

GtkTreeModel *mlview_tree_editor2_get_model (MlViewTreeEditor2 *a_this);

void mlview_tree_editor2_destroy (GtkObject * a_object);

enum MlViewStatus mlview_tree_editor2_edit_xml_doc (MlViewTreeEditor2 * a_editor,
                                                    MlViewXMLDocument * a_doc,
                                                    guchar * a_doc_name);
GtkTreeView *mlview_tree_editor2_get_tree_view (MlViewTreeEditor2 * a_this);

enum MlViewStatus mlview_tree_editor2_get_iter (MlViewTreeEditor2 * a_this,
                                                xmlNode * a_node,
                                                GtkTreeIter * a_iter);
GtkTreeRowReference* mlview_tree_editor2_get_sel_start (MlViewTreeEditor2 *
                                                        a_this);

enum MlViewStatus mlview_tree_editor2_update_visual_node (MlViewTreeEditor2 * a_this,
                                                          GtkTreeIter * a_iter);

enum MlViewStatus mlview_tree_editor2_update_visual_node2 (MlViewTreeEditor2 * a_this,
                                                           xmlNode * a_node);

enum MlViewStatus mlview_tree_editor2_add_child_node (MlViewTreeEditor2 * a_tree_editor,
                                                      GtkTreeIter * a_parent_iter,
                                                      xmlNodePtr a_xml_node);

enum MlViewStatus mlview_tree_editor2_insert_sibling_node (MlViewTreeEditor2 * a_this,
                                                           GtkTreeIter *a_ref_iter,
                                                           xmlNode * a_node,
                                                           gboolean a_previous);
enum MlViewStatus mlview_tree_editor2_cut_node (MlViewTreeEditor2 * a_this,
                                                GtkTreeIter * a_iter);
enum MlViewStatus mlview_tree_editor2_cut_node2 (MlViewTreeEditor2 * a_this,
                                                GtkTreePath * a_path);
enum MlViewStatus mlview_tree_editor2_copy_node (MlViewTreeEditor2 * a_this,
                                                 GtkTreeIter * a_iter);
enum MlViewStatus mlview_tree_editor2_copy_node2 (MlViewTreeEditor2 * a_this,
                                                 GtkTreePath * a_path);
void  mlview_tree_editor2_create_new_xml_doc (MlViewTreeEditor2 * a_this,
                                              MlViewXMLDocument * a_doc);

enum MlViewStatus mlview_tree_editor2_search_interactive (MlViewTreeEditor2 *a_this) ;

enum MlViewStatus mlview_tree_editor2_search (MlViewTreeEditor2 *a_this,
                                              GtkTreeRowReference *a_from,
                                              struct SearchConfig *a_config) ;

void mlview_tree_editor2_set_root_element (MlViewTreeEditor2 *a_this,
                                      xmlNode *a_node, 
                                      gboolean a_emit_signals) ;

enum MlViewStatus mlview_tree_editor2_paste_node_as_child (MlViewTreeEditor2 *a_this,
                                                           GtkTreeIter *a_parent_iter) ;

enum MlViewStatus mlview_tree_editor2_paste_node_as_sibling (MlViewTreeEditor2 *a_this,
                                                             GtkTreeIter *a_ref_iter,
                                                             gboolean a_previous) ;
enum MlViewStatus mlview_tree_editor2_paste_node_as_sibling2 (MlViewTreeEditor2 *a_this,
                                                             GtkTreePath *a_ref_path,
                                                             gboolean a_previous) ;
MlViewXMLDocument * mlview_tree_editor2_get_mlview_xml_doc (MlViewTreeEditor2 *a_this) ;

enum MlViewStatus mlview_tree_editor2_get_cur_sel_start_iter (MlViewTreeEditor2 *a_this,
                                                              GtkTreeIter *a_iter) ;
GtkTreeRowReference* mlview_tree_editor2_get_cur_sel_start (MlViewTreeEditor2 *a_this) ;

xmlNode * mlview_tree_editor2_get_cur_sel_xml_node (MlViewTreeEditor2 *a_this) ;

MlViewNodeTypePicker* mlview_tree_editor2_get_node_type_picker (MlViewTreeEditor2 * a_tree_editor);

enum MlViewStatus mlview_tree_editor2_set_node_type_picker (MlViewTreeEditor2 *a_this,
                                                            MlViewNodeTypePicker *a_picker) ;

GtkTreeRowReference * mlview_tree_editor2_iter_2_row_ref (MlViewTreeEditor2 *a_this,
                                                          GtkTreeIter *a_iter) ;

void mlview_tree_editor2_add_child_node_interactive (MlViewTreeEditor2 * a_tree_editor);

void mlview_tree_editor2_insert_sibling_node_interactive (MlViewTreeEditor2 * a_tree_editor);

void mlview_tree_editor2_insert_next_sibling_node_interactive  (MlViewTreeEditor2 * a_tree_editor);

void mlview_tree_editor2_insert_prev_sibling_node_interactive  (MlViewTreeEditor2 * a_tree_editor);

GtkCTreeNode * mlview_tree_editor2_find_xml_node_that_contains_str (MlViewTreeEditor2 * a_tree_editor, 
                                                                    const gchar * a_str,
                                                                    const enum WhereInTheNodeBitmap a_where_in_node_bitmap,
                                                                    const gboolean a_start_after);

GtkCTreeNode * mlview_tree_editor2_find_xml_node_that_contains_str_interactive (MlViewTreeEditor2 * a_tree_editor);

void mlview_tree_editor2_set_xml_document_path  (MlViewTreeEditor2 * a_tree_editor, 
                                                 gchar * a_file_path);

xmlNode *mlview_tree_editor2_get_xml_node  (MlViewTreeEditor2 * a_this,
                                            GtkTreeIter * a_iter);

xmlNode * mlview_tree_editor2_get_xml_node3 (MlViewTreeEditor2 *a_this,
                                             GtkTreePath *a_path) ;

xmlNode * mlview_tree_editor2_get_xml_node2  (MlViewTreeEditor2 * a_this,
                                              GtkTreeRowReference * a_row_ref) ;

void mlview_tree_editor2_set_application_context  (MlViewTreeEditor2 * a_this,
                                                   MlViewAppContext * a_ctxt);

MlViewAppContext* mlview_tree_editor2_get_application_context (MlViewTreeEditor2 * a_this);

void mlview_tree_editor2_update_contextual_menu  (MlViewTreeEditor2 * a_tree_editor,
                                                  GtkMenu **a_menu_ptr); 

enum MlViewStatus mlview_tree_editor2_update_child_node_added (MlViewTreeEditor2 * a_this, 
                                                               xmlNode * a_parent,
                                                               xmlNode * a_node, 
                                                               gboolean a_emit_signals);

enum MlViewStatus mlview_tree_editor2_update_node_cut  (MlViewTreeEditor2 * a_this,
                                                        xmlNode * a_parent_node,
                                                        xmlNode * a_node_cut);

enum MlViewStatus mlview_tree_editor2_update_node_pasted  (MlViewTreeEditor2 * a_this,
                                                           xmlNode * a_parent_node,
                                                           xmlNode * a_node,
                                                           gboolean a_emit_signals);

enum MlViewStatus mlview_tree_editor2_update_sibling_node_inserted (MlViewTreeEditor2 * a_this, 
                                                                    xmlNode * a_ref_node,
                                                                    xmlNode * a_inserted_node, 
                                                                    gboolean a_previous,
                                                                    gboolean a_emit_signals);

void mlview_tree_editor2_expand_tree_to_depth (MlViewTreeEditor2 * a_this,
                                               gint a_depth) ;

void mlview_tree_editor2_select_node (MlViewTreeEditor2 *a_this,
                                      xmlNode *a_node) ;

/*===============================================================
 *The structure representing the class of all the MlViewTreeEditor2 objects.
 *==============================================================*/
struct _MlViewTreeEditor2Class {
        GtkVBoxClass parent_class;

 /*============================
  *signal handlers definitions
  *===========================*/
          
        /**
         *This signal is emitted whenever an
         *action edition changes the tree.
         *@param a_editor the instance of #MlViewTreeEditor2
         *that emitted the signal.
         *@param a_data some custom user data
         */
        void (*tree_changed) (MlViewTreeEditor2 * a_editor,
                              gpointer a_data);
        /**
         *Emitted when a node is cut.
         *@param a_editor the instance of #MlViewTreeEditor2 that
         *emitted the signal.
         *@param a_node_cut the node that has been cut.
         *@param a_user_data a custom user data.
         */
        void (*node_cut) (MlViewTreeEditor2 * a_editor,
                          xmlNode *a_node_cut,
                          gpointer a_user_data);
        /**
         *Emitted when a node is pasted.
         *@param a_editor the instance of #MlViewTreeEditor2 that
         *emitted the signal.
         *@param a_ref the row reference of the newly pasted
         *column
         *@param a_user_data a custom user data.
         */
        void (*node_pasted) (MlViewTreeEditor2 * a_editor,
                             GtkTreeRowReference * a_ref,
                             gpointer a_user_data);
        /**
         *Emitted when a node is added.
         *"Added" means that the node is 
         *either "inserted" or "added" as the
         *last child node of another node.
         *@param a_editor the instance of #MlViewTreeEditor2
         *that emitted the signal.
         *@param a_ref the row reference of the column
         *that has been added.
         *@param a_user_data some custom user data.
         */
        void (*node_added) (MlViewTreeEditor2 * a_editor,
                            GtkTreeRowReference * a_ref,
                            gpointer a_user_data);
        /**
         *Emitted when a node is selected.
         *@param a_editor the instance of #MlViewTreeEditor2 that
         *emitted the signal.
         *@param a_ref the tree row reference of the column
         *that emited the signal.
         *@param a_user_data a custom user data.
         */
        void (*node_selected) (MlViewTreeEditor2 * a_editor,
                               GtkTreeRowReference *a_ref,
                               gpointer a_user_data);
};


G_END_DECLS
#endif /*__MLVIEW_TREE_EDITOR2_H__*/
