/* Metacity X property convenience routines */

/* 
 * Copyright (C) 2001 Havoc Pennington
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef META_XPROPS_H
#define META_XPROPS_H

#include "display.h"
#include <X11/Xutil.h>

/* Copied from Lesstif by way of GTK. Rudimentary docs can be
 * found in some Motif reference guides online.
 */
typedef struct {
    unsigned long flags;
    unsigned long functions;
    unsigned long decorations;
    long input_mode;
    unsigned long status;
} MotifWmHints, MwmHints;

#define MWM_HINTS_FUNCTIONS     (1L << 0)
#define MWM_HINTS_DECORATIONS   (1L << 1)
#define MWM_HINTS_INPUT_MODE    (1L << 2)
#define MWM_HINTS_STATUS        (1L << 3)

#define MWM_FUNC_ALL            (1L << 0)
#define MWM_FUNC_RESIZE         (1L << 1)
#define MWM_FUNC_MOVE           (1L << 2)
#define MWM_FUNC_MINIMIZE       (1L << 3)
#define MWM_FUNC_MAXIMIZE       (1L << 4)
#define MWM_FUNC_CLOSE          (1L << 5)

#define MWM_DECOR_ALL           (1L << 0)
#define MWM_DECOR_BORDER        (1L << 1)
#define MWM_DECOR_RESIZEH       (1L << 2)
#define MWM_DECOR_TITLE         (1L << 3)
#define MWM_DECOR_MENU          (1L << 4)
#define MWM_DECOR_MINIMIZE      (1L << 5)
#define MWM_DECOR_MAXIMIZE      (1L << 6)

#define MWM_INPUT_MODELESS 0
#define MWM_INPUT_PRIMARY_APPLICATION_MODAL 1
#define MWM_INPUT_SYSTEM_MODAL 2
#define MWM_INPUT_FULL_APPLICATION_MODAL 3
#define MWM_INPUT_APPLICATION_MODAL MWM_INPUT_PRIMARY_APPLICATION_MODAL

#define MWM_TEAROFF_WINDOW	(1L<<0)

/* These all return the memory from Xlib, so require an XFree()
 * when they return TRUE. They return TRUE on success.
 */
gboolean meta_prop_get_atom_list     (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      Atom         **atoms_p,
                                      int           *n_atoms_p);
gboolean meta_prop_get_motif_hints   (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      MotifWmHints **hints_p);
gboolean meta_prop_get_cardinal_list (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      gulong       **cardinals_p,
                                      int           *n_cardinals_p);
gboolean meta_prop_get_latin1_string (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      char         **str_p);
gboolean meta_prop_get_utf8_string   (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      char         **str_p);
gboolean meta_prop_get_utf8_list     (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      char        ***str_p,
                                      int           *n_str_p);
gboolean meta_prop_get_window        (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      Window        *window_p);
gboolean meta_prop_get_cardinal      (MetaDisplay   *display,
                                      Window         xwindow,
                                      Atom           xatom,
                                      gulong        *cardinal_p);
gboolean meta_prop_get_cardinal_with_atom_type (MetaDisplay   *display,
                                                Window         xwindow,
                                                Atom           xatom,
                                                Atom           prop_type,
                                                gulong        *cardinal_p);

#endif




