#include "../libmergeant/libmergeant.h"
#include "mg-test-common.h"

#define MAKE_DUMPS 0
#define SHOW_STEPS
/*#undef SHOW_STEPS*/

#define STEP_SEPARATOR "------------------"

gint main (int argc, char **argv) {
	MgConf *conf;
	GError *error = NULL;
	GSList *layouts, *list;

	gtk_init (&argc, &argv);

	g_print ("############################ LOADING ###############################\n"); 
	g_print ("# Loading DATA3.xml                                                #\n");
	g_print ("####################################################################\n"); 

	conf = MG_CONF (mg_conf_new ());
	if (!mg_conf_load_xml_file (conf, "DATA3.xml", &error)) {
		g_print ("Error occurred:\n\t%s\n", error->message);
		g_error_free (error);
		error = NULL;
	}
#ifdef SHOW_STEPS
	else
		g_print ("DATA3.xml file loaded.\n");
#endif

#ifdef debug
	g_print ("############################ LAYOUTS ###############################\n"); 
	g_print ("# Dumps of layouts                                                 #\n");
	g_print ("####################################################################\n"); 
	layouts = mg_conf_get_layouts (conf);
	list = layouts;
	while (list) {
		mg_base_dump (MG_BASE (list->data), 0);

		list = g_slist_next (list);
	}
	g_slist_free (layouts);

 	if (MAKE_DUMPS) 
 		mg_conf_dump (conf);
#endif	

	g_print ("############################ SAVING ################################\n"); 
	g_print ("# Saving DATA3_OUT.xml                                             #\n");
	g_print ("####################################################################\n"); 
	if (!mg_conf_save_xml_file (conf, "DATA3_OUT.xml", &error)) {
		g_print ("Error occurred:\n\t%s\n", error->message);
		g_error_free (error);
		error = NULL;
	}
	else {
		gboolean cmp;
		gint status;
#ifdef SHOW_STEPS
		g_print ("File written to DATA3_OUT.xml.\n");
#endif
		g_print ("Comparing DATA3.xml and DATA3_OUT.xml... ");

		cmp = g_spawn_command_line_sync ("/usr/bin/cmp -s DATA3.xml DATA3_OUT.xml",
						 NULL, NULL, &status, &error);
		if (cmp) {
			if (!status)
				g_print ("Equal => TEST OK\n");
			else
				g_print ("Different => TEST FAILED\n");
		}
		else {
			g_print ("Error occurred:\n\t%s\n", error->message);
			g_error_free (error);
		}
	}

	g_object_unref (G_OBJECT (conf));


	return 0;
}
