'''
Defines L{Task}s that execute in response to L{AEEvent}s. Exposes L{Task} 
classes that L{Perk} developers can derive from to create their own L{Task}s.
Also exposes the various L{Task.Tools} utility classes and exceptions that they
raise.

@author: Peter Parente
@author: Pete Brunet
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''

import Constants
from Tools.Error import *
from Base import Task
from ChooserTask import ChooserTask
from FocusTask import FocusTask
from ViewTask import ViewTask
from CaretTask import CaretTask
from SelectorTask import SelectorTask
from CyclicInputTask import CyclicInputTask
from InputTask import InputTask
from PropertyTask import PropertyTask
from StateTask import StateTask
from ChildrenTask import ChildrenTask
from TableTask import TableTask
from TimerTask import TimerTask
from ScreenTask import ScreenTask
from MouseTask import MouseTask
from SettingTask import SettingTask

# import constants from AEEvent indicating the layer for the event
from Constants import LAYER_FOCUS, LAYER_TIER, LAYER_BACKGROUND

def getDefaults():
  '''
  Suggests the default L{Task}s to be monitored. Reads the 
  
  @return: Names of defaults to monitor
  @rtype: list of string
  '''
  return Constants.default_types  
  
def getNames():
  '''
  Gets the names of all the L{Task} types.
  
  @return: List of all L{Task} names
  @rtype: list of string
  '''
  names = Constants.all_types
  names.sort()
  return names