'''
Defines a function that allows L{AEEvent} classes to register their names to
suggest all possible event names and defaults to buffer to an
L{AEMonitor}s. Also defines priority constants that determine when
L{AEEvent}s execute.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
# layer constants, with guaranteed order from most specific to least specific
LAYER_FOCUS = 0
LAYER_TIER = 1
LAYER_BACKGROUND = 2
LAYERS_ALL = [LAYER_FOCUS, LAYER_TIER, LAYER_BACKGROUND]
LAYER_NAMES = ['focus', 'tier', 'background']

# priority constants
NORMAL = 0
HIGH = 1
IMMEDIATE = 2

# recommendation for which tasks should be displayed by default by EventMonitor
default_types = []
# all registered Task types; used to build display menu in EventMonitor
all_types = []

def registerEventType(name, default):
  '''
  Called once by every L{AEEvent} class to register itself for buffering and 
  filtering by an L{AEMonitor}.
  
  @param name: Name of the L{AEEvent}
  @type name: string
  @param default: Should this L{AEEvent} be buffered by default?
  @type default: boolean
  '''
  global default_types
  global all_types
  all_types.append(name)
  if default:
    default_types.append(name)
