'''
Defines corrections for the metacity desktop and app switcher.

Event announcements

on cycle windows: [name of window]
on cycle desktops: [name of desktop]

@author: Brett Clippingdale
@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Perk, Task
import LSRConstants

__uie__ = dict(kind='perk', tier='metacity')

class MetacityPerk(Perk.Perk):
  '''
  Announce information in the metacity desktop and application switcher 
  windows. Supplements the DefaultPerk.
  '''
  def init(self):
    '''   
    Registers to receive property change events from the little status bar
    containing the name of the currently selected window in the application or 
    workspace switcher.
    '''
    # register event handlers
    self.registerEventTask(HandlePropertyChange(self), tier=True)

class HandlePropertyChange(Task.PropertyTask):
  '''  
  Announces Alt-Tab application switching by reading the accessible name of
  the status text when it changes.
  '''  
  def execute(self, por, name, value, **kwargs):
    # get the text in status bar
    text = self.getItemText(por)
    # pretend we're on the focus layer even though text is changing elsewhere
    self.stopNow(layer=Task.LAYER_FOCUS)
    self.say(text=text, sem=LSRConstants.SEM_WINDOW, layer=Task.LAYER_FOCUS)
    return True

