'''
Defines global constants.

@var MODE_FOCUS: Requests will be relative to the OS focus
@type MODE_FOCUS: integer
@var MODE_POINTER: Requests will be relative to the LSR focus
@type MODE_POINTER: integer
@var MODE_EVENT: Requests will be relative to the last event L{POR}
@type MODE_EVENT: integer
@var FORMAT_TEXT: Characters of a L{Task.Tools.Word} will be output without 
  additional spelling
@type FORMAT_TEXT: integer
@var FORMAT_PRONOUNCE: Punctuation characters will be spelled using the default 
  spelling table
@type FORMAT_PRONOUNCE: integer
@var FORMAT_SPELL: All characters in a L{Task.Tools.Word} will be spelled
@type FORMAT_SPELL: integer
@var FORMAT_PHONETIC: All characters in a L{Task.Tools.Word} will be spelled 
  using a phonetic spelling table
@type FORMAT_PHONETIC: integer
@var WORD_NON_BLANK: Definition indicating all non-blank characters should be 
  considered the main part of a word
@type WORD_NON_BLANK: integer
@var WORD_ALPHABETIC: Definition indicating all letters should be considered the
  main part of a word
@type WORD_ALPHABETIC: integer
@var WORD_ALPHA_NUMERIC: Definition indicating all letters and numbers should be
  considered the main part of a word
@type WORD_ALPHA_NUMERIC: integer
@var WORD_ALPHA_PUNCT: Definition indicating all letters and punctuation should
  be considered the main part of a word
@type WORD_ALPHA_PUNCT: integer
@var WORD_ALPHA_NUMERIC_PUNCT: Definition indicating all letters, numbers, and
  punctuation should be considered the main part of a word
@type WORD_ALPHA_NUMERIC_PUNCT: integer
@var COLOR_MAP: Mapping from a six bit palette of colors to names describing
  them
@type COLOR_MAP: dictionary

@author: Pete Brunet
@author: Peter Parente
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import os
from i18n import *

# LSR version numbers
LSR_VERSION = '0.2.1'
LSR_DATE = '2006/06/09'

# name, version, copyright and license notice to print on startup
NAME = 'Linux Screen Reader %s %s' % (LSR_VERSION, LSR_DATE)
COPYRIGHT = 'Copyright (c) 2006 IBM Corporation'
LICENSE = 'All rights reserved. This program and the accompanying ' \
        'materials are made available under the terms of the Common Public ' \
        'License v1.0 which accompanies this distribution, and is available ' \
        'at http://www.opensource.org/licenses/cpl1.0.php'

# LSR home directories
HOME_USER = os.path.join(os.environ['HOME'], '.lsr')
HOME_LSR = os.path.dirname(__file__)

# LSR templates directory
TEMPLATES = os.path.join(HOME_LSR, 'Templates')

# command line help strings
HELP_KILL = _('kill a running instance of LSR')
HELP_GENERATE = _('generate a template for a new UIE with the given name and '\
                  'kind in the current working directory and register it with '\
                  'the developer profile')
HELP_EXPERT_GENERATE=_('generate a template for a new UIE with fine grained '\
                       'control over --path and --profile')
HELP_INSTALL = _('install a UIE')
HELP_UNINSTALL = _('uninstall a UIE')
HELP_ASSOCIATE = _('associate a UIE with a profile')
HELP_DISASSOCIATE = _('disassociate a UIE from a profile')
HELP_CREATE_PROFILE = _('create a new user profile')
HELP_REMOVE_PROFLE = _('remove a user profile')
HELP_SHOW = _('show installed perks, profiles, and associated UIEs')
HELP_PROFILE = _('name of the profile (required for --create-profile, ' \
                 '--remove-profile, --associate, --disassociate; ' \
                 'optional when running LSR or using --say')
HELP_SAY = _('output a string using the default device in the given ' \
             'profile (defaults to user)')
HELP_NAME = _('name of the UIE (required for --generate, --install, '\
              '--associate, --uninstall, --disassociate')
HELP_KIND = _('kind of UIE: [%s] (required for --generate, --install,'\
              '--uninstall, --associate, --disassociate')
HELP_PATH = _('path to the UIE (required for --install)')
HELP_INDEX = _('load order index for the UIE (optional for --generate,'\
               ' --associate)')
HELP_TIER = _('process name with which a particular Perk should be associated '\
              '(optional for --perk)')
HELP_LOG_LEVEL = _('level of log messages: %s')
HELP_LOG_CHANNEL = _('channel of log messages, any of: %s')
HELP_LOG_FILENAME = _('filename for the log, defaults to stderr')

# constants for POR mode (focus/pointer/event)
MODE_FOCUS = 0
MODE_POINTER = 1
MODE_EVENT = 2

# constants for State.Format
FORMAT_TEXT = 0
FORMAT_PRONOUNCE = 1
FORMAT_SPELL = 2
FORMAT_PHONETIC = 3

# constants for State.WordDef
WORD_NON_BLANK = 0
WORD_ALPHABETIC = 1
WORD_ALPHA_NUMERIC = 2
WORD_ALPHA_PUNCT = 3
WORD_ALPHA_NUMERIC_PUNCT = 4

# constants for icons, markers, and null
CHAR_NULL = 0
CHAR_ICON = 1
CHAR_VALUE_CHANGER = 2
CHAR_TABLE_CELL = 3
CHAR_PROXY = 4

COLOR_MAP = { 0:_('black'), 1:_('dark purple'), 2:_('dark blue'), 3:_('blue'), 
              4:_('dark green'), 5:_('dark cyan'), 6:_('aqua'), 
              7:_('medium blue'), 8:_('dark green'), 9:_('lime green'), 
              10:_('dark cyan'), 11:_('aqua'), 12:_('green'), 
              13:_('bright green'), 14:_('blue green'), 15:_('cyan'),
              16:_('dark red'), 17:_('magenta'), 18:_('purple'), 19:_('purple'), 
              20:_('olive green'), 21:_('medium grey'), 22:_('steel blue'),
              23:_('blue grey'), 24:_('green'), 25:_('pale green'), 
              26:_('blue grey'), 27:_('light blue'), 28:_('light green'), 
              29:_('light green'), 30:_('cyan'), 31:_('light blue'), 
              32:_('dark red'), 33:_('magenta'), 34:_('dark pink'),
              35:_('purple'), 36:_('light brown'), 37:_('flesh'), 38:_('pink'), 
              39:_('light purple'), 40:_('olive green'), 41:_('light grey'),
              42:_('dark grey'), 43:_('light blue'), 44:_('light green'), 
              45:_('pale green'), 46:_('pale green'), 47:_('light blue'), 
              48:_('red'), 49:_('pink'), 50:_('pink'), 51:_('pink'), 
              52:_('orange'), 53:_('peuce'), 54:_('pink'), 55:_('pink'), 
              56:_('dark yellow'), 57:_('tan'), 58:_('light pink'), 
              59:_('light pink'), 60:_('yellow'), 61:_('pale yellow'), 
              62:_('off white'), 63:_('white') }

#def getColorMap(self):
  #'''
  #Can be used to read/parse an arbitrary tab-delimited color map file, such as
  #the one included in most linux distros (incl FC/RHEL): /usr/share/X11/rgb.txt
  #'''
  #colors = {}
  ##try:
  #filename = "data/larry_colors.txt"
  #try:
    ## open file
    #file = open(filename, "r")
    ## read, parse, and create color map
    #for line in file:
      #key, val = line.split('\t')
      #colors[key] = val.strip()
  #except IOError, io_err:
    #print "I/O error:", io_err
  #except Exception, err:
    #print "Unexpected error:", err
  #file.close()
  #return colors
  
# default number of distinct styles to request from an output device
# should realistically reflect the number of default styles are listed below 
DEFAULT_NUM_STYLES = 4

# default styles
STYLES_CONTENT = 0
STYLES_PROPERTIES = 1
STYLES_ECHO = 2
STYLES_CONTEXT = 3

# enumeration of all default semantics
# CONTENT 10-29
SEM_CHAR = 1
SEM_WORD = 2
SEM_ITEM = 3
SEM_HARDLINE = 4
SEM_NAME = 5
SEM_LABEL = 6
# PROPERTIES 30-59
SEM_ROLE = 30
SEM_FONT = 31
SEM_TEXT_ATTR = 32
SEM_COLOR = 33
SEM_STATE = 34
SEM_LENGTH = 35
SEM_INDEX = 36
SEM_LEVEL = 37
SEM_STATE = 38
SEM_STATUS = 39
# ECHO 60-79
SEM_INFO = 60
SEM_ERROR = 61
# CONTEXT 80-99
SEM_APP = 80
SEM_WINDOW = 81
SEM_TITLE = 82
SEM_GROUP = 83

# mapping of semantics to styles
SEMANTIC_STYLES = {
  # CONTENT
  SEM_CHAR :      STYLES_CONTENT,
  SEM_WORD :      STYLES_CONTENT,
  SEM_ITEM :      STYLES_CONTENT,
  SEM_HARDLINE :  STYLES_CONTENT,
  SEM_LABEL :     STYLES_CONTENT,
  # PROPERTIES
  SEM_ROLE :      STYLES_PROPERTIES,
  SEM_FONT :      STYLES_PROPERTIES,
  SEM_TEXT_ATTR : STYLES_PROPERTIES,
  SEM_COLOR :     STYLES_PROPERTIES,
  SEM_STATE :     STYLES_PROPERTIES,
  SEM_LENGTH :    STYLES_PROPERTIES,
  SEM_INDEX :     STYLES_PROPERTIES,
  SEM_LEVEL :     STYLES_PROPERTIES,
  SEM_STATE :     STYLES_PROPERTIES,
  SEM_STATUS :    STYLES_PROPERTIES,
  # CONTEXT
  SEM_APP :       STYLES_CONTEXT,
  SEM_WINDOW :    STYLES_CONTEXT,
  SEM_TITLE :     STYLES_CONTEXT,
  SEM_GROUP :     STYLES_CONTEXT,
  # ECHO
  SEM_INFO :      STYLES_ECHO,
  SEM_ERROR :     STYLES_ECHO
}
