'''
Defines the abstract base class for all L{AEMonitor} subclasses.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

class AEMonitor(object):
  '''  
  Most abstract base class for all L{AEMonitor} displays.
  
  This class is abstract as most of its methods raise NotImplementedError and 
  need to be overriden in subclasses.
  
  @ivar is_init: Is the monitor initialized via the L{init} method?
  @type is_init: boolean
  '''
  def __init__(self):
    '''
    Sets the L{is_init} flag to False.
    '''
    self.is_init = False
  
  def isInitialized(self):
    '''
    Gets if the monitor is initialized or not.
    
    @return: Is the dialog initialized?
    @rtype: boolean
    '''
    return self.is_init
  
  def init(self):
    '''
    Sets the L{is_init} flag to True. Subclasses should override this method
    to create and show their monitor's UI.
    '''
    self.is_init = True
    
  def close(self):
    '''
    Sets the L{is_init} flag to False. Subclasses should override this method 
    to hide and destroy their monitor's UI.
    '''
    self.is_init = False
  
  def getName(self):
    '''
    Abstract method. Gets the localized name of this L{AEMonitor}.
    
    @return: Name of the monitor
    @rtype: string
    @raise NotImplementedError: When this method is not overidden in a subclass
    '''
    raise NotImplementedError