'''
Defines a function that allows L{AEEvent} classes to register their names to
suggest all possible event names and defaults to buffer to an
L{AEMonitor.EventMonitor}s. Also defines priority constants that determine when
L{AEEvent}s execute.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
# layer constants, with guaranteed order from most specific to least specific
# @todo: PP: these should really be LAYER_* to follow other constant names
FOCUS_LAYER = 0
TIER_LAYER = 1
BACKGROUND_LAYER = 2
ALL_LAYERS = [FOCUS_LAYER, TIER_LAYER, BACKGROUND_LAYER]

# priority constants
NORMAL = 0
HIGH = 1
IMMEDIATE = 2

# recommendation for which tasks should be displayed by default by EventMonitor
default_types = []
# all registered Task types; used to build display menu in EventMonitor
all_types = []

def registerEventType(name, default):
  '''
  Called once by every L{AEEvent} class to register itself for buffering and 
  filtering by an L{AEMonitor.EventMonitor}.
  
  @param name: Name of the L{AEEvent}
  @type name: string
  @param default: Should this L{AEEvent} be buffered by default?
  @type default: boolean
  '''
  global default_types
  global all_types
  all_types.append(name)
  if default:
    default_types.append(name)
