'''
Defines a L{Task} to execute when the state of an accesible or item changes.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import Base, Constants
import AEEvent

class StateTask(Base.Task):
  '''
  Executed when the state of an accesible or item changes.

  This class registers its name and whether it should be monitored by default in
  an L{AEMonitor.EventMonitor} using the L{Constants.registerTaskType} function
  when this module is first imported. The L{AEMonitor.EventMonitor} can use this
  information to build its menus.
  '''
  Constants.registerTaskType('StateTask', False)

  def getType(self):
    '''
    @return: Type of L{AEEvent} this L{Task} wants to handle
    @rtype: class
    '''
    return AEEvent.StateChange
  
  def update(self, por, name, value, layer, **kwargs):
    '''
    Updates this L{Task} in response to a consumed state change event. Called by 
    L{Tier.Tier._executeTask}.
    
    @param por: Point of regard for the related accessible/item
    @type por: L{POR}
    @param name: Name of the state that changed
    @type name: string
    @param value: True if the state is now set, False if not
    @type value: boolean
    @param layer: Layer on which the event occurred, one of L{Task.FOCUS_LAYER},
      L{Task.TIER_LAYER}, or L{Task.BACKGROUND_LAYER}
    @type layer: integer
    '''
    pass
  
  def execute(self, por, name, value, layer, **kwargs):
    '''
    Executes this L{Task} in response to a state change event. Called by 
    L{Tier.Tier._executeTask}.
    
    @param por: Point of regard for the related accessible/item
    @type por: L{POR}
    @param name: Name of the state that changed
    @type name: string
    @param value: True if the state is now set, False if not
    @type value: boolean
    @param layer: Layer on which the event occurred, one of L{Task.FOCUS_LAYER},
      L{Task.TIER_LAYER}, or L{Task.BACKGROUND_LAYER}
    @type layer: integer
    @return: True to allow other L{Task}s to process this event
    @rtype: boolean
    '''
    return True