/*
 * globals.c: definition and handling of the set of global variables
 *            of the library
 *
 * The bottom of this file is automatically generated by build_glob.py
 * based on the description file global.data
 *
 * See Copyright for the status of this software.
 *
 * Gary Pennington <Gary.Pennington@uk.sun.com>
 * daniel@veillard.com
 */

#include "libxml.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <string.h>

#include <libxml/globals.h>
#include <libxml/xmlmemory.h>

/* #define DEBUG_GLOBALS */

/*
 * Helpful Macro
 */
#ifdef LIBXML_THREAD_ENABLED
#define IS_MAIN_THREAD (xmlIsMainThread())
#else
#define IS_MAIN_THREAD 1
#endif

/************************************************************************
 * 									*
 *	All the user accessible global variables of the library		*
 * 									*
 ************************************************************************/

/*
 * Memory allocation routines
 */
#if defined(DEBUG_MEMORY_LOCATION) | defined(DEBUG_MEMORY)
extern void xmlMemFree(void *ptr);
extern void * xmlMemMalloc(size_t size);
extern void * xmlMemRealloc(void *ptr,size_t size);
extern char * xmlMemoryStrdup(const char *str);

xmlFreeFunc xmlFree = (xmlFreeFunc) xmlMemFree;
xmlMallocFunc xmlMalloc = (xmlMallocFunc) xmlMemMalloc;
xmlReallocFunc xmlRealloc = (xmlReallocFunc) xmlMemRealloc;
xmlStrdupFunc xmlMemStrdup = (xmlStrdupFunc) xmlMemoryStrdup;
#else
xmlFreeFunc xmlFree = (xmlFreeFunc) free;
xmlMallocFunc xmlMalloc = (xmlMallocFunc) malloc;
xmlReallocFunc xmlRealloc = (xmlReallocFunc) realloc;
xmlStrdupFunc xmlMemStrdup = (xmlStrdupFunc) strdup;
#endif

#include <libxml/threads.h>
#include <libxml/globals.h>
#include <libxml/SAX.h>

#undef	docbDefaultSAXHandler
#undef	htmlDefaultSAXHandler
#undef	oldXMLWDcompatibility
#undef	xmlBufferAllocScheme
#undef	xmlDefaultBufferSize
#undef	xmlDefaultSAXHandler
#undef	xmlDefaultSAXLocator
#undef	xmlDoValidityCheckingDefaultValue
#undef	xmlGenericError
#undef	xmlGenericErrorContext
#undef	xmlGetWarningsDefaultValue
#undef	xmlIndentTreeOutput
#undef	xmlKeepBlanksDefaultValue
#undef	xmlLineNumbersDefaultValue
#undef	xmlLoadExtDtdDefaultValue
#undef	xmlParserDebugEntities
#undef	xmlParserVersion
#undef	xmlPedanticParserDefaultValue
#undef	xmlSaveNoEmptyTags
#undef	xmlSubstituteEntitiesDefaultValue

#undef	xmlFree
#undef	xmlMalloc
#undef	xmlMemStrdup
#undef	xmlRealloc

const char *xmlParserVersion = LIBXML_VERSION_STRING;

/*
 * Buffers stuff
 */
xmlBufferAllocationScheme xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;
int xmlDefaultBufferSize = BASE_BUFFER_SIZE;

/*
 * Parser defaults
 */

int oldXMLWDcompatibility = 0; /* DEPRECATED */
int xmlParserDebugEntities = 0;
int xmlDoValidityCheckingDefaultValue = 0;
int xmlGetWarningsDefaultValue = 1;
int xmlLoadExtDtdDefaultValue = 0;
int xmlPedanticParserDefaultValue = 0;
int xmlLineNumbersDefaultValue = 0;
int xmlKeepBlanksDefaultValue = 1;
int xmlSubstituteEntitiesDefaultValue = 0;

/*
 * Error handling
 */

/* xmlGenericErrorFunc xmlGenericError = xmlGenericErrorDefaultFunc; */
/* Must initialize xmlGenericError in xmlInitParser */
void xmlGenericErrorDefaultFunc	(void *ctx ATTRIBUTE_UNUSED,
				 const char *msg,
				 ...);
xmlGenericErrorFunc xmlGenericError = xmlGenericErrorDefaultFunc;
void *xmlGenericErrorContext = NULL;

/*
 * output defaults
 */
int xmlIndentTreeOutput = 0;
int xmlSaveNoEmptyTags = 0;

/*
 * Default handler for XML, builds the DOM tree
 */
xmlSAXHandler xmlDefaultSAXHandler = {
    internalSubset,
    isStandalone,
    hasInternalSubset,
    hasExternalSubset,
    resolveEntity,
    getEntity,
    entityDecl,
    notationDecl,
    attributeDecl,
    elementDecl,
    unparsedEntityDecl,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    reference,
    characters,
    characters,
    processingInstruction,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    cdataBlock,
    externalSubset,
    0
};

/*
 * The default SAX Locator.
 */

xmlSAXLocator xmlDefaultSAXLocator = {
    getPublicId, getSystemId, getLineNumber, getColumnNumber
};

#ifdef LIBXML_HTML_ENABLED
/*
 * Default handler for HTML, builds the DOM tree
 */
xmlSAXHandler htmlDefaultSAXHandler = {
    internalSubset,
    NULL,
    NULL,
    NULL,
    NULL,
    getEntity,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    NULL,
    characters,
    ignorableWhitespace,
    NULL,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    cdataBlock,
    NULL,
    0
};
#endif /* LIBXML_HTML_ENABLED */

#ifdef LIBXML_DOCB_ENABLED
/*
 * Default handler for SGML DocBook, builds the DOM tree
 */
xmlSAXHandler docbDefaultSAXHandler = {
    internalSubset,
    isStandalone,
    hasInternalSubset,
    hasExternalSubset,
    resolveEntity,
    getEntity,
    entityDecl,
    NULL,
    NULL,
    NULL,
    NULL,
    setDocumentLocator,
    startDocument,
    endDocument,
    startElement,
    endElement,
    reference,
    characters,
    ignorableWhitespace,
    NULL,
    comment,
    xmlParserWarning,
    xmlParserError,
    xmlParserError,
    getParameterEntity,
    NULL,
    NULL,
    0
};
#endif /* LIBXML_DOCB_ENABLED */

/**
 * xmlInitializeGlobalState:
 * @gs: a pointer to a newly allocated global state
 *
 * xmlInitializeGlobalState() initialize a global state with all the
 * default values of the library.
 */
void
xmlInitializeGlobalState(xmlGlobalStatePtr gs)
{
#ifdef DEBUG_GLOBALS
    fprintf(stderr, "Initializing globals at %lu for thread %d\n",
	    (unsigned long) gs, xmlGetThreadId());
#endif

    /*
     * Perform initialisation as required by libxml
     */
    initxmlDefaultSAXHandler(&gs->xmlDefaultSAXHandler, 1);
#ifdef LIBXML_DOCB_ENABLED
    initdocbDefaultSAXHandler(&gs->docbDefaultSAXHandler);
#endif
#ifdef LIBXML_HTML_ENABLED
    inithtmlDefaultSAXHandler(&gs->htmlDefaultSAXHandler);
#endif
    initGenericErrorDefaultFunc(&gs->xmlGenericError);

    gs->oldXMLWDcompatibility = 0;
    gs->xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;
    gs->xmlDefaultBufferSize = BASE_BUFFER_SIZE;
    initxmlDefaultSAXHandler(&gs->xmlDefaultSAXHandler, 1);
    gs->xmlDefaultSAXLocator.getPublicId = getPublicId;
    gs->xmlDefaultSAXLocator.getSystemId = getSystemId;
    gs->xmlDefaultSAXLocator.getLineNumber = getLineNumber;
    gs->xmlDefaultSAXLocator.getColumnNumber = getColumnNumber;
    gs->xmlDoValidityCheckingDefaultValue = 0;
#if defined(DEBUG_MEMORY_LOCATION) | defined(DEBUG_MEMORY)
    gs->xmlFree = (xmlFreeFunc) xmlMemFree;
    gs->xmlMalloc = (xmlMallocFunc) xmlMemMalloc;
    gs->xmlRealloc = (xmlReallocFunc) xmlMemRealloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) xmlMemoryStrdup;
#else
    gs->xmlFree = (xmlFreeFunc) free;
    gs->xmlMalloc = (xmlMallocFunc) malloc;
    gs->xmlRealloc = (xmlReallocFunc) realloc;
    gs->xmlMemStrdup = (xmlStrdupFunc) strdup;
#endif
    gs->xmlGenericErrorContext = NULL;
    gs->xmlGetWarningsDefaultValue = 1;
    gs->xmlIndentTreeOutput = 0;
    gs->xmlKeepBlanksDefaultValue = 1;
    gs->xmlLineNumbersDefaultValue = 0;
    gs->xmlLoadExtDtdDefaultValue = 0;
    gs->xmlParserDebugEntities = 0;
    gs->xmlParserVersion = LIBXML_VERSION_STRING;
    gs->xmlPedanticParserDefaultValue = 0;
    gs->xmlSaveNoEmptyTags = 0;
    gs->xmlSubstituteEntitiesDefaultValue = 0;
}

#ifdef LIBXML_DOCB_ENABLED
extern xmlSAXHandler docbDefaultSAXHandler;
#undef	docbDefaultSAXHandler
xmlSAXHandler *
__docbDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&docbDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->docbDefaultSAXHandler);
}
#endif

#ifdef LIBXML_HTML_ENABLED
extern xmlSAXHandler htmlDefaultSAXHandler;
#undef	htmlDefaultSAXHandler
xmlSAXHandler *
__htmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&htmlDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->htmlDefaultSAXHandler);
}
#endif

/*
 * Everything starting from the line below is
 * Automatically generated by build_glob.py.
 * Do not modify the previous line.
 */


extern int oldXMLWDcompatibility;
#undef	oldXMLWDcompatibility
int *
__oldXMLWDcompatibility(void) {
    if (IS_MAIN_THREAD)
	return (&oldXMLWDcompatibility);
    else
	return (&xmlGetGlobalState()->oldXMLWDcompatibility);
}

extern xmlBufferAllocationScheme xmlBufferAllocScheme;
#undef	xmlBufferAllocScheme
xmlBufferAllocationScheme *
__xmlBufferAllocScheme(void) {
    if (IS_MAIN_THREAD)
	return (&xmlBufferAllocScheme);
    else
	return (&xmlGetGlobalState()->xmlBufferAllocScheme);
}

extern int xmlDefaultBufferSize;
#undef	xmlDefaultBufferSize
int *
__xmlDefaultBufferSize(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultBufferSize);
    else
	return (&xmlGetGlobalState()->xmlDefaultBufferSize);
}

extern xmlSAXHandler xmlDefaultSAXHandler;
#undef	xmlDefaultSAXHandler
xmlSAXHandler *
__xmlDefaultSAXHandler(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultSAXHandler);
    else
	return (&xmlGetGlobalState()->xmlDefaultSAXHandler);
}

extern xmlSAXLocator xmlDefaultSAXLocator;
#undef	xmlDefaultSAXLocator
xmlSAXLocator *
__xmlDefaultSAXLocator(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDefaultSAXLocator);
    else
	return (&xmlGetGlobalState()->xmlDefaultSAXLocator);
}

extern int xmlDoValidityCheckingDefaultValue;
#undef	xmlDoValidityCheckingDefaultValue
int *
__xmlDoValidityCheckingDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlDoValidityCheckingDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlDoValidityCheckingDefaultValue);
}

extern xmlFreeFunc xmlFree;
#undef	xmlFree
xmlFreeFunc *
__xmlFree(void) {
    if (IS_MAIN_THREAD)
	return (&xmlFree);
    else
	return (&xmlGetGlobalState()->xmlFree);
}

extern xmlGenericErrorFunc xmlGenericError;
#undef	xmlGenericError
xmlGenericErrorFunc *
__xmlGenericError(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGenericError);
    else
	return (&xmlGetGlobalState()->xmlGenericError);
}

extern void * xmlGenericErrorContext;
#undef	xmlGenericErrorContext
void * *
__xmlGenericErrorContext(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGenericErrorContext);
    else
	return (&xmlGetGlobalState()->xmlGenericErrorContext);
}

extern int xmlGetWarningsDefaultValue;
#undef	xmlGetWarningsDefaultValue
int *
__xmlGetWarningsDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlGetWarningsDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlGetWarningsDefaultValue);
}

extern int xmlIndentTreeOutput;
#undef	xmlIndentTreeOutput
int *
__xmlIndentTreeOutput(void) {
    if (IS_MAIN_THREAD)
	return (&xmlIndentTreeOutput);
    else
	return (&xmlGetGlobalState()->xmlIndentTreeOutput);
}

extern int xmlKeepBlanksDefaultValue;
#undef	xmlKeepBlanksDefaultValue
int *
__xmlKeepBlanksDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlKeepBlanksDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlKeepBlanksDefaultValue);
}

extern int xmlLineNumbersDefaultValue;
#undef	xmlLineNumbersDefaultValue
int *
__xmlLineNumbersDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlLineNumbersDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlLineNumbersDefaultValue);
}

extern int xmlLoadExtDtdDefaultValue;
#undef	xmlLoadExtDtdDefaultValue
int *
__xmlLoadExtDtdDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlLoadExtDtdDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlLoadExtDtdDefaultValue);
}

extern xmlMallocFunc xmlMalloc;
#undef	xmlMalloc
xmlMallocFunc *
__xmlMalloc(void) {
    if (IS_MAIN_THREAD)
	return (&xmlMalloc);
    else
	return (&xmlGetGlobalState()->xmlMalloc);
}

extern xmlStrdupFunc xmlMemStrdup;
#undef	xmlMemStrdup
xmlStrdupFunc *
__xmlMemStrdup(void) {
    if (IS_MAIN_THREAD)
	return (&xmlMemStrdup);
    else
	return (&xmlGetGlobalState()->xmlMemStrdup);
}

extern int xmlParserDebugEntities;
#undef	xmlParserDebugEntities
int *
__xmlParserDebugEntities(void) {
    if (IS_MAIN_THREAD)
	return (&xmlParserDebugEntities);
    else
	return (&xmlGetGlobalState()->xmlParserDebugEntities);
}

extern const char * xmlParserVersion;
#undef	xmlParserVersion
const char * *
__xmlParserVersion(void) {
    if (IS_MAIN_THREAD)
	return (&xmlParserVersion);
    else
	return (&xmlGetGlobalState()->xmlParserVersion);
}

extern int xmlPedanticParserDefaultValue;
#undef	xmlPedanticParserDefaultValue
int *
__xmlPedanticParserDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlPedanticParserDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlPedanticParserDefaultValue);
}

extern xmlReallocFunc xmlRealloc;
#undef	xmlRealloc
xmlReallocFunc *
__xmlRealloc(void) {
    if (IS_MAIN_THREAD)
	return (&xmlRealloc);
    else
	return (&xmlGetGlobalState()->xmlRealloc);
}

extern int xmlSaveNoEmptyTags;
#undef	xmlSaveNoEmptyTags
int *
__xmlSaveNoEmptyTags(void) {
    if (IS_MAIN_THREAD)
	return (&xmlSaveNoEmptyTags);
    else
	return (&xmlGetGlobalState()->xmlSaveNoEmptyTags);
}

extern int xmlSubstituteEntitiesDefaultValue;
#undef	xmlSubstituteEntitiesDefaultValue
int *
__xmlSubstituteEntitiesDefaultValue(void) {
    if (IS_MAIN_THREAD)
	return (&xmlSubstituteEntitiesDefaultValue);
    else
	return (&xmlGetGlobalState()->xmlSubstituteEntitiesDefaultValue);
}
