#include "lastfm-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_lastfm_iface_object_info;

struct _SwLastfmIfaceClass {
    GTypeInterface parent_class;
    sw_lastfm_iface_now_playing_impl now_playing;
    sw_lastfm_iface_submit_track_impl submit_track;
};

static void sw_lastfm_iface_base_init (gpointer klass);

GType
sw_lastfm_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwLastfmIfaceClass),
        sw_lastfm_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwLastfmIface", &info, 0);
    }

  return type;
}

/**
 * sw_lastfm_iface_now_playing_impl:
 * @self: The object implementing this interface
 * @in_artist: const gchar * (FIXME, generate documentation)
 * @in_album: const gchar * (FIXME, generate documentation)
 * @in_track: const gchar * (FIXME, generate documentation)
 * @in_length: guint  (FIXME, generate documentation)
 * @in_tracknumber: guint  (FIXME, generate documentation)
 * @in_musicbrainz: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * NowPlaying on interface com.meego.libsocialweb.Service.Lastfm.
 */
static void
sw_lastfm_iface_now_playing (SwLastfmIface *self,
    const gchar *in_artist,
    const gchar *in_album,
    const gchar *in_track,
    guint in_length,
    guint in_tracknumber,
    const gchar *in_musicbrainz,
    DBusGMethodInvocation *context)
{
  sw_lastfm_iface_now_playing_impl impl = (SW_LASTFM_IFACE_GET_CLASS (self)->now_playing);

  if (impl != NULL)
    {
      (impl) (self,
        in_artist,
        in_album,
        in_track,
        in_length,
        in_tracknumber,
        in_musicbrainz,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_lastfm_iface_implement_now_playing:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the NowPlaying D-Bus method
 *
 * Register an implementation for the NowPlaying method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_lastfm_iface_implement_now_playing (SwLastfmIfaceClass *klass, sw_lastfm_iface_now_playing_impl impl)
{
  klass->now_playing = impl;
}

/**
 * sw_lastfm_iface_submit_track_impl:
 * @self: The object implementing this interface
 * @in_artist: const gchar * (FIXME, generate documentation)
 * @in_album: const gchar * (FIXME, generate documentation)
 * @in_track: const gchar * (FIXME, generate documentation)
 * @in_time: gint64  (FIXME, generate documentation)
 * @in_source: const gchar * (FIXME, generate documentation)
 * @in_rating: const gchar * (FIXME, generate documentation)
 * @in_length: guint  (FIXME, generate documentation)
 * @in_tracknumber: guint  (FIXME, generate documentation)
 * @in_musicbrainz: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SubmitTrack on interface com.meego.libsocialweb.Service.Lastfm.
 */
static void
sw_lastfm_iface_submit_track (SwLastfmIface *self,
    const gchar *in_artist,
    const gchar *in_album,
    const gchar *in_track,
    gint64 in_time,
    const gchar *in_source,
    const gchar *in_rating,
    guint in_length,
    guint in_tracknumber,
    const gchar *in_musicbrainz,
    DBusGMethodInvocation *context)
{
  sw_lastfm_iface_submit_track_impl impl = (SW_LASTFM_IFACE_GET_CLASS (self)->submit_track);

  if (impl != NULL)
    {
      (impl) (self,
        in_artist,
        in_album,
        in_track,
        in_time,
        in_source,
        in_rating,
        in_length,
        in_tracknumber,
        in_musicbrainz,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_lastfm_iface_implement_submit_track:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SubmitTrack D-Bus method
 *
 * Register an implementation for the SubmitTrack method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_lastfm_iface_implement_submit_track (SwLastfmIfaceClass *klass, sw_lastfm_iface_submit_track_impl impl)
{
  klass->submit_track = impl;
}

static inline void
sw_lastfm_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_lastfm_iface_get_type (),
      &_sw_lastfm_iface_object_info);

}
static void
sw_lastfm_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_lastfm_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_lastfm_iface_methods[] = {
  { (GCallback) sw_lastfm_iface_now_playing, sw_marshal_VOID__STRING_STRING_STRING_UINT_UINT_STRING_POINTER, 0 },
  { (GCallback) sw_lastfm_iface_submit_track, sw_marshal_VOID__STRING_STRING_STRING_INT64_STRING_STRING_UINT_UINT_STRING_POINTER, 126 },
};

static const DBusGObjectInfo _sw_lastfm_iface_object_info = {
  0,
  _sw_lastfm_iface_methods,
  2,
"com.meego.libsocialweb.Service.Lastfm\0NowPlaying\0A\0artist\0I\0s\0album\0I\0s\0track\0I\0s\0length\0I\0u\0tracknumber\0I\0u\0musicbrainz\0I\0s\0\0com.meego.libsocialweb.Service.Lastfm\0SubmitTrack\0A\0artist\0I\0s\0album\0I\0s\0track\0I\0s\0time\0I\0x\0source\0I\0s\0rating\0I\0s\0length\0I\0u\0tracknumber\0I\0u\0musicbrainz\0I\0s\0\0\0",
"\0\0",
"\0\0",
};


