<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.devhelp.net/book"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>

  <!-- these are parameters so that this stylesheet can be used by multiple
  libraries.  Pass them in on the commandline -->
  <xsl:param name="book_title"/>
  <xsl:param name="book_name"/>
  <xsl:param name="reference_prefix"/>

  <xsl:template match="/">
    <book title="{$book_title}" name="{$book_name}" base="{$reference_prefix}"
          link="index.html" version="2" language="c++">
      <chapters>
        <sub name="Classes" link="classes.html">
          <xsl:apply-templates select="tagfile/compound[@kind='class' or @kind='struct']" mode="sub">
            <xsl:sort lang="en" case-order="upper-first" select="name"/>
          </xsl:apply-templates>
        </sub>
        <sub name="Namespaces" link="namespaces.html">
          <xsl:apply-templates select="tagfile/compound[@kind='namespace']" mode="sub">
            <xsl:sort lang="en" case-order="upper-first" select="name"/>
          </xsl:apply-templates>
        </sub>
      </chapters>
      <functions>
        <xsl:apply-templates select="tagfile/compound|tagfile/compound/member" mode="keyword">
          <xsl:sort lang="en" select="concat(../name, '::', name)"/>
        </xsl:apply-templates>
      </functions>
    </book>
  </xsl:template>

  <xsl:template match="compound" mode="sub">
    <sub name="{name}" link="{filename}"/>
  </xsl:template>

  <xsl:template match="compound[@kind='class' or @kind='struct']" mode="keyword">
    <keyword type="struct" name="{name}" link="{filename}"/>
  </xsl:template>
  <xsl:template match="member[@kind='function' or @kind='typedef' or @kind='variable']" mode="keyword">
    <keyword type="{@kind}" xsl:use-attribute-sets="keyword-member"/>
  </xsl:template>
  <xsl:template match="member[@kind='enumeration']" mode="keyword">
    <keyword type="enum" xsl:use-attribute-sets="keyword-member"/>
  </xsl:template>
  <xsl:template match="member[@kind='enumvalue' or @kind='define']" mode="keyword">
    <keyword type="macro" xsl:use-attribute-sets="keyword-member"/>
  </xsl:template>

  <xsl:template match="*" mode="keyword"/>

  <xsl:attribute-set name="keyword-member">
    <xsl:attribute name="name">
      <xsl:value-of select="concat(../name, '::', name)"/>
    </xsl:attribute>
    <xsl:attribute name="link">
      <xsl:value-of select="concat(anchorfile, '#', anchor)"/>
    </xsl:attribute>
  </xsl:attribute-set>

</xsl:stylesheet>
