## Copyright (c) 2009  Daniel Elstner <daniel.kitta@gmail.com>
##
## This file is part of mm-autofu.
##
## mm-autofu is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation, either version 2 of the License,
## or (at your option) any later version.
##
## mm-autofu is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with mm-autofu.  If not, see <http://www.gnu.org/licenses/>.

#serial 20090711

## _MM_ARG_ENABLE_DOCUMENTATION(variable)
##
m4_define([_MM_ARG_ENABLE_DOCUMENTATION],
[dnl
AC_ARG_VAR([PERL], [path to Perl interpreter])
AC_CHECK_PROG([PERL], [perl], [perl])[]dnl

AC_ARG_VAR([DOT], [path to dot utility])
AC_CHECK_PROG([DOT], [dot], [dot])[]dnl

AC_ARG_VAR([DOXYGEN], [path to Doxygen utility])
AC_CHECK_PROG([DOXYGEN], [doxygen], [doxygen])[]dnl

AC_ARG_VAR([XSLTPROC], [path to xsltproc utility])
AC_CHECK_PROG([XSLTPROC], [xsltproc], [xsltproc])[]dnl

AC_ARG_ENABLE([documentation],
              [AS_HELP_STRING([--disable-documentation],
                              [do not build or install the documentation])],
              [$1=$enableval],
              [$1=yes])[]dnl

AS_IF([test "x[$]$1" != xno],
[dnl
  AS_IF([test "x$PERL" = x],     [mm_missing=Perl],
        [test "x$DOT" = x],      [mm_missing=dot],
        [test "x$DOXYGEN" = x],  [mm_missing=Doxygen],
        [test "x$XSLTPROC" = x], [mm_missing=xsltproc],
        [mm_missing=])
  AS_IF([test -n "$mm_missing"], [AC_MSG_FAILURE([[
*** Documentation is enabled in this configuration, but the
*** required tool $mm_missing could not be found.]])])[]dnl
])
AM_CONDITIONAL([$1], [test "x[$]$1" != xno])[]dnl
])

## MM_ARG_ENABLE_DOCUMENTATION([variable])
##
## Provide the --disable-documentation configure option.  By default,
## the documentation will be included in the build.  If not explicitly
## disabled, also check whether the necessary tools are installed, and
## abort if any are missing.
##
## The tools checked for are Perl, dot, Doxygen and xsltproc.  The
## substitution variables PERL, DOT, DOXYGEN and XSLTPROC are set to
## the command names, unless overridden in the user environment.
##
AC_DEFUN([MM_ARG_ENABLE_DOCUMENTATION],
         [_MM_ARG_ENABLE_DOCUMENTATION(m4_default([$1], [ENABLE_DOCUMENTATION]))])
