#ifndef __GNOME_PRINT_MASTER_H__
#define __GNOME_PRINT_MASTER_H__

/*
 *  Copyright (C) 2000 Ximian Inc.
 *
 *  Authors:
 *    Michael Zucchi <notzed@ximian.com>
 *    Lauris Kaplinski <lauris@ximian.com>
 *
 *  A system print interface.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>

G_BEGIN_DECLS

#define GNOME_TYPE_PRINT_MASTER (gnome_print_master_get_type ())
#define GNOME_PRINT_MASTER(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), GNOME_TYPE_PRINT_MASTER, GnomePrintMaster))
#define GNOME_PRINT_MASTER_CLASS(k) (G_TYPE_CHECK_CLASS_CAST ((k), GNOME_TYPE_PRINT_MASTER, GnomePrintMasterClass))
#define GNOME_IS_PRINT_MASTER(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), GNOME_TYPE_PRINT_MASTER))
#define GNOME_IS_PRINT_MASTER_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), GNOME_TYPE_PRINT_MASTER))
#define GNOME_PRINT_MASTER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GNOME_TYPE_PRINT_MASTER, GnomePrintMasterClass))

typedef struct _GnomePrintMaster      GnomePrintMaster;
typedef struct _GnomePrintMasterClass GnomePrintMasterClass;

#include <libgnomeprint/gnome-print.h>

GType gnome_print_master_get_type (void);

GnomePrintMaster *gnome_print_master_new (void);
GnomePrintMaster *gnome_print_master_new_from_config (GnomePrintConfig *config);

GnomePrintConfig *gnome_print_master_get_config (GnomePrintMaster *gpm);
GnomePrintContext *gnome_print_master_get_context (GnomePrintMaster *gpm);
gint gnome_print_master_get_pages (GnomePrintMaster *gpm);

#if 0
void gnome_print_master_set_paper (GnomePrintMaster *gpm, const GnomePaper *paper);
const GnomePaper * gnome_print_master_get_paper (const GnomePrintMaster *gpm);

void gnome_print_master_set_printer (GnomePrintMaster *gpm,
				     GnomePrinter *printer);
void gnome_print_master_set_copies  (GnomePrintMaster *gpm,
				     int copies, gboolean iscollate);
#endif

gint gnome_print_master_close (GnomePrintMaster *gpm);

gint gnome_print_master_print (GnomePrintMaster *gpm);

G_END_DECLS

#endif /* GNOME_PRINT_MASTER_H */
