/* gnome-db-raw-form.h
 *
 * Copyright (C) 2002 - 2006 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_RAW_FORM__
#define __GNOME_DB_RAW_FORM__

#include <gtk/gtk.h>
#include <libgda/gda-data-model.h>
#include "gnome-db-basic-form.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_RAW_FORM          (gnome_db_raw_form_get_type())
#define GNOME_DB_RAW_FORM(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_raw_form_get_type(), GnomeDbRawForm)
#define GNOME_DB_RAW_FORM_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_raw_form_get_type (), GnomeDbRawFormClass)
#define GNOME_DB_IS_RAW_FORM(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_raw_form_get_type ())


typedef struct _GnomeDbRawForm      GnomeDbRawForm;
typedef struct _GnomeDbRawFormClass GnomeDbRawFormClass;
typedef struct _GnomeDbRawFormPriv  GnomeDbRawFormPriv;

/* struct for the object's data */
struct _GnomeDbRawForm
{
	GnomeDbBasicForm      object;

	GnomeDbRawFormPriv   *priv;
};

/* struct for the object's class */
struct _GnomeDbRawFormClass
{
	GnomeDbBasicFormClass parent_class;
};

/* 
 * Generic widget's methods 
 */
GType        gnome_db_raw_form_get_type              (void);
GtkWidget   *gnome_db_raw_form_new                   (GdaDataModel *model);

G_END_DECLS

#endif



