/* GNOME-DB Components
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtktable.h>
#include <gtk/gtkvpaned.h>
#include <libgnomedb/gnome-db-editor.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-util.h>
#include "sql-viewer.h"

#define PARENT_TYPE GTK_TYPE_VBOX

static void sql_viewer_class_init (SqlViewerClass *klass);
static void sql_viewer_init (SqlViewer *viewer, SqlViewerClass *klass);
static void sql_viewer_finalize (GObject *object);

static GObjectClass *parent_class = NULL;

static void
sql_viewer_class_init (SqlViewerClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = sql_viewer_finalize;
}

static void
sql_viewer_init (SqlViewer *viewer, SqlViewerClass *klass)
{
	GtkWidget *table, *paned;

	/* create widgets */
	table = gnome_db_new_table_widget (2, 1, FALSE);
	gtk_box_pack_start (GTK_BOX (viewer), table, TRUE, TRUE, 6);

	paned = gnome_db_new_vpaned_widget ();
	gtk_table_attach (GTK_TABLE (table), paned, 0, 1, 1, 2,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK, 6, 6);

	/* create SQL editor */
	viewer->sql_editor = gnome_db_editor_new ();
	gtk_widget_show (viewer->sql_editor);
	gtk_paned_add1 (GTK_PANED (paned), viewer->sql_editor);

	/* create the grid */
	viewer->grid = gnome_db_grid_new ();
	gtk_widget_show (viewer->grid);
	gtk_paned_add2 (GTK_PANED (paned), viewer->grid);
}

static void
sql_viewer_finalize (GObject *object)
{
	parent_class->finalize (object);
}

GType
sql_viewer_get_type (void)
{
        static GType type = 0;
                                                                                              
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (SqlViewerClass),
                        (GBaseInitFunc) NULL,
                        (GBaseFinalizeFunc) NULL,
                        (GClassInitFunc) sql_viewer_class_init,
                        NULL,
                        NULL,
                        sizeof (SqlViewer),
                        0,
                        (GInstanceInitFunc) sql_viewer_init
                };
                type = g_type_register_static (PARENT_TYPE, "SqlViewer", &info, 0);
        }
        return type;
}

GtkWidget *
sql_viewer_new (GdaConnection *cnc, const gchar *sql)
{
	SqlViewer *viewer;

	viewer = g_object_new (TYPE_SQL_VIEWER, NULL);

	return GTK_WIDGET (viewer);
}

