/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkdialog.h>
#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>
#include <libgnomedb/gnome-db-config.h>
#include <libgnomedb/gnome-db-dsn-config.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomedb/gnome-db-util.h>
#include <libgnomedb/tables-page.h>
#include <libgnomedb/utils.h>
#include "dsn-properties-dialog.h"

static void
dsn_changed_cb (GnomeDbDsnConfig *config, gpointer user_data)
{
	gtk_dialog_set_response_sensitive (GTK_DIALOG (user_data), GTK_RESPONSE_OK, TRUE);
}

static void
notebook_switch_page_cb (GtkNotebook *notebook,
			 GtkNotebookPage *page,
			 gint page_num,
			 gpointer user_data)
{
	GtkWidget *w;
	GdaConnection *cnc;

	cnc = g_object_get_data (G_OBJECT (notebook), "GdaConnection");
	if (GDA_IS_CONNECTION (cnc))
		return;
	if (page_num == 0)
		return;

	w = (GtkWidget *) user_data;

	cnc = db_connect_dialog_for_dsn (g_object_get_data (G_OBJECT (notebook), "GdaDataSourceName"));
	if (GDA_IS_CONNECTION (cnc)) {
		tables_page_set_connection (w, cnc);

		g_object_set_data_full (G_OBJECT (notebook), "GdaConnection",
					cnc, g_object_unref);
	} else
		gtk_notebook_set_current_page (notebook, 0);
}

void
dsn_properties_dialog (GtkWindow *parent, const gchar *dsn)
{
	GdaDataSourceInfo *dsn_info;
	GtkWidget *dialog, *props, *notebook, *page;
	GdkPixbuf *icon;

	dsn_info = gnome_db_config_find_data_source (dsn);
	if (!dsn_info)
		return;

	/* create the dialog */
	dialog = gtk_dialog_new_with_buttons (
		_("Data source properties"),
		parent, GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_SAVE, GTK_RESPONSE_OK,
		NULL);
	gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK, FALSE);

	icon = gdk_pixbuf_new_from_file (LIBGNOMEDB_ICONSDIR "/gnome-db.png", NULL);
	if (icon) {
		gtk_window_set_icon (GTK_WINDOW (dialog), icon);
		g_object_unref (icon);
	}

	gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), 12);
	notebook = gnome_db_new_notebook_widget ();
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE, TRUE, 0);

	g_object_set_data (G_OBJECT (notebook), "GdaDataSourceName", dsn);

	/* create data source settings page */
	props = gnome_db_dsn_config_new ();
	gtk_container_set_border_width (GTK_CONTAINER (props), 12);
	gnome_db_dsn_config_set_info (GNOME_DB_DSN_CONFIG (props), dsn_info);
	gtk_widget_show (props);
	g_signal_connect (G_OBJECT (props), "changed", G_CALLBACK (dsn_changed_cb), dialog);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), props, gtk_label_new (dsn_info->name));

	/* create tables page */
	page = tables_page_new ();
	gtk_container_set_border_width (GTK_CONTAINER (page), 12);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), page, gtk_label_new (_("Tables")));

	gnome_db_config_free_data_source_info (dsn_info);

	g_signal_connect (G_OBJECT (notebook), "switch-page",
			  G_CALLBACK (notebook_switch_page_cb), page);

	/* run the dialog */
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
		dsn_info = gnome_db_dsn_config_get_info (GNOME_DB_DSN_CONFIG (props));
		if (dsn_info) {
			gnome_db_config_save_data_source (dsn_info->name,
						     dsn_info->provider,
						     dsn_info->cnc_string,
						     dsn_info->description,
						     dsn_info->username,
						     dsn_info->password);
			gnome_db_config_free_data_source_info (dsn_info);
		}
	}

	gtk_widget_destroy (dialog);

	/* free memory */
}
