/* GNOME DB library
 * Copyright (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *      Vivien Malerba <malerba@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_widget_h__)
#  define __gnome_db_control_widget_h__

#include <bonobo/Bonobo.h>
#include <gtk/gtkvbox.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_CONTROL_WIDGET            (gnome_db_control_widget_get_type())
#define GNOME_DB_CONTROL_WIDGET(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidget))
#define GNOME_DB_CONTROL_WIDGET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidgetClass))
#define GNOME_DB_IS_CONTROL_WIDGET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_CONTROL_WIDGET))
#define GNOME_DB_IS_CONTROL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_CONTROL_WIDGET))

typedef struct _GnomeDbControlWidget        GnomeDbControlWidget;
typedef struct _GnomeDbControlWidgetClass   GnomeDbControlWidgetClass;
typedef struct _GnomeDbControlWidgetPrivate GnomeDbControlWidgetPrivate;

struct _GnomeDbControlWidget {
	GtkVBox box;
	GnomeDbControlWidgetPrivate *priv;
};

struct _GnomeDbControlWidgetClass {
	GtkVBoxClass parent_class;
};

GType          gnome_db_control_widget_get_type (void);
GtkWidget     *gnome_db_control_widget_construct (GnomeDbControlWidget *wid,
						const gchar *id,
						Bonobo_UIContainer uic);
GtkWidget     *gnome_db_control_widget_new (const gchar *id, Bonobo_UIContainer uic);

gboolean       gnome_db_control_widget_is_alive (GnomeDbControlWidget *wid);

void           gnome_db_control_widget_activate (GnomeDbControlWidget *wid);
void           gnome_db_control_widget_deactivate (GnomeDbControlWidget *wid);

const gchar   *gnome_db_control_widget_get_id (GnomeDbControlWidget *wid);
Bonobo_Unknown gnome_db_control_widget_get_objref (GnomeDbControlWidget *wid);

G_END_DECLS

#endif
