/* GNOME DB VFS access module
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <libgda/gda-config.h>
#include <libgda/gda-connection.h>
#include <bonobo/bonobo-i18n.h>
#include "dbvfs.h"

#define TABLES_PATH _("Tables")
#define VIEWS_PATH  _("Views")

typedef struct {
	GdaConnection *cnc;
} DbHandle;

typedef struct {
	GList *data_sources;
} DbVFSRootDirHandle;

static DbVFSRootDirHandle *
dbvfs_root_dir_new (GnomeVFSURI *uri)
{
	DbVFSRootDirHandle *handle;

	handle = g_new0 (DbVFSRootDirHandle, 1);
	handle->data_sources = gda_config_get_data_source_list ();

	return handle;
}

/* do_open handler for the DB method */
GnomeVFSResult
dbvfs_do_open (GnomeVFSMethod *method,
	       GnomeVFSMethodHandle **method_handle,
	       GnomeVFSURI *uri,
	       GnomeVFSOpenMode mode,
	       GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_close (GnomeVFSMethod *method,
		GnomeVFSMethodHandle *method_handle,
		GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_read (GnomeVFSMethod *method,
	       GnomeVFSMethodHandle *method_handle,
	       gpointer buffer,
	       GnomeVFSFileSize num_bytes,
	       GnomeVFSFileSize *bytes_read,
	       GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_write (GnomeVFSMethod *method,
		GnomeVFSMethodHandle *method_handle,
		gconstpointer buffer,
		GnomeVFSFileSize num_bytes,
		GnomeVFSFileSize *bytes_written,
		GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_create (GnomeVFSMethod *method,
		 GnomeVFSMethodHandle **method_handle,
		 GnomeVFSURI *uri,
		 GnomeVFSOpenMode mode,
		 gboolean exclusive,
		 guint perm,
		 GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_get_file_info (GnomeVFSMethod *method,
			GnomeVFSURI *uri,
			GnomeVFSFileInfo *vfs_file_info,
			GnomeVFSFileInfoOptions options,
			GnomeVFSContext *context)
{
	// FIXME
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

gboolean
dbvfs_do_is_local (GnomeVFSMethod *method, const GnomeVFSURI *uri)
{
	return FALSE;
}

/* do_open_directory handler for the DB method */
GnomeVFSResult
dbvfs_do_open_directory (GnomeVFSMethod *method,
		   GnomeVFSMethodHandle **method_handle,
		   GnomeVFSURI *uri,
		   GnomeVFSFileInfoOptions options,
		   GnomeVFSContext *context)
{
	const gchar *path;
	DbVFSRootDirHandle *root_handle;

	path = gnome_vfs_uri_get_path ((const GnomeVFSURI *) uri);
	if (!path || (path && !strcmp (path, "/"))) {
		/* it's the root dir */
		root_handle = dbvfs_root_dir_new (uri);
		*method_handle = root_handle;
		return GNOME_VFS_OK;
	}

	return GNOME_VFS_ERROR_NOT_FOUND;
}

GnomeVFSResult
dbvfs_do_close_directory (GnomeVFSMethod *method,
			  GnomeVFSMethodHandle *method_handle,
			  GnomeVFSContext *context)
{
	DbVFSRootDirHandle *root_handle = (DbVFSRootDirHandle *) method_handle;

	g_return_val_if_fail (root_handle != NULL, GNOME_VFS_ERROR_BAD_PARAMETERS);

	gda_config_free_data_source_list (root_handle->data_sources);
	g_free (root_handle);

	return GNOME_VFS_OK;
}

GnomeVFSResult
dbvfs_do_read_directory (GnomeVFSMethod *method,
			 GnomeVFSMethodHandle *method_handle,
			 GnomeVFSFileInfo *file_info,
			 GnomeVFSContext *context)
{
	GdaDataSourceInfo *dsn_info;
	DbVFSRootDirHandle *root_handle = (DbVFSRootDirHandle *) method_handle;

	g_return_val_if_fail (root_handle != NULL, GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (root_handle->data_sources) {
		dsn_info = (GdaDataSourceInfo *) root_handle->data_sources->data;

		root_handle->data_sources = g_list_remove (root_handle->data_sources, dsn_info);

		file_info->name = g_strdup (dsn_info->name);
		file_info->type = GNOME_VFS_FILE_TYPE_REGULAR;
		file_info->permissions = GNOME_VFS_PERM_USER_ALL;
		file_info->flags = GNOME_VFS_FILE_FLAGS_SYMLINK;
		file_info->size = 0;
		file_info->symlink_name = g_strdup_printf ("database:///%s/", dsn_info->name);
		file_info->valid_fields = GNOME_VFS_FILE_INFO_FIELDS_TYPE |
			GNOME_VFS_FILE_INFO_FIELDS_PERMISSIONS | GNOME_VFS_FILE_INFO_FIELDS_FLAGS |
			GNOME_VFS_FILE_INFO_FIELDS_SIZE | GNOME_VFS_FILE_INFO_FIELDS_SYMLINK_NAME;

		gda_config_free_data_source_info (dsn_info);

		return GNOME_VFS_OK;
	} else
		return GNOME_VFS_ERROR_NOT_FOUND;

	return GNOME_VFS_ERROR_GENERIC;
}

GnomeVFSResult
dbvfs_do_seek (GnomeVFSMethod *method,
	       GnomeVFSMethodHandle *method_handle,
	       GnomeVFSSeekPosition whence,
	       GnomeVFSFileOffset offset,
	       GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_tell (GnomeVFSMethod *method,
	       GnomeVFSMethodHandle *method_handle,
	       GnomeVFSFileOffset *offset_return)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_unlink (GnomeVFSMethod *method,
		 GnomeVFSURI *uri,
		 GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_check_same_fs (GnomeVFSMethod *method,
			GnomeVFSURI *a,
			GnomeVFSURI *b,
			gboolean *same_fs_return,
			GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_move (GnomeVFSMethod *method,
	       GnomeVFSURI *old_uri,
	       GnomeVFSURI *new_uri,
	       gboolean force_replace,
	       GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_truncate_handle (GnomeVFSMethod *method,
			  GnomeVFSMethodHandle *method_handle,
			  GnomeVFSFileSize where,
			  GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_get_file_info_from_handle (GnomeVFSMethod *method,
				    GnomeVFSMethodHandle *method_handle,
				    GnomeVFSFileInfo *file_info,
				    GnomeVFSFileInfoOptions options,
				    GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_make_directory (GnomeVFSMethod *method,
			 GnomeVFSURI *uri,
			 guint perm,
			 GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_remove_directory (GnomeVFSMethod *method,
			   GnomeVFSURI *uri,
			   GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_set_file_info (GnomeVFSMethod *method,
			GnomeVFSURI *uri,
			const GnomeVFSFileInfo *info,
			GnomeVFSSetFileInfoMask mask,
			GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_truncate (GnomeVFSMethod *method,
		   GnomeVFSURI *uri,
		   GnomeVFSFileSize where,
		   GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_find_directory (GnomeVFSMethod *method,
			 GnomeVFSURI *near_uri,
			 GnomeVFSFindDirectoryKind kind,
			 GnomeVFSURI **result_uri,
			 gboolean create_if_needed,
			 gboolean find_if_needed,
			 guint permissions,
			 GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}

GnomeVFSResult
dbvfs_do_create_symbolic_link (GnomeVFSMethod *method,
			       GnomeVFSURI *uri,
			       const char *target_reference,
			       GnomeVFSContext *context)
{
	return GNOME_VFS_ERROR_NOT_SUPPORTED;
}
