#ifndef GNOME_CUPS_REQUEST_H
#define GNOME_CUPS_REQUEST_H

#include <cups/ipp.h>
#include <glib.h>
#include "gnome-cups-init.h"

typedef void (*GnomeCupsAsyncRequestCallback) (guint id,
					       const char *path,
					       ipp_t *response,
					       GError **error,
					       gpointer cb_data);

ipp_t *gnome_cups_request_new                      (int          operation_id);
ipp_t *gnome_cups_request_new_for_printer          (int          operation_id,
						    const char  *printer_name);
ipp_t *gnome_cups_request_new_for_job              (int          operation_id,
						    int          job_id);
void   gnome_cups_request_add_requested_attributes (ipp_t       *request,
						    ipp_tag_t    group,
						    int          n_attributes,
						    char       **attributes);
ipp_t *gnome_cups_request_execute                  (ipp_t       *request,
						    const char  *server,
						    const char  *path,
						    GError     **err);
guint gnome_cups_request_execute_async             (ipp_t       *request,
						    const char *server,
						    const char  *path,
						    GnomeCupsAsyncRequestCallback callback,
						    gpointer cb_data,
						    GDestroyNotify destroy_notify);

void gnome_cups_request_cancel (guint request_id);

/* private */
guint _gnome_cups_outstanding_request_count (void);
void _gnome_cups_request_init (GnomeCupsAuthFunction authfn);
void _gnome_cups_request_shutdown (void);



#endif
