
#include <libgnomecanvasmm/rect.h>
#include <libgnomecanvasmm/private/rect_p.h>

/* $Id: rect.ccg,v 1.1 2002/02/24 20:41:19 murrayc Exp $ */

/* rect.c
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace Canvas
{

Rect::Rect(Group& parentx, double x1, double y1, double x2, double y2)
: RectEllipse(GNOME_CANVAS_RE(g_object_new(get_type(),0)))
{
  item_construct(parentx);
  set("x1",x1,"y1",y1,"x2",x2,"y2",y2,0);
}

Rect::Rect(Group& parentx)
: RectEllipse(GNOME_CANVAS_RE(g_object_new(get_type(),0)))
{
  item_construct(parentx);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Rect* wrap(GnomeCanvasRect* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Rect *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Rect_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_rect_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Rect_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Rect_Class::wrap_new(GObject* o)
{
  return manage(new Rect((GnomeCanvasRect*)(o)));
}


/* The implementation: */

Rect::Rect(GnomeCanvasRect* castitem)
: RectEllipse((GnomeCanvasRE*)(castitem))
{}

Rect::~Rect()
{
  destroy_();
}

Rect::CppClassType Rect::rect_class_; //Initialize static member.

GType Rect::get_type()
{
  return rect_class_.get_type();
}

GType Rect::get_base_type()
{
  return gnome_canvas_rect_get_type();
}


} // namespace Canvas

} // namespace Gnome

