
#include <libgnomecanvasmm/rect-ellipse.h>
#include <libgnomecanvasmm/private/rect-ellipse_p.h>

/* $Id: rect-ellipse.ccg,v 1.1 2002/02/24 20:41:19 murrayc Exp $ */

/* ellipse.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace Canvas
{

RectEllipse::RectEllipse(Group& parent)
    : Shape(GNOME_CANVAS_SHAPE(g_object_new(get_type(),0)))
{
  item_construct(parent);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::RectEllipse* wrap(GnomeCanvasRE* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::RectEllipse *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType RectEllipse_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_re_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void RectEllipse_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* RectEllipse_Class::wrap_new(GObject* o)
{
  return manage(new RectEllipse((GnomeCanvasRE*)(o)));
}


/* The implementation: */

RectEllipse::RectEllipse(GnomeCanvasRE* castitem)
: Shape((GnomeCanvasShape*)(castitem))
{}

RectEllipse::~RectEllipse()
{
  destroy_();
}

RectEllipse::CppClassType RectEllipse::rectellipse_class_; //Initialize static member.

GType RectEllipse::get_type()
{
  return rectellipse_class_.get_type();
}

GType RectEllipse::get_base_type()
{
  return gnome_canvas_re_get_type();
}


Glib::PropertyProxy<double> RectEllipse::property_x1()
{
  return Glib::PropertyProxy<double>(this, "x1");
}

Glib::PropertyProxy<double> RectEllipse::property_y1()
{
  return Glib::PropertyProxy<double>(this, "y1");
}

Glib::PropertyProxy<double> RectEllipse::property_x2()
{
  return Glib::PropertyProxy<double>(this, "x2");
}

Glib::PropertyProxy<double> RectEllipse::property_y2()
{
  return Glib::PropertyProxy<double>(this, "y2");
}


} // namespace Canvas

} // namespace Gnome

