/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:05 EDT
 */

package org.gnu.gnome;
import org.gnu.gdk.Bitmap;
import org.gnu.gdk.Color;
import org.gnu.glib.Type;

/**
 * The GnomeCanvasRect is a GnomeCanvasItem that draws itself as a
 * rectangle on a GnomeCanvas.
 */
public class CanvasRect extends CanvasRE {
	/**
	 * Constructs an instance of CanvasRect from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasRect(int handle) {
		super(handle);
	}

	/**
	 * Creates a new CanvasRect object.
	 * @param group The parent group for the new CanvasItem.
	 * @param x1 The leftmost coordinate.
	 * @param y1 The topmost coordinate.
	 * @param x2 The rightmost coordinate.
	 * @param y2 The bottommost coordinate.
	 * @param fill_color Fill color to be used.
	 * @param outline_color Outline color or null for transparent.
	 * @param fill_stipple Stipple used when drawing fill.
	 * @param outline_stipple Stipple used when drawing outline.
	 * @param width_pixels Outline width specified in pixels, independent of
	 *                     zoom factor. 
	 */
	public CanvasRect(CanvasGroup group, double x1, double y1, double x2, double y2, Color fill_color, Color outline_color, Bitmap fill_stipple, Bitmap outline_stipple, int width_pixels) {
		super(
			gnome_canvas_re_new_gdk_wpix(
				group.getHandle(),
				gnome_canvas_rect_get_type(),
				x1,
				y1,
				x2,
				y2,
				fill_color.getHandle(),
				outline_color == null ? 0 : outline_color.getHandle(),
				fill_stipple == null ? 0 : fill_stipple.getHandle(),
				outline_stipple == null ? 0 : outline_stipple.getHandle(),
				width_pixels));
	}

	/**
	 * Creates a new CanvasRect object.
	 * @param group The parent group for the new CanvasItem.
	 * @param x1 The leftmost coordinate.
	 * @param y1 The topmost coordinate.
	 * @param x2 The rightmost coordinate.
	 * @param y2 The bottommost coordinate.
	 * @param fill_color Fill color to be used.
	 * @param outline_color Outline color or null for transparent.
	 * @param fill_stipple Stipple used when drawing fill.
	 * @param outline_stipple Stipple used when drawing outline.
	 * @param width_units Outline width specified in Canvas units.
	 */
	public CanvasRect(CanvasGroup group, double x1, double y1, double x2, double y2, Color fill_color, Color outline_color, Bitmap fill_stipple, Bitmap outline_stipple, double width_units) {
		super(
			gnome_canvas_re_new_gdk_wunit(
				group.getHandle(),
				gnome_canvas_rect_get_type(),
				x1,
				y1,
				x2,
				y2,
				fill_color.getHandle(),
				outline_color == null ? 0 : outline_color.getHandle(),
				fill_stipple == null ? 0 : fill_stipple.getHandle(),
				outline_stipple == null ? 0 : outline_stipple.getHandle(),
				width_units));
	}

	/**
	 * Creates a new CanvasRect object.
	 * @param group The parent group for the new CanvasItem.
	 * @param x1 The leftmost coordinate.
	 * @param y1 The topmost coordinate.
	 * @param x2 The rightmost coordinate.
	 * @param y2 The bottommost coordinate.
	 * @param fill_color Fill color to be used.
	 * @param outline_color Outline color.
	 * @param width_pixels Outline width specified in pixels, independent of
	 *                     zoom factor. 
	 */
	public CanvasRect(CanvasGroup group, double x1, double y1, double x2, double y2, int fill_color, int outline_color, int width_pixels) {
		super(gnome_canvas_re_new_rgba_wpix(group.getHandle(), gnome_canvas_rect_get_type(), x1, y1, x2, y2, fill_color, outline_color, width_pixels));
	}

	/**
	 * Creates a new CanvasRect object.
	 * @param group The parent group for the new CanvasItem.
	 * @param x1 The leftmost coordinate.
	 * @param y1 The topmost coordinate.
	 * @param x2 The rightmost coordinate.
	 * @param y2 The bottommost coordinate.
	 * @param fill_color Fill color to be used.
	 * @param outline_color Outline color.
	 * @param width_units Outline width specified in Canvas units.
	 */
	public CanvasRect(CanvasGroup group, double x1, double y1, double x2, double y2, int fill_color, int outline_color, double width_units) {
		super(gnome_canvas_re_new_rgba_wunit(group.getHandle(), gnome_canvas_rect_get_type(), x1, y1, x2, y2, fill_color, outline_color, width_units));
	}

	protected void noopInit() {
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_rect_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_canvas_rect_get_type();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
