/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gnome.DateEdit} widget.
 */
public class DateEditEvent extends GtkEvent {
	/**
	 * Type of a DateEditEvent
	 */
	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		public static final Type DATE_CHANGED = new Type(1, "DATE_CHANGED");
		public static final Type TIME_CHANGED = new Type(2, "TIME_CHANGED");
		
	}

	
	/**
	 * Creates a new DateEditEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public DateEditEvent(Object source, DateEditEvent.Type type) {
		super(source, type);
	}
	
	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DateEditEvent.Type aType){
		return ( type.getID() == aType.getID());
	}

}
