/* GNetwork: src/gnetwork-dns.h
 *
 * Copyright (C) 2001, 2003 James M. Cape
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/*

GLib 2.0 DNS lookup backend.

Notes on editing:
	Tab size: 4
*/


#ifndef __GNETWORK_DNS_H__
#define __GNETWORK_DNS_H__

#include <glib-object.h>

G_BEGIN_DECLS


#define GNETWORK_TYPE_DNS_ENTRY		(gnetwork_dns_entry_get_type ())
#define GNETWORK_DNS_ENTRY(ptr)		((GNetworkDnsEntry *)(ptr))

#define GNETWORK_DNS_INVALID_HANDLE	-1

#define GNETWORK_DNS_ERROR		(gnetwork_dns_error_get_quark ())


typedef enum /* <prefix=GNETWORK_DNS_ERROR> */
{
  /* <private> */
  GNETWORK_DNS_ERROR_IN_PROGRESS = -1,

  /* <public> */
  GNETWORK_DNS_ERROR_NONE = 0,

  GNETWORK_DNS_ERROR_NOT_FOUND,
  GNETWORK_DNS_ERROR_NO_RECOVERY,
  GNETWORK_DNS_ERROR_TRY_AGAIN,
  GNETWORK_DNS_ERROR_IPV4_IPV6_MISMATCH,

  /* <private> */
  GNETWORK_DNS_ERROR_INTERNAL
}
GNetworkDnsError;


typedef glong GNetworkDnsHandle;
typedef struct _GNetworkDnsEntry GNetworkDnsEntry;

typedef void (*GNetworkDnsCallbackFunc) (const GNetworkDnsEntry * entry, gpointer user_data);


struct _GNetworkDnsEntry
{
  GNetworkDnsError error;

  gchar *hostname;
  GSList *aliases;
  GSList *ip_addresses;
};


GNetworkDnsHandle gnetwork_dns_get (const gchar * address, GNetworkDnsCallbackFunc callback,
				    gpointer user_data, GDestroyNotify destroy_data,
				    GError ** error);
void gnetwork_dns_cancel (GNetworkDnsHandle handle);

GType gnetwork_dns_entry_get_type (void) G_GNUC_CONST;

GNetworkDnsEntry *gnetwork_dns_entry_new (void);
void gnetwork_dns_entry_free (GNetworkDnsEntry * entry);
GNetworkDnsEntry *gnetwork_dns_entry_copy (const GNetworkDnsEntry * src);

G_CONST_RETURN gchar *gnetwork_dns_strerror (GNetworkDnsError error);
GQuark gnetwork_dns_error_get_quark (void) G_GNUC_CONST;


G_END_DECLS

#endif /* __GNETWORK_Dns_H__ */
