#include <libglademm/xml.h>
#include <gtkmm/dialog.h>
#include <gtkmm/button.h>
#include <gtkmm/main.h>

int main (int argc, char **argv)
{
  Gtk::Main kit(argc, argv);

  Glib::RefPtr<Gnome::Glade::Xml> xml = Gnome::Glade::Xml::create("basic.glade");

  Gtk::Dialog* pDialog = (Gtk::Dialog*)xml->get_widget("DialogBasic");
  if(pDialog)
  {
    Gtk::Button* pButton = (Gtk::Button*)xml->get_widget("quit_button");
    if(pButton)
    {
      pButton->signal_clicked().connect(SigC::slot(*pDialog, &Gtk::Dialog::hide)); //hide() will cause main::run() to end.
    }
    else
    {
      g_warning("quit_button not found in glade file.\n");
    }

    kit.run(*pDialog);
  }
}
