/* testreadonlycollection.c generated by valac 0.10.0, the Vala compiler
 * generated from testreadonlycollection.vala, do not modify */

/* testreadonlycollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Tomaž Vajngerl <quikee@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_READ_ONLY_COLLECTION_TESTS (read_only_collection_tests_get_type ())
#define READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTests))
#define READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))
#define IS_READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READ_ONLY_COLLECTION_TESTS))
#define IS_READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READ_ONLY_COLLECTION_TESTS))
#define READ_ONLY_COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))

typedef struct _ReadOnlyCollectionTests ReadOnlyCollectionTests;
typedef struct _ReadOnlyCollectionTestsClass ReadOnlyCollectionTestsClass;
typedef struct _ReadOnlyCollectionTestsPrivate ReadOnlyCollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _ReadOnlyCollectionTests {
	GeeTestCase parent_instance;
	ReadOnlyCollectionTestsPrivate * priv;
	GeeCollection* test_collection;
	GeeCollection* ro_collection;
};

struct _ReadOnlyCollectionTestsClass {
	GeeTestCaseClass parent_class;
	GeeCollection* (*get_ro_view) (ReadOnlyCollectionTests* self, GeeCollection* collection);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer read_only_collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType read_only_collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	READ_ONLY_COLLECTION_TESTS_DUMMY_PROPERTY
};
ReadOnlyCollectionTests* read_only_collection_tests_new (void);
ReadOnlyCollectionTests* read_only_collection_tests_construct (GType object_type);
ReadOnlyCollectionTests* read_only_collection_tests_new_with_name (const char* name);
ReadOnlyCollectionTests* read_only_collection_tests_construct_with_name (GType object_type, const char* name);
GeeTestCase* gee_test_case_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void read_only_collection_tests_test_unique_read_only_view_instance (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_immutable_iterator (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_immutable (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_immutable_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_accurate_view (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_accurate_view_gee_test_case_test_method (gpointer self);
static void read_only_collection_tests_real_set_up (GeeTestCase* base);
GeeCollection* read_only_collection_tests_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection);
static void read_only_collection_tests_real_tear_down (GeeTestCase* base);
static GeeCollection* read_only_collection_tests_real_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection);
static void read_only_collection_tests_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ReadOnlyCollectionTests* read_only_collection_tests_construct (GType object_type) {
	ReadOnlyCollectionTests * self;
	self = (ReadOnlyCollectionTests*) read_only_collection_tests_construct_with_name (object_type, "ReadOnlyCollection");
	return self;
}


ReadOnlyCollectionTests* read_only_collection_tests_new (void) {
	return read_only_collection_tests_construct (TYPE_READ_ONLY_COLLECTION_TESTS);
}


static void _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_unique_read_only_view_instance (self);
}


static void _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_immutable_iterator (self);
}


static void _read_only_collection_tests_test_immutable_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_immutable (self);
}


static void _read_only_collection_tests_test_accurate_view_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_accurate_view (self);
}


ReadOnlyCollectionTests* read_only_collection_tests_construct_with_name (GType object_type, const char* name) {
	ReadOnlyCollectionTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ReadOnlyCollectionTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] unique read-only view instance", _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] immutable iterator", _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] immutable", _read_only_collection_tests_test_immutable_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] accurate view", _read_only_collection_tests_test_accurate_view_gee_test_case_test_method, self);
	return self;
}


ReadOnlyCollectionTests* read_only_collection_tests_new_with_name (const char* name) {
	return read_only_collection_tests_construct_with_name (TYPE_READ_ONLY_COLLECTION_TESTS, name);
}


static void read_only_collection_tests_real_set_up (GeeTestCase* base) {
	ReadOnlyCollectionTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (ReadOnlyCollectionTests*) base;
	self->test_collection = (_tmp0_ = (GeeCollection*) gee_hash_multi_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (self->test_collection), _tmp0_);
	self->ro_collection = (_tmp1_ = read_only_collection_tests_get_ro_view (self, self->test_collection), _g_object_unref0 (self->ro_collection), _tmp1_);
}


static void read_only_collection_tests_real_tear_down (GeeTestCase* base) {
	ReadOnlyCollectionTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (ReadOnlyCollectionTests*) base;
	self->test_collection = (_tmp0_ = NULL, _g_object_unref0 (self->test_collection), _tmp0_);
	self->ro_collection = (_tmp1_ = NULL, _g_object_unref0 (self->ro_collection), _tmp1_);
}


static GeeCollection* read_only_collection_tests_real_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection) {
	GeeCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	result = gee_collection_get_read_only_view (collection);
	return result;
}


GeeCollection* read_only_collection_tests_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection) {
	return READ_ONLY_COLLECTION_TESTS_GET_CLASS (self)->get_ro_view (self, collection);
}


void read_only_collection_tests_test_unique_read_only_view_instance (ReadOnlyCollectionTests* self) {
	GeeCollection* another_ro_collection;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	another_ro_collection = read_only_collection_tests_get_ro_view (self, self->test_collection);
	g_assert (self->ro_collection == another_ro_collection);
	g_object_set_data_full ((GObject*) self->ro_collection, "marker", g_object_new (G_TYPE_OBJECT, NULL), g_object_unref);
	g_assert (((GObject*) g_object_get_data ((GObject*) another_ro_collection, "marker")) != NULL);
	another_ro_collection = (_tmp0_ = NULL, _g_object_unref0 (another_ro_collection), _tmp0_);
	self->ro_collection = (_tmp1_ = NULL, _g_object_unref0 (self->ro_collection), _tmp1_);
	another_ro_collection = (_tmp2_ = read_only_collection_tests_get_ro_view (self, self->test_collection), _g_object_unref0 (another_ro_collection), _tmp2_);
	g_assert (((GObject*) g_object_get_data ((GObject*) another_ro_collection, "marker")) == NULL);
	g_assert (another_ro_collection == (_tmp3_ = read_only_collection_tests_get_ro_view (self, another_ro_collection)));
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (another_ro_collection);
}


void read_only_collection_tests_test_immutable_iterator (ReadOnlyCollectionTests* self) {
	GeeIterator* iterator;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_add (self->test_collection, "two"));
	g_assert (gee_collection_get_size (self->ro_collection) == 2);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_contains (self->ro_collection, "two"));
	iterator = gee_iterable_iterator ((GeeIterable*) self->ro_collection);
	g_assert (gee_iterator_has_next (iterator));
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_iterator_get (iterator), "one") == 0);
	_g_free0 (_tmp0_);
	g_assert (gee_iterator_has_next (iterator));
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_iterator_get (iterator), "two") == 0);
	_g_free0 (_tmp1_);
	g_assert (!gee_iterator_has_next (iterator));
	g_assert (!gee_iterator_next (iterator));
	g_assert (gee_iterator_first (iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get (iterator), "one") == 0);
	_g_free0 (_tmp2_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_iterator_remove (iterator);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 2);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_contains (self->ro_collection, "two"));
	_g_object_unref0 (iterator);
}


void read_only_collection_tests_test_immutable (ReadOnlyCollectionTests* self) {
	GeeCollection* dummy;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	dummy = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_collection_add (dummy, "one"));
	g_assert (gee_collection_add (dummy, "two"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (gee_collection_add (self->ro_collection, "two"));
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_collection_clear (self->ro_collection);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (gee_collection_remove (self->ro_collection, "one"));
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (gee_collection_add_all (self->ro_collection, dummy));
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (gee_collection_remove_all (self->ro_collection, dummy));
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_remove (dummy, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		g_assert (gee_collection_retain_all (self->ro_collection, dummy));
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	_g_object_unref0 (dummy);
}


void read_only_collection_tests_test_accurate_view (ReadOnlyCollectionTests* self) {
	GeeCollection* dummy;
	g_return_if_fail (self != NULL);
	dummy = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_collection_add (dummy, "one"));
	g_assert (gee_collection_add (dummy, "two"));
	g_assert (gee_iterable_get_element_type ((GeeIterable*) self->ro_collection) == G_TYPE_STRING);
	g_assert (gee_collection_get_size (self->ro_collection) == 0);
	g_assert (gee_collection_get_is_empty (self->ro_collection));
	g_assert (!gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (!gee_collection_get_is_empty (self->ro_collection));
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_add (self->test_collection, "two"));
	g_assert (gee_collection_get_size (self->ro_collection) == 2);
	g_assert (!gee_collection_get_is_empty (self->ro_collection));
	g_assert (gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_contains (self->ro_collection, "two"));
	g_assert (gee_collection_contains_all (self->ro_collection, dummy));
	g_assert (gee_collection_remove (self->test_collection, "one"));
	g_assert (gee_collection_get_size (self->ro_collection) == 1);
	g_assert (!gee_collection_get_is_empty (self->ro_collection));
	g_assert (!gee_collection_contains (self->ro_collection, "one"));
	g_assert (gee_collection_contains (self->ro_collection, "two"));
	g_assert (!gee_collection_contains_all (self->ro_collection, dummy));
	gee_collection_clear (self->test_collection);
	g_assert (gee_collection_get_size (self->ro_collection) == 0);
	g_assert (gee_collection_get_is_empty (self->ro_collection));
	g_assert (!gee_collection_contains (self->ro_collection, "one"));
	g_assert (!gee_collection_contains (self->ro_collection, "two"));
	_g_object_unref0 (dummy);
}


static void read_only_collection_tests_class_init (ReadOnlyCollectionTestsClass * klass) {
	read_only_collection_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = read_only_collection_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = read_only_collection_tests_real_tear_down;
	READ_ONLY_COLLECTION_TESTS_CLASS (klass)->get_ro_view = read_only_collection_tests_real_get_ro_view;
	G_OBJECT_CLASS (klass)->finalize = read_only_collection_tests_finalize;
}


static void read_only_collection_tests_instance_init (ReadOnlyCollectionTests * self) {
}


static void read_only_collection_tests_finalize (GObject* obj) {
	ReadOnlyCollectionTests * self;
	self = READ_ONLY_COLLECTION_TESTS (obj);
	_g_object_unref0 (self->test_collection);
	_g_object_unref0 (self->ro_collection);
	G_OBJECT_CLASS (read_only_collection_tests_parent_class)->finalize (obj);
}


GType read_only_collection_tests_get_type (void) {
	static volatile gsize read_only_collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&read_only_collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReadOnlyCollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) read_only_collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReadOnlyCollectionTests), 0, (GInstanceInitFunc) read_only_collection_tests_instance_init, NULL };
		GType read_only_collection_tests_type_id;
		read_only_collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "ReadOnlyCollectionTests", &g_define_type_info, 0);
		g_once_init_leave (&read_only_collection_tests_type_id__volatile, read_only_collection_tests_type_id);
	}
	return read_only_collection_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




