/* hashset.c generated by valac 0.10.0, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _GeeHashSetPrivate GeeHashSetPrivate;
typedef struct _GeeHashSetNode GeeHashSetNode;

#define GEE_HASH_SET_TYPE_ITERATOR (gee_hash_set_iterator_get_type ())
#define GEE_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator))
#define GEE_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))
#define GEE_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))

typedef struct _GeeHashSetIterator GeeHashSetIterator;
typedef struct _GeeHashSetIteratorClass GeeHashSetIteratorClass;
#define _gee_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_hash_set_node_free (var), NULL)))
typedef struct _GeeHashSetIteratorPrivate GeeHashSetIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeHashSet {
	GeeAbstractSet parent_instance;
	GeeHashSetPrivate * priv;
};

struct _GeeHashSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GHashFunc _hash_func;
	GEqualFunc _equal_func;
	gint _array_size;
	gint _nnodes;
	GeeHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
};

struct _GeeHashSetNode {
	gpointer key;
	GeeHashSetNode* next;
	guint key_hash;
};

struct _GeeHashSetIterator {
	GObject parent_instance;
	GeeHashSetIteratorPrivate * priv;
};

struct _GeeHashSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashSet* _set;
	gint _index;
	GeeHashSetNode* _node;
	GeeHashSetNode* _next;
	gint _stamp;
};


static gpointer gee_hash_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_hash_set_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_hash_set_parent_class = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
static void gee_hash_set_node_free (GeeHashSetNode* self);
#define GEE_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_HASH_SET, GeeHashSetPrivate))
enum  {
	GEE_HASH_SET_DUMMY_PROPERTY,
	GEE_HASH_SET_SIZE,
	GEE_HASH_SET_HASH_FUNC,
	GEE_HASH_SET_EQUAL_FUNC,
	GEE_HASH_SET_G_TYPE,
	GEE_HASH_SET_G_DUP_FUNC,
	GEE_HASH_SET_G_DESTROY_FUNC
};
#define GEE_HASH_SET_MIN_SIZE 11
#define GEE_HASH_SET_MAX_SIZE 13845163
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GHashFunc gee_functions_get_hash_func_for (GType t);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_hash_set_set_hash_func (GeeHashSet* self, GHashFunc value);
static void gee_hash_set_set_equal_func (GeeHashSet* self, GEqualFunc value);
static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key);
GHashFunc gee_hash_set_get_hash_func (GeeHashSet* self);
GEqualFunc gee_hash_set_get_equal_func (GeeHashSet* self);
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key);
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GType gee_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static void gee_hash_set_resize (GeeHashSet* self);
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key);
static void gee_hash_set_real_clear (GeeAbstractCollection* base);
void gee_abstract_collection_clear (GeeAbstractCollection* self);
static void gee_hash_set_node_instance_init (GeeHashSetNode * self);
#define GEE_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorPrivate))
enum  {
	GEE_HASH_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_HASH_SET_ITERATOR_G_TYPE,
	GEE_HASH_SET_ITERATOR_G_DUP_FUNC,
	GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_hash_set_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_first (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
static gpointer gee_hash_set_iterator_real_get (GeeIterator* base);
static void gee_hash_set_iterator_real_remove (GeeIterator* base);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static void gee_hash_set_iterator_finalize (GObject* obj);
static void gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_hash_set_finalize (GObject* obj);
static void gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
 * Constructs a new, empty hash set.
 *
 * If not provided, the functions parameters are requested to the
 * {@link Functions} function factory methods.
 *
 * @param hash_func an optional hash function
 * @param equal_func an optional equality testing function
 */
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	GeeHashSet * self;
	GeeHashSetNode** _tmp0_;
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (hash_func == NULL) {
		hash_func = gee_functions_get_hash_func_for (g_type);
	}
	if (equal_func == NULL) {
		equal_func = gee_functions_get_equal_func_for (g_type);
	}
	gee_hash_set_set_hash_func (self, hash_func);
	gee_hash_set_set_equal_func (self, equal_func);
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
	self->priv->_nodes = (_tmp0_ = g_new0 (GeeHashSetNode*, self->priv->_array_size + 1), self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL), self->priv->_nodes_length1 = self->priv->_array_size, self->priv->__nodes_size_ = self->priv->_nodes_length1, _tmp0_);
	return self;
}


GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	return gee_hash_set_construct (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}


static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key) {
	GeeHashSetNode** result = NULL;
	guint hash_value;
	GeeHashSetNode** node;
	g_return_val_if_fail (self != NULL, NULL);
	hash_value = gee_hash_set_get_hash_func (self) (key);
	node = &self->priv->_nodes[hash_value % self->priv->_array_size];
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if ((*node) != NULL) {
			gboolean _tmp1_ = FALSE;
			if (hash_value != (*node)->key_hash) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !gee_hash_set_get_equal_func (self) ((*node)->key, key);
			}
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		node = &(*node)->next;
	}
	result = node;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node;
	self = (GeeHashSet*) base;
	node = gee_hash_set_lookup_node (self, key);
	result = (*node) != NULL;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base) {
	GeeHashSet * self;
	GeeIterator* result = NULL;
	self = (GeeHashSet*) base;
	result = (GeeIterator*) gee_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node;
	self = (GeeHashSet*) base;
	node = gee_hash_set_lookup_node (self, key);
	if ((*node) != NULL) {
		result = FALSE;
		return result;
	} else {
		guint hash_value;
		gconstpointer _tmp0_;
		hash_value = gee_hash_set_get_hash_func (self) (key);
		*node = gee_hash_set_node_new ((_tmp0_ = key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), hash_value);
		self->priv->_nnodes++;
		gee_hash_set_resize (self);
		self->priv->_stamp++;
		result = TRUE;
		return result;
	}
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node;
	self = (GeeHashSet*) base;
	node = gee_hash_set_lookup_node (self, key);
	if ((*node) != NULL) {
		GeeHashSetNode* _tmp0_;
		GeeHashSetNode* next;
		gpointer _tmp1_;
		GeeHashSetNode* _tmp2_;
		g_assert ((*node) != NULL);
		next = (_tmp0_ = (*node)->next, (*node)->next = NULL, _tmp0_);
		(*node)->key = (_tmp1_ = NULL, (((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL)), _tmp1_);
		gee_hash_set_node_free (*node);
		*node = (_tmp2_ = next, next = NULL, _tmp2_);
		self->priv->_nnodes--;
		gee_hash_set_resize (self);
		self->priv->_stamp++;
		result = TRUE;
		_gee_hash_set_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_hash_set_real_clear (GeeAbstractCollection* base) {
	GeeHashSet * self;
	self = (GeeHashSet*) base;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeHashSetNode* _tmp1_;
				GeeHashSetNode* node;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				node = (_tmp1_ = self->priv->_nodes[i], self->priv->_nodes[i] = NULL, _tmp1_);
				while (TRUE) {
					GeeHashSetNode* _tmp2_;
					GeeHashSetNode* next;
					gpointer _tmp3_;
					GeeHashSetNode* _tmp4_;
					GeeHashSetNode* _tmp5_;
					if (!(node != NULL)) {
						break;
					}
					next = (_tmp2_ = node->next, node->next = NULL, _tmp2_);
					node->key = (_tmp3_ = NULL, ((node->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node->key = (self->priv->g_destroy_func (node->key), NULL)), _tmp3_);
					node = (_tmp5_ = (_tmp4_ = next, next = NULL, _tmp4_), _gee_hash_set_node_free0 (node), _tmp5_);
					_gee_hash_set_node_free0 (next);
				}
				_gee_hash_set_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	gee_hash_set_resize (self);
}


static void gee_hash_set_resize (GeeHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_array_size >= (3 * self->priv->_nnodes)) {
		_tmp1_ = self->priv->_array_size >= GEE_HASH_SET_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((3 * self->priv->_array_size) <= self->priv->_nnodes) {
			_tmp2_ = self->priv->_array_size < GEE_HASH_SET_MAX_SIZE;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint new_array_size;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		GeeHashSetNode** _tmp3_;
		GeeHashSetNode** new_nodes;
		GeeHashSetNode** _tmp16_;
		GeeHashSetNode** _tmp17_;
		new_array_size = (gint) g_spaced_primes_closest ((guint) self->priv->_nnodes);
		new_array_size = CLAMP (new_array_size, GEE_HASH_SET_MIN_SIZE, GEE_HASH_SET_MAX_SIZE);
		new_nodes = (_tmp3_ = g_new0 (GeeHashSetNode*, new_array_size + 1), new_nodes_length1 = new_array_size, _new_nodes_size_ = new_nodes_length1, _tmp3_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					GeeHashSetNode* node;
					GeeHashSetNode* next;
					if (!_tmp4_) {
						i++;
					}
					_tmp4_ = FALSE;
					if (!(i < self->priv->_array_size)) {
						break;
					}
					node = NULL;
					next = NULL;
					{
						GeeHashSetNode* _tmp5_;
						GeeHashSetNode* _tmp6_;
						gboolean _tmp7_;
						node = (_tmp6_ = (_tmp5_ = self->priv->_nodes[i], self->priv->_nodes[i] = NULL, _tmp5_), _gee_hash_set_node_free0 (node), _tmp6_);
						_tmp7_ = TRUE;
						while (TRUE) {
							GeeHashSetNode* _tmp10_;
							GeeHashSetNode* _tmp11_;
							guint hash_val;
							GeeHashSetNode* _tmp12_;
							GeeHashSetNode* _tmp13_;
							GeeHashSetNode* _tmp14_;
							GeeHashSetNode* _tmp15_;
							if (!_tmp7_) {
								GeeHashSetNode* _tmp8_;
								GeeHashSetNode* _tmp9_;
								node = (_tmp9_ = (_tmp8_ = next, next = NULL, _tmp8_), _gee_hash_set_node_free0 (node), _tmp9_);
							}
							_tmp7_ = FALSE;
							if (!(node != NULL)) {
								break;
							}
							next = (_tmp11_ = (_tmp10_ = node->next, node->next = NULL, _tmp10_), _gee_hash_set_node_free0 (next), _tmp11_);
							hash_val = node->key_hash % new_array_size;
							node->next = (_tmp13_ = (_tmp12_ = new_nodes[hash_val], new_nodes[hash_val] = NULL, _tmp12_), _gee_hash_set_node_free0 (node->next), _tmp13_);
							new_nodes[hash_val] = (_tmp15_ = (_tmp14_ = node, node = NULL, _tmp14_), _gee_hash_set_node_free0 (new_nodes[hash_val]), _tmp15_);
						}
					}
					_gee_hash_set_node_free0 (next);
					_gee_hash_set_node_free0 (node);
				}
			}
		}
		self->priv->_nodes = (_tmp17_ = (_tmp16_ = new_nodes, new_nodes = NULL, _tmp16_), self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL), self->priv->_nodes_length1 = new_nodes_length1, self->priv->__nodes_size_ = self->priv->_nodes_length1, _tmp17_);
		self->priv->_array_size = new_array_size;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	}
}


static gint gee_hash_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeHashSet* self;
	self = (GeeHashSet*) base;
	result = self->priv->_nnodes;
	return result;
}


GHashFunc gee_hash_set_get_hash_func (GeeHashSet* self) {
	GHashFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_hash_func;
	return result;
}


static void gee_hash_set_set_hash_func (GeeHashSet* self, GHashFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_hash_func = value;
	g_object_notify ((GObject *) self, "hash-func");
}


GEqualFunc gee_hash_set_get_equal_func (GeeHashSet* self) {
	GEqualFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_equal_func;
	return result;
}


static void gee_hash_set_set_equal_func (GeeHashSet* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
	g_object_notify ((GObject *) self, "equal-func");
}


static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash) {
	GeeHashSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeHashSetNode);
	gee_hash_set_node_instance_init (self);
	self->key = (_tmp0_ = k, k = NULL, _tmp0_);
	self->key_hash = hash;
	return self;
}


static void gee_hash_set_node_instance_init (GeeHashSetNode * self) {
}


static void gee_hash_set_node_free (GeeHashSetNode* self) {
	_gee_hash_set_node_free0 (self->next);
	g_slice_free (GeeHashSetNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	GeeHashSetIterator * self;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeHashSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
	self->priv->_stamp = self->priv->_set->priv->_stamp;
	return self;
}


static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	return gee_hash_set_iterator_construct (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static gboolean gee_hash_set_iterator_real_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	self = (GeeHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	if (!gee_iterator_has_next ((GeeIterator*) self)) {
		result = FALSE;
		return result;
	}
	self->priv->_node = self->priv->_next;
	self->priv->_next = NULL;
	result = self->priv->_node != NULL;
	return result;
}


static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	self = (GeeHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	if (self->priv->_next == NULL) {
		self->priv->_next = self->priv->_node;
		if (self->priv->_next != NULL) {
			self->priv->_next = self->priv->_next->next;
		}
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			if (self->priv->_next == NULL) {
				_tmp0_ = (self->priv->_index + 1) < self->priv->_set->priv->_array_size;
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			self->priv->_index++;
			self->priv->_next = self->priv->_set->priv->_nodes[self->priv->_index];
		}
	}
	result = self->priv->_next != NULL;
	return result;
}


static gboolean gee_hash_set_iterator_real_first (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	self = (GeeHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	if (gee_collection_get_size ((GeeCollection*) self->priv->_set) == 0) {
		result = FALSE;
		return result;
	}
	self->priv->_index = -1;
	self->priv->_next = NULL;
	result = gee_iterator_next ((GeeIterator*) self);
	return result;
}


static gpointer gee_hash_set_iterator_real_get (GeeIterator* base) {
	GeeHashSetIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	g_assert (self->priv->_node != NULL);
	result = (_tmp0_ = self->priv->_node->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static void gee_hash_set_iterator_real_remove (GeeIterator* base) {
	GeeHashSetIterator * self;
	self = (GeeHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	g_assert (self->priv->_node != NULL);
	gee_iterator_has_next ((GeeIterator*) self);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_set, self->priv->_node->key);
	self->priv->_node = NULL;
	self->priv->_stamp = self->priv->_set->priv->_stamp;
}


static void gee_hash_set_iterator_class_init (GeeHashSetIteratorClass * klass) {
	gee_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeHashSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_hash_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_hash_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_hash_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_hash_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_hash_set_iterator_real_next;
	iface->has_next = gee_hash_set_iterator_real_has_next;
	iface->first = gee_hash_set_iterator_real_first;
	iface->get = gee_hash_set_iterator_real_get;
	iface->remove = gee_hash_set_iterator_real_remove;
}


static void gee_hash_set_iterator_instance_init (GeeHashSetIterator * self) {
	self->priv = GEE_HASH_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_stamp = 0;
}


static void gee_hash_set_iterator_finalize (GObject* obj) {
	GeeHashSetIterator * self;
	self = GEE_HASH_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_hash_set_iterator_parent_class)->finalize (obj);
}


static GType gee_hash_set_iterator_get_type (void) {
	static volatile gsize gee_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSetIterator), 0, (GInstanceInitFunc) gee_hash_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_hash_set_iterator_type_id;
		gee_hash_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeHashSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_hash_set_iterator_type_id__volatile, gee_hash_set_iterator_type_id);
	}
	return gee_hash_set_iterator_type_id__volatile;
}


static void gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = GEE_HASH_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = GEE_HASH_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_HASH_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_hash_set_class_init (GeeHashSetClass * klass) {
	gee_hash_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeHashSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_hash_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_hash_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_hash_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_hash_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_hash_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_hash_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_hash_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_hash_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_SIZE, "size");
	/**
	 * The elements' hash function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_HASH_FUNC, g_param_spec_pointer ("hash-func", "hash-func", "hash-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The elements' equality testing function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_hash_set_instance_init (GeeHashSet * self) {
	self->priv = GEE_HASH_SET_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void gee_hash_set_finalize (GObject* obj) {
	GeeHashSet * self;
	self = GEE_HASH_SET (obj);
	{
		gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	}
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	G_OBJECT_CLASS (gee_hash_set_parent_class)->finalize (obj);
}


/**
 * Hash table implementation of the {@link Set} interface.
 *
 * This implementation is better fit for highly heterogenous values.
 * In case of high value hashes redundancy or higher amount of data prefer using
 * tree implementation like {@link TreeSet}.
 *
 * @see TreeSet
 */
GType gee_hash_set_get_type (void) {
	static volatile gsize gee_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSet), 0, (GInstanceInitFunc) gee_hash_set_instance_init, NULL };
		GType gee_hash_set_type_id;
		gee_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeHashSet", &g_define_type_info, 0);
		g_once_init_leave (&gee_hash_set_type_id__volatile, gee_hash_set_type_id);
	}
	return gee_hash_set_type_id__volatile;
}


static void gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = GEE_HASH_SET (object);
	switch (property_id) {
		case GEE_HASH_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_HASH_SET_HASH_FUNC:
		g_value_set_pointer (value, gee_hash_set_get_hash_func (self));
		break;
		case GEE_HASH_SET_EQUAL_FUNC:
		g_value_set_pointer (value, gee_hash_set_get_equal_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = GEE_HASH_SET (object);
	switch (property_id) {
		case GEE_HASH_SET_HASH_FUNC:
		gee_hash_set_set_hash_func (self, g_value_get_pointer (value));
		break;
		case GEE_HASH_SET_EQUAL_FUNC:
		gee_hash_set_set_equal_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_HASH_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




