/* testqueue.c generated by valac 0.10.0, the Vala compiler
 * generated from testqueue.vala, do not modify */

/* testqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_QUEUE_TESTS (queue_tests_get_type ())
#define QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUEUE_TESTS, QueueTests))
#define QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUEUE_TESTS, QueueTestsClass))
#define IS_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUEUE_TESTS))
#define IS_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUEUE_TESTS))
#define QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUEUE_TESTS, QueueTestsClass))

typedef struct _QueueTests QueueTests;
typedef struct _QueueTestsClass QueueTestsClass;
typedef struct _QueueTestsPrivate QueueTestsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _QueueTests {
	CollectionTests parent_instance;
	QueueTestsPrivate * priv;
};

struct _QueueTestsClass {
	CollectionTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer queue_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType queue_tests_get_type (void) G_GNUC_CONST;
enum  {
	QUEUE_TESTS_DUMMY_PROPERTY
};
QueueTests* queue_tests_construct (GType object_type, const char* name);
CollectionTests* collection_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void queue_tests_test_capacity_bound (QueueTests* self);
static void _queue_tests_test_capacity_bound_gee_test_case_test_method (gpointer self);
void queue_tests_test_one_element_operation (QueueTests* self);
static void _queue_tests_test_one_element_operation_gee_test_case_test_method (gpointer self);
void queue_tests_test_gobject_properties (QueueTests* self);
static void _queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _queue_tests_test_capacity_bound_gee_test_case_test_method (gpointer self) {
	queue_tests_test_capacity_bound (self);
}


static void _queue_tests_test_one_element_operation_gee_test_case_test_method (gpointer self) {
	queue_tests_test_one_element_operation (self);
}


static void _queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	queue_tests_test_gobject_properties (self);
}


QueueTests* queue_tests_construct (GType object_type, const char* name) {
	QueueTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QueueTests*) collection_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] capacity bound", _queue_tests_test_capacity_bound_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] one element operation", _queue_tests_test_one_element_operation_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Queue] GObject properties", _queue_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void queue_tests_test_capacity_bound (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* test_queue;
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL));
	g_assert (test_queue != NULL);
	if (gee_queue_get_capacity (test_queue) == GEE_QUEUE_UNBOUNDED_CAPACITY) {
		g_assert (gee_queue_get_remaining_capacity (test_queue) == GEE_QUEUE_UNBOUNDED_CAPACITY);
		g_assert (!gee_queue_get_is_full (test_queue));
	} else {
		gint capacity;
		g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
		capacity = gee_queue_get_capacity (test_queue);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						i++;
					}
					_tmp1_ = FALSE;
					if (!(i <= capacity)) {
						break;
					}
					g_assert (!gee_queue_get_is_full (test_queue));
					g_assert (gee_queue_offer (test_queue, "one"));
					g_assert (gee_queue_get_remaining_capacity (test_queue) == (capacity - i));
				}
			}
		}
		g_assert (gee_queue_get_is_full (test_queue));
		{
			gint i;
			i = 1;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					char* _tmp3_;
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i <= capacity)) {
						break;
					}
					g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_queue_poll (test_queue), "one") == 0);
					_g_free0 (_tmp3_);
					g_assert (!gee_queue_get_is_full (test_queue));
					g_assert (gee_queue_get_remaining_capacity (test_queue) == i);
				}
			}
		}
		g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
	}
	_g_object_unref0 (test_queue);
}


void queue_tests_test_one_element_operation (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* test_queue;
	GeeArrayList* recipient;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL));
	recipient = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (test_queue != NULL);
	g_assert (gee_queue_offer (test_queue, "one"));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_queue_peek (test_queue), "one") == 0);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_queue) == 1);
	g_assert (!gee_collection_get_is_empty ((GeeCollection*) test_queue));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_queue_poll (test_queue), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_queue) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
	g_assert ((_tmp3_ = (char*) gee_queue_peek (test_queue)) == NULL);
	_g_free0 (_tmp3_);
	g_assert ((_tmp4_ = (char*) gee_queue_poll (test_queue)) == NULL);
	_g_free0 (_tmp4_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_queue_offer (test_queue, "one"));
	g_assert (gee_queue_drain (test_queue, (GeeCollection*) recipient, 1) == 1);
	g_assert (gee_collection_get_size ((GeeCollection*) test_queue) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 1);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 0), "one") == 0);
	_g_free0 (_tmp5_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_queue_drain (test_queue, (GeeCollection*) recipient, 1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_queue) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_queue_offer (test_queue, "one"));
	g_assert (gee_queue_drain (test_queue, (GeeCollection*) recipient, -1) == 1);
	g_assert (gee_collection_get_size ((GeeCollection*) test_queue) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) test_queue));
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 1);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 0), "one") == 0);
	_g_free0 (_tmp6_);
	_g_object_unref0 (recipient);
	_g_object_unref0 (test_queue);
}


void queue_tests_test_gobject_properties (QueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* test_queue;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_;
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL));
	g_assert (test_queue != NULL);
	value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_INT), _tmp1_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	g_object_get_property ((GObject*) test_queue, "capacity", &value);
	g_assert (g_value_get_int (&value) == gee_queue_get_capacity (test_queue));
	g_value_unset (&value);
	value = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_INT), _tmp3_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
	g_object_get_property ((GObject*) test_queue, "remaining-capacity", &value);
	g_assert (g_value_get_int (&value) == gee_queue_get_remaining_capacity (test_queue));
	g_value_unset (&value);
	value = (_tmp6_ = (g_value_init (&_tmp5_, G_TYPE_BOOLEAN), _tmp5_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp6_);
	g_object_get_property ((GObject*) test_queue, "is-full", &value);
	g_assert (g_value_get_boolean (&value) == gee_queue_get_is_full (test_queue));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_object_unref0 (test_queue);
}


static void queue_tests_class_init (QueueTestsClass * klass) {
	queue_tests_parent_class = g_type_class_peek_parent (klass);
}


static void queue_tests_instance_init (QueueTests * self) {
}


GType queue_tests_get_type (void) {
	static volatile gsize queue_tests_type_id__volatile = 0;
	if (g_once_init_enter (&queue_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (QueueTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) queue_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QueueTests), 0, (GInstanceInitFunc) queue_tests_instance_init, NULL };
		GType queue_tests_type_id;
		queue_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "QueueTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&queue_tests_type_id__volatile, queue_tests_type_id);
	}
	return queue_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




