/* abstractmap.c generated by valac, the Vala compiler
 * generated from abstractmap.vala, do not modify */

/* abstractmap.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Tomaž Vajngerl <quikee@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_MAP (gee_abstract_map_get_type ())
#define GEE_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap))
#define GEE_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))
#define GEE_IS_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_MAP))
#define GEE_IS_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_MAP))
#define GEE_ABSTRACT_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))

typedef struct _GeeAbstractMap GeeAbstractMap;
typedef struct _GeeAbstractMapClass GeeAbstractMapClass;
typedef struct _GeeAbstractMapPrivate GeeAbstractMapPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
};

struct _GeeAbstractMap {
	GObject parent_instance;
	GeeAbstractMapPrivate * priv;
};

struct _GeeAbstractMapClass {
	GObjectClass parent_class;
	GeeSet* (*get_keys) (GeeAbstractMap* self);
	GeeCollection* (*get_values) (GeeAbstractMap* self);
	gboolean (*contains) (GeeAbstractMap* self, gconstpointer key);
	gpointer (*get) (GeeAbstractMap* self, gconstpointer key);
	void (*set) (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (GeeAbstractMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeAbstractMap* self);
	void (*set_all) (GeeAbstractMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeAbstractMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeAbstractMap* self, GeeMap* map);
	gint (*get_size) (GeeAbstractMap* self);
	gboolean (*get_is_empty) (GeeAbstractMap* self);
};

struct _GeeAbstractMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};


static gpointer gee_abstract_map_parent_class = NULL;
static GeeMapIface* gee_abstract_map_gee_map_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_set_get_type (void);
GType gee_map_get_type (void);
GType gee_abstract_map_get_type (void);
#define GEE_ABSTRACT_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapPrivate))
enum  {
	GEE_ABSTRACT_MAP_DUMMY_PROPERTY,
	GEE_ABSTRACT_MAP_SIZE,
	GEE_ABSTRACT_MAP_IS_EMPTY,
	GEE_ABSTRACT_MAP_K_TYPE,
	GEE_ABSTRACT_MAP_K_DUP_FUNC,
	GEE_ABSTRACT_MAP_K_DESTROY_FUNC,
	GEE_ABSTRACT_MAP_V_TYPE,
	GEE_ABSTRACT_MAP_V_DUP_FUNC,
	GEE_ABSTRACT_MAP_V_DESTROY_FUNC
};
GeeSet* gee_abstract_map_get_keys (GeeAbstractMap* self);
static GeeSet* gee_abstract_map_real_get_keys (GeeAbstractMap* self);
GeeCollection* gee_abstract_map_get_values (GeeAbstractMap* self);
static GeeCollection* gee_abstract_map_real_get_values (GeeAbstractMap* self);
gboolean gee_abstract_map_contains (GeeAbstractMap* self, gconstpointer key);
static gboolean gee_abstract_map_real_contains (GeeAbstractMap* self, gconstpointer key);
gpointer gee_abstract_map_get (GeeAbstractMap* self, gconstpointer key);
static gpointer gee_abstract_map_real_get (GeeAbstractMap* self, gconstpointer key);
void gee_abstract_map_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
static void gee_abstract_map_real_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value);
gboolean gee_abstract_map_remove (GeeAbstractMap* self, gconstpointer key, gpointer* value);
static gboolean gee_abstract_map_real_remove (GeeAbstractMap* self, gconstpointer key, gpointer* value);
void gee_abstract_map_clear (GeeAbstractMap* self);
static void gee_abstract_map_real_clear (GeeAbstractMap* self);
GeeSet* gee_map_get_keys (GeeMap* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
void gee_abstract_map_set_all (GeeAbstractMap* self, GeeMap* map);
static void gee_abstract_map_real_set_all (GeeAbstractMap* self, GeeMap* map);
gboolean gee_abstract_map_remove_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_remove_all (GeeAbstractMap* self, GeeMap* map);
gboolean gee_abstract_map_contains_all (GeeAbstractMap* self, GeeMap* map);
static gboolean gee_abstract_map_real_contains_all (GeeAbstractMap* self, GeeMap* map);
GeeAbstractMap* gee_abstract_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
gint gee_abstract_map_get_size (GeeAbstractMap* self);
gint gee_map_get_size (GeeMap* self);
gboolean gee_abstract_map_get_is_empty (GeeAbstractMap* self);
static void gee_abstract_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static GeeSet* gee_abstract_map_real_get_keys (GeeAbstractMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_get_keys'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeSet* gee_abstract_map_get_keys (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_keys (self);
}


static GeeCollection* gee_abstract_map_real_get_values (GeeAbstractMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_get_values'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeCollection* gee_abstract_map_get_values (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_values (self);
}


static gboolean gee_abstract_map_real_contains (GeeAbstractMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_map_contains (GeeAbstractMap* self, gconstpointer key) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->contains (self, key);
}


static gpointer gee_abstract_map_real_get (GeeAbstractMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer gee_abstract_map_get (GeeAbstractMap* self, gconstpointer key) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get (self, key);
}


static void gee_abstract_map_real_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_set'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_map_set (GeeAbstractMap* self, gconstpointer key, gconstpointer value) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->set (self, key, value);
}


static gboolean gee_abstract_map_real_remove (GeeAbstractMap* self, gconstpointer key, gpointer* value) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_map_remove (GeeAbstractMap* self, gconstpointer key, gpointer* value) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->remove (self, key, value);
}


static void gee_abstract_map_real_clear (GeeAbstractMap* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_map_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_map_clear (GeeAbstractMap* self) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->clear (self);
}


static void gee_abstract_map_real_set_all (GeeAbstractMap* self, GeeMap* map) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _key_it;
		_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			gpointer key;
			gpointer _tmp2_;
			if (!gee_iterator_next (_key_it)) {
				break;
			}
			key = gee_iterator_get (_key_it);
			gee_abstract_map_set (self, key, _tmp2_ = gee_map_get (map, key));
			((_tmp2_ == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_tmp2_ = (self->priv->v_destroy_func (_tmp2_), NULL));
			((key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (key = (self->priv->k_destroy_func (key), NULL));
		}
		_g_object_unref0 (_key_it);
	}
}


void gee_abstract_map_set_all (GeeAbstractMap* self, GeeMap* map) {
	GEE_ABSTRACT_MAP_GET_CLASS (self)->set_all (self, map);
}


static gboolean gee_abstract_map_real_remove_all (GeeAbstractMap* self, GeeMap* map) {
	gboolean result;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (map != NULL, FALSE);
	changed = FALSE;
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _key_it;
		_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			gpointer key;
			if (!gee_iterator_next (_key_it)) {
				break;
			}
			key = gee_iterator_get (_key_it);
			changed = changed | gee_abstract_map_remove (self, key, NULL);
			((key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (key = (self->priv->k_destroy_func (key), NULL));
		}
		_g_object_unref0 (_key_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_map_remove_all (GeeAbstractMap* self, GeeMap* map) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->remove_all (self, map);
}


static gboolean gee_abstract_map_real_contains_all (GeeAbstractMap* self, GeeMap* map) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (map != NULL, FALSE);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _key_it;
		_key_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys (map))), _g_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			gpointer key;
			if (!gee_iterator_next (_key_it)) {
				break;
			}
			key = gee_iterator_get (_key_it);
			if (!gee_abstract_map_contains (self, key)) {
				result = FALSE;
				((key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (key = (self->priv->k_destroy_func (key), NULL));
				_g_object_unref0 (_key_it);
				return result;
			}
			((key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (key = (self->priv->k_destroy_func (key), NULL));
		}
		_g_object_unref0 (_key_it);
	}
	result = TRUE;
	return result;
}


gboolean gee_abstract_map_contains_all (GeeAbstractMap* self, GeeMap* map) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->contains_all (self, map);
}


GeeAbstractMap* gee_abstract_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	GeeAbstractMap * self;
	self = (GeeAbstractMap*) g_object_new (object_type, NULL);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	return self;
}


gint gee_abstract_map_get_size (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_map_get_is_empty (GeeAbstractMap* self) {
	return GEE_ABSTRACT_MAP_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_map_real_get_is_empty (GeeAbstractMap* base) {
	gboolean result;
	GeeAbstractMap* self;
	self = base;
	result = gee_map_get_size ((GeeMap*) self) == 0;
	return result;
}


static void gee_abstract_map_class_init (GeeAbstractMapClass * klass) {
	gee_abstract_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractMapPrivate));
	GEE_ABSTRACT_MAP_CLASS (klass)->get_keys = gee_abstract_map_real_get_keys;
	GEE_ABSTRACT_MAP_CLASS (klass)->get_values = gee_abstract_map_real_get_values;
	GEE_ABSTRACT_MAP_CLASS (klass)->contains = gee_abstract_map_real_contains;
	GEE_ABSTRACT_MAP_CLASS (klass)->get = gee_abstract_map_real_get;
	GEE_ABSTRACT_MAP_CLASS (klass)->set = gee_abstract_map_real_set;
	GEE_ABSTRACT_MAP_CLASS (klass)->remove = gee_abstract_map_real_remove;
	GEE_ABSTRACT_MAP_CLASS (klass)->clear = gee_abstract_map_real_clear;
	GEE_ABSTRACT_MAP_CLASS (klass)->set_all = gee_abstract_map_real_set_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->remove_all = gee_abstract_map_real_remove_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->contains_all = gee_abstract_map_real_contains_all;
	GEE_ABSTRACT_MAP_CLASS (klass)->get_is_empty = gee_abstract_map_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_map_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MAP_IS_EMPTY, "is-empty");
}


static void gee_abstract_map_gee_map_interface_init (GeeMapIface * iface) {
	gee_abstract_map_gee_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keys = (GeeSet* (*)(GeeMap*)) gee_abstract_map_get_keys;
	iface->get_values = (GeeCollection* (*)(GeeMap*)) gee_abstract_map_get_values;
	iface->contains = (gboolean (*)(GeeMap* ,gconstpointer)) gee_abstract_map_contains;
	iface->get = (gpointer (*)(GeeMap* ,gconstpointer)) gee_abstract_map_get;
	iface->set = (void (*)(GeeMap* ,gconstpointer ,gconstpointer)) gee_abstract_map_set;
	iface->remove = (gboolean (*)(GeeMap* ,gconstpointer ,gpointer*)) gee_abstract_map_remove;
	iface->clear = (void (*)(GeeMap*)) gee_abstract_map_clear;
	iface->set_all = (void (*)(GeeMap* ,GeeMap*)) gee_abstract_map_set_all;
	iface->remove_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_abstract_map_remove_all;
	iface->contains_all = (gboolean (*)(GeeMap* ,GeeMap*)) gee_abstract_map_contains_all;
	iface->get_size = (gint (*) (GeeMap *)) gee_abstract_map_get_size;
	iface->get_is_empty = (gboolean (*) (GeeMap *)) gee_abstract_map_get_is_empty;
}


static void gee_abstract_map_instance_init (GeeAbstractMap * self) {
	self->priv = GEE_ABSTRACT_MAP_GET_PRIVATE (self);
}


GType gee_abstract_map_get_type (void) {
	static GType gee_abstract_map_type_id = 0;
	if (gee_abstract_map_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractMap), 0, (GInstanceInitFunc) gee_abstract_map_instance_init, NULL };
		static const GInterfaceInfo gee_map_info = { (GInterfaceInitFunc) gee_abstract_map_gee_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_abstract_map_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractMap", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_map_type_id, GEE_TYPE_MAP, &gee_map_info);
	}
	return gee_abstract_map_type_id;
}


static void gee_abstract_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractMap * self;
	self = GEE_ABSTRACT_MAP (object);
	switch (property_id) {
		case GEE_ABSTRACT_MAP_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_map_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractMap * self;
	self = GEE_ABSTRACT_MAP (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_MAP_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MAP_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MAP_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MAP_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}




