// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DICTDATABASE_H
#define _LIBGDAMM_DICTDATABASE_H


#include <glibmm.h>

/* $Id: dictdatabase.hg,v 1.1 2006/05/08 10:18:53 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* dictdatabase.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/object.h>
#include <libgdamm/xmlstorage.h>
#include <libgdamm/dicttable.h>
#include <libgdamm/dictfield.h>
#include <libgdamm/dictconstraint.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDictDatabase GdaDictDatabase;
typedef struct _GdaDictDatabaseClass GdaDictDatabaseClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DictDatabase_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Connection;

/** Represents a database structure in the DBMS server.
 * This object manages an internal dictionary mirroring the real database structure 
 * with objects such as DictTable (composed of Dictfield objects) and DictConstraint.
 * 
 * @ingroup Dictionaries.
 */

class DictDatabase
: public Gda::Object,
  public Gda::XmlStorage
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DictDatabase CppObjectType;
  typedef DictDatabase_Class CppClassType;
  typedef GdaDictDatabase BaseObjectType;
  typedef GdaDictDatabaseClass BaseClassType;

private:  friend class DictDatabase_Class;
  static CppClassType dictdatabase_class_;

private:
  // noncopyable
  DictDatabase(const DictDatabase&);
  DictDatabase& operator=(const DictDatabase&);

protected:
  explicit DictDatabase(const Glib::ConstructParams& construct_params);
  explicit DictDatabase(GdaDictDatabase* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DictDatabase();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDictDatabase*       gobj()       { return reinterpret_cast<GdaDictDatabase*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDictDatabase* gobj() const { return reinterpret_cast<GdaDictDatabase*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDictDatabase* gobj_copy();

private:

  
protected:

 DictDatabase();

public:
  
  static Glib::RefPtr<DictDatabase> create();


  /** Fetch the GdaDict object to which the GdaDictDatabase belongs.
   * @return The GdaDict object.
   */
  Glib::RefPtr<Dict> get_dict();
  
  /** Fetch the GdaDict object to which the GdaDictDatabase belongs.
   * @return The GdaDict object.
   */
  Glib::RefPtr<const Dict> get_dict() const;

  
  /** Synchronises the database representation with the database structure which is stored in
   * the DBMS. For this operation to succeed, the connection to the DBMS server MUST be opened
   * (using the corresponding Gda::Connection object).
   * @param limit_to_type Limit the DBMS update to this type, or 0 for no limit.
   * @param limit_obj_name Limit the DBMS update to objects of this name, or <tt>0</tt> for no limit.
   * @param error Location to store error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool update_dbms_data(GType limit_to_type, const Glib::ustring& limit_obj_name);
#else
  bool update_dbms_data(GType limit_to_type, const Glib::ustring& limit_obj_name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** When the database updates its internal lists of DBMS objects, a call to this function will 
   * stop that update process. It has no effect when the database is not updating its DBMS data.
   */
  void stop_update_dbms_data() const;

   
  /** Get a list of all the tables within @a db 
   * @return A new list of all the Gda::DictTable objects.
   */
  Glib::SListHandle<Glib::RefPtr<DictTable> > get_tables();
  
  /** Get a list of all the tables within @a db 
   * @return A new list of all the Gda::DictTable objects.
   */
  Glib::SListHandle<Glib::RefPtr<const DictTable> > get_tables() const;

  
  /** Get a reference to a GdaDictTable using its name.
   * @param name The name of the requested table.
   * @return The GdaDictTable pointer or <tt>0</tt> if the requested table does not exist.
   */
  Glib::RefPtr<DictTable> get_table_by_name(const Glib::ustring& name);;
  
  /** Get a reference to a GdaDictTable using its name.
   * @param name The name of the requested table.
   * @return The GdaDictTable pointer or <tt>0</tt> if the requested table does not exist.
   */
  Glib::RefPtr<const DictTable> get_table_by_name(const Glib::ustring& name) const;;

  
  /** Get a reference to a GdaDictTable using its XML id.
   * @param xml_id The XML id of the requested table.
   * @return The GdaDictTable pointer or <tt>0</tt> if the requested table does not exist.
   */
  Glib::RefPtr<DictTable> get_table_by_xml_id(const Glib::ustring& xml_id);
  
  /** Get a reference to a GdaDictTable using its XML id.
   * @param xml_id The XML id of the requested table.
   * @return The GdaDictTable pointer or <tt>0</tt> if the requested table does not exist.
   */
  Glib::RefPtr<const DictTable> get_table_by_xml_id(const Glib::ustring& xml_id) const;

  
  /** Get a reference to a GdaDictField specifying the full name (table_name.field_name)
   * of the requested field.
   * @param fullname The name of the requested table field.
   * @return The GdaDictField pointer or <tt>0</tt> if the requested field does not exist.
   */
  Glib::RefPtr<DictField> get_field_by_name(const Glib::ustring& fullname);
  
  /** Get a reference to a GdaDictField specifying the full name (table_name.field_name)
   * of the requested field.
   * @param fullname The name of the requested table field.
   * @return The GdaDictField pointer or <tt>0</tt> if the requested field does not exist.
   */
  Glib::RefPtr<const DictField> get_field_by_name(const Glib::ustring& fullname) const;

  
  /** Get a reference to a GdaDictField specifying its XML id
   * @param xml_id The XML id of the requested table field.
   * @return The GdaDictField pointer or <tt>0</tt> if the requested field does not exist.
   */
  Glib::RefPtr<DictField> get_field_by_xml_id(const Glib::ustring& xml_id);
  
  /** Get a reference to a GdaDictField specifying its XML id
   * @param xml_id The XML id of the requested table field.
   * @return The GdaDictField pointer or <tt>0</tt> if the requested field does not exist.
   */
  Glib::RefPtr<const DictField> get_field_by_xml_id(const Glib::ustring& xml_id) const;

  
  /** Add the @a cstr  constraint to the database. The @a cstr  constraint is a user-defined constraint
   * (which is not part of the database structure itself).
   * @param cstr A Gda::DictConstraint.
   */
  void add_constraint(const Glib::RefPtr<DictConstraint>& cstr);

   
  /** Get a list of all the constraints applied to the database. Constraints are represented
   * as Gda::DictConstraint objects and represent any type of constraint.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<DictConstraint> > get_all_constraints();
  
  /** Get a list of all the constraints applied to the database. Constraints are represented
   * as Gda::DictConstraint objects and represent any type of constraint.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<const DictConstraint> > get_all_constraints() const;

  
  /** Get a list of all the constraints applied to the database which represent a foreign constrains. 
   * Constraints are represented as Gda::DictConstraint objects.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<DictConstraint> > get_all_fk_constraints();
  
  /** Get a list of all the constraints applied to the database which represent a foreign constrains. 
   * Constraints are represented as Gda::DictConstraint objects.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<const DictConstraint> > get_all_fk_constraints() const;

  
  /** Get all the constraints applicable to @a table 
   * @param table A Gda::DictTable, part of @a db .
   * @return A new GSList of Gda::DictConstraint objects.
   */
  Glib::SListHandle<Glib::RefPtr<DictConstraint> > get_table_constraints(const Glib::RefPtr<DictTable>& table);
  
  /** Get all the constraints applicable to @a table 
   * @param table A Gda::DictTable, part of @a db .
   * @return A new GSList of Gda::DictConstraint objects.
   */
  Glib::SListHandle<Glib::RefPtr<const DictConstraint> > get_table_constraints(const Glib::RefPtr<DictTable>& table) const;

  
  /** Get a list of all the constraints applied to the database which represent a foreign key constrains, between
   *  @a table1  and @a table2 . If @a table1  or @a table2  are <tt>0</tt>, then the returned foreign key constraints are the ones
   * between any table and @a table1  or @a table2 .
   * 
   * Constraints are represented as Gda::DictConstraint objects.
   * @param table1 A Gda::DictTable, or <tt>0</tt>.
   * @param table2 A Gda::DictTable, or <tt>0</tt>.
   * @param table1_has_fk <tt>true</tt> if the returned constraints are the one for which @a table1  contains the foreign key.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<DictConstraint> > get_tables_fk_constraints(const Glib::RefPtr<DictTable>& table1, const Glib::RefPtr<DictTable>& table2, bool table1_has_fk = true);
  
  /** Get a list of all the constraints applied to the database which represent a foreign key constrains, between
   *  @a table1  and @a table2 . If @a table1  or @a table2  are <tt>0</tt>, then the returned foreign key constraints are the ones
   * between any table and @a table1  or @a table2 .
   * 
   * Constraints are represented as Gda::DictConstraint objects.
   * @param table1 A Gda::DictTable, or <tt>0</tt>.
   * @param table2 A Gda::DictTable, or <tt>0</tt>.
   * @param table1_has_fk <tt>true</tt> if the returned constraints are the one for which @a table1  contains the foreign key.
   * @return A new list of the constraints.
   */
  Glib::SListHandle<Glib::RefPtr<const DictConstraint> > get_tables_fk_constraints(const Glib::RefPtr<DictTable>& table1, const Glib::RefPtr<DictTable>& table2, bool table1_has_fk = true) const;

  
/**
   * @par Prototype:
   * <tt>void %table_added(const Glib::RefPtr<DictTable>& table)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictTable>& > signal_table_added();

  
/**
   * @par Prototype:
   * <tt>void %table_removed(const Glib::RefPtr<DictTable>& table)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictTable>& > signal_table_removed();

  
/**
   * @par Prototype:
   * <tt>void %table_updated(const Glib::RefPtr<DictTable>& table)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictTable>& > signal_table_updated();

  
/**
   * @par Prototype:
   * <tt>void %field_added(const Glib::RefPtr<DictField>& field)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictField>& > signal_field_added();

  
/**
   * @par Prototype:
   * <tt>void %field_removed(const Glib::RefPtr<DictField>& field)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictField>& > signal_field_removed();

  
/**
   * @par Prototype:
   * <tt>void %field_updated(const Glib::RefPtr<DictField>& field)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictField>& > signal_field_updated();

  
/**
   * @par Prototype:
   * <tt>void %constraint_added(const Glib::RefPtr<DictConstraint>& constraint)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictConstraint>& > signal_constraint_added();

  
/**
   * @par Prototype:
   * <tt>void %constraint_removed(const Glib::RefPtr<DictConstraint>& constraint)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictConstraint>& > signal_constraint_removed();

  
/**
   * @par Prototype:
   * <tt>void %constraint_updated(const Glib::RefPtr<DictConstraint>& constraint)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DictConstraint>& > signal_constraint_updated();

  
/**
   * @par Prototype:
   * <tt>void %data_update_started()</tt>
   */

  Glib::SignalProxy0< void > signal_data_update_started();

  // TODO: These ints should be unsigned int, but gmmproc bails out when using unsigned ints here. armin.
   

/**
   * @par Prototype:
   * <tt>void %update_progress(const Glib::ustring& msg, int now, int total)</tt>
   */

  Glib::SignalProxy3< void,const Glib::ustring&,int,int > signal_update_progress();

  
/**
   * @par Prototype:
   * <tt>void %data_update_finished()</tt>
   */

  Glib::SignalProxy0< void > signal_data_update_finished();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_table_added(const Glib::RefPtr<DictTable>& table);
  virtual void on_table_removed(const Glib::RefPtr<DictTable>& table);
  virtual void on_table_updated(const Glib::RefPtr<DictTable>& table);
  virtual void on_field_added(const Glib::RefPtr<DictField>& field);
  virtual void on_field_removed(const Glib::RefPtr<DictField>& field);
  virtual void on_field_updated(const Glib::RefPtr<DictField>& field);
  virtual void on_constraint_added(const Glib::RefPtr<DictConstraint>& constraint);
  virtual void on_constraint_removed(const Glib::RefPtr<DictConstraint>& constraint);
  virtual void on_constraint_updated(const Glib::RefPtr<DictConstraint>& constraint);
  virtual void on_data_update_started();
  virtual void on_update_progress(const Glib::ustring& msg, int now, int total);
  virtual void on_data_update_finished();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DictDatabase
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DictDatabase> wrap(GdaDictDatabase* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DICTDATABASE_H */

