/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-mock-logger.h"

#include "mock-logger.h"

START_TEST(test_logger_new)
{
	/* prepare */
	MockLogger* logger = mock_logger_new ("SomeDomain");

	/* check */
	fail_unless (logger != NULL);

	/* cleanup */
	g_object_unref (logger);
}
END_TEST

TCase*
tcase_mock_logger_init (void)
{
	TCase* self = tcase_create ("initialization");
	tcase_add_test (self, test_logger_new);
	return self;
}

